/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class)})
public abstract class ArrayReadNormalizedNode
extends RubyNode {
    public ArrayReadNormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeRead(VirtualFrame var1, RubyBasicObject var2, int var3);

    @Specialization(guards={"isRubyArray(array)", "isNullArray(array)"})
    public RubyBasicObject readNull(RubyBasicObject array, int index) {
        return this.nil();
    }

    @Specialization(guards={"isRubyArray(array)", "isInBounds(array, index)", "isIntArray(array)"})
    public int readIntInBounds(RubyBasicObject array, int index) {
        return ((int[])ArrayNodes.getStore(array))[index];
    }

    @Specialization(guards={"isRubyArray(array)", "isInBounds(array, index)", "isLongArray(array)"})
    public long readLongInBounds(RubyBasicObject array, int index) {
        return ((long[])ArrayNodes.getStore(array))[index];
    }

    @Specialization(guards={"isRubyArray(array)", "isInBounds(array, index)", "isDoubleArray(array)"})
    public double readDoubleInBounds(RubyBasicObject array, int index) {
        return ((double[])ArrayNodes.getStore(array))[index];
    }

    @Specialization(guards={"isRubyArray(array)", "isInBounds(array, index)", "isObjectArray(array)"})
    public Object readObjectInBounds(RubyBasicObject array, int index) {
        return ((Object[])ArrayNodes.getStore(array))[index];
    }

    @Specialization(guards={"isRubyArray(array)", "!isInBounds(array, index)"})
    public RubyBasicObject readOutOfBounds(RubyBasicObject array, int index) {
        return this.nil();
    }

    protected static boolean isInBounds(RubyBasicObject array, int index) {
        return index >= 0 && index < ArrayNodes.getSize(array);
    }
}

