/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.RubyThread;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.ThreadPassNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.subsystems.SafepointAction;

@CoreClass(name="Thread")
public abstract class ThreadNodes {

    @CoreMethod(names={"abort_on_exception="}, required=1)
    public static abstract class SetAbortOnExceptionNode
    extends CoreMethodArrayArgumentsNode {
        public SetAbortOnExceptionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject setAbortOnException(RubyThread self, boolean abortOnException) {
            self.setAbortOnException(abortOnException);
            return this.nil();
        }
    }

    @CoreMethod(names={"abort_on_exception"})
    public static abstract class AbortOnExceptionNode
    extends CoreMethodArrayArgumentsNode {
        public AbortOnExceptionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean abortOnException(RubyThread self) {
            return self.isAbortOnException();
        }
    }

    @CoreMethod(names={"wakeup", "run"})
    public static abstract class WakeupNode
    extends CoreMethodArrayArgumentsNode {
        public WakeupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyThread wakeup(RubyThread thread) {
            if (thread.getStatus() == RubyThread.Status.DEAD) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().threadError("killed thread", this));
            }
            thread.wakeup();
            return thread;
        }
    }

    @CoreMethod(names={"value"})
    public static abstract class ValueNode
    extends CoreMethodArrayArgumentsNode {
        public ValueNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object value(RubyThread self) {
            self.join();
            return self.getValue();
        }
    }

    @CoreMethod(names={"stop?"})
    public static abstract class StopNode
    extends CoreMethodArrayArgumentsNode {
        public StopNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean stop(RubyThread self) {
            return self.getStatus() == RubyThread.Status.DEAD || self.getStatus() == RubyThread.Status.SLEEP;
        }
    }

    @CoreMethod(names={"status"})
    public static abstract class StatusNode
    extends CoreMethodArrayArgumentsNode {
        public StatusNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object status(RubyThread self) {
            if (self.getStatus() == RubyThread.Status.DEAD) {
                if (self.getException() != null) {
                    return this.nil();
                }
                return false;
            }
            return this.createString(self.getStatus().bytes);
        }
    }

    @CoreMethod(names={"raise"}, required=1, optional=1)
    public static abstract class RaiseNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode initialize;

        public RaiseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.initialize = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization(guards={"isRubyString(message)"})
        public RubyBasicObject raise(VirtualFrame frame, RubyThread thread, RubyBasicObject message, NotProvided unused) {
            return this.raise(frame, thread, this.getContext().getCoreLibrary().getRuntimeErrorClass(), message);
        }

        @Specialization
        public RubyBasicObject raise(VirtualFrame frame, RubyThread thread, RubyClass exceptionClass, NotProvided message) {
            return this.raise(frame, thread, exceptionClass, this.createEmptyString());
        }

        @Specialization(guards={"isRubyString(message)"})
        public RubyBasicObject raise(VirtualFrame frame, RubyThread thread, RubyClass exceptionClass, RubyBasicObject message) {
            RubyBasicObject exception = exceptionClass.allocate(this);
            this.initialize.call(frame, exception, "initialize", null, message);
            if (!(exception instanceof RubyException)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("exception class/object expected", this));
            }
            final RaiseException exceptionWrapper = new RaiseException((RubyException)exception);
            this.getContext().getSafepointManager().pauseThreadAndExecuteLater(thread.getCurrentFiberJavaThread(), this, new SafepointAction(){

                @Override
                public void run(RubyThread currentThread, Node currentNode) {
                    throw exceptionWrapper;
                }
            });
            return this.nil();
        }
    }

    @CoreMethod(names={"pass"}, onSingleton=true)
    public static abstract class PassNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        ThreadPassNode threadPassNode;

        public PassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.threadPassNode = new ThreadPassNode(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject pass(VirtualFrame frame) {
            this.threadPassNode.executeVoid(frame);
            return this.nil();
        }
    }

    @CoreMethod(names={"main"}, onSingleton=true)
    public static abstract class MainNode
    extends CoreMethodArrayArgumentsNode {
        public MainNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyThread main() {
            return this.getContext().getThreadManager().getRootThread();
        }
    }

    @CoreMethod(names={"join"}, optional=1)
    public static abstract class JoinNode
    extends CoreMethodArrayArgumentsNode {
        public JoinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyThread join(RubyThread thread, NotProvided timeout) {
            thread.join();
            return thread;
        }

        @Specialization(guards={"isNil(nil)"})
        public RubyThread join(RubyThread thread, Object nil) {
            return this.join(thread, NotProvided.INSTANCE);
        }

        @Specialization
        public Object join(RubyThread thread, int timeout) {
            return this.joinMillis(thread, timeout * 1000);
        }

        @Specialization
        public Object join(RubyThread thread, double timeout) {
            return this.joinMillis(thread, (int)(timeout * 1000.0));
        }

        private Object joinMillis(RubyThread self, int timeoutInMillis) {
            if (self.join(timeoutInMillis)) {
                return self;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize"}, argumentsAsArray=true, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public RubyBasicObject initialize(RubyThread thread, Object[] arguments, RubyBasicObject block) {
            thread.initialize(this.getContext(), (Node)this, arguments, block);
            return this.nil();
        }
    }

    @CoreMethod(names={"handle_interrupt"}, required=2, needsBlock=true, visibility=Visibility.PRIVATE)
    public static abstract class HandleInterruptNode
    extends YieldingCoreMethodNode {
        private final RubyBasicObject immediateSymbol = this.getContext().getSymbol("immediate");
        private final RubyBasicObject onBlockingSymbol = this.getContext().getSymbol("on_blocking");
        private final RubyBasicObject neverSymbol = this.getContext().getSymbol("never");

        public HandleInterruptNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isRubySymbol(timing)", "isRubyProc(block)"})
        public Object handle_interrupt(VirtualFrame frame, RubyThread self, RubyClass exceptionClass, RubyBasicObject timing, RubyBasicObject block) {
            RubyThread.InterruptMode newInterruptMode = this.symbolToInterruptMode(timing);
            RubyThread.InterruptMode oldInterruptMode = self.getInterruptMode();
            self.setInterruptMode(newInterruptMode);
            try {
                Object object = this.yield(frame, block, new Object[0]);
                return object;
            }
            finally {
                self.setInterruptMode(oldInterruptMode);
            }
        }

        private RubyThread.InterruptMode symbolToInterruptMode(RubyBasicObject symbol) {
            if (symbol == this.immediateSymbol) {
                return RubyThread.InterruptMode.IMMEDIATE;
            }
            if (symbol == this.onBlockingSymbol) {
                return RubyThread.InterruptMode.ON_BLOCKING;
            }
            if (symbol == this.neverSymbol) {
                return RubyThread.InterruptMode.NEVER;
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("invalid timing symbol", this));
        }
    }

    @CoreMethod(names={"kill", "exit", "terminate"})
    public static abstract class KillNode
    extends CoreMethodArrayArgumentsNode {
        public KillNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyThread kill(RubyThread rubyThread) {
            Thread toKill = rubyThread.getRootFiberJavaThread();
            this.getContext().getSafepointManager().pauseThreadAndExecuteLater(toKill, this, new SafepointAction(){

                @Override
                public void run(RubyThread currentThread, Node currentNode) {
                    currentThread.shutdown();
                }
            });
            return rubyThread;
        }
    }

    @CoreMethod(names={"current"}, onSingleton=true)
    public static abstract class CurrentNode
    extends CoreMethodArrayArgumentsNode {
        public CurrentNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyThread current() {
            return this.getContext().getThreadManager().getCurrentThread();
        }
    }

    @CoreMethod(names={"alive?"})
    public static abstract class AliveNode
    extends CoreMethodArrayArgumentsNode {
        public AliveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean alive(RubyThread thread) {
            return thread.getStatus() != RubyThread.Status.ABORTING && thread.getStatus() != RubyThread.Status.DEAD;
        }
    }
}

