/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.object.BasicObjectType;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

@CoreClass(name="Mutex")
public abstract class MutexNodes {
    public static final MutexType MUTEX_TYPE = new MutexType();
    private static final HiddenKey LOCK_IDENTIFIER = new HiddenKey("lock");
    private static final Property LOCK_PROPERTY;
    private static final DynamicObjectFactory MUTEX_FACTORY;

    protected static ReentrantLock getLock(RubyBasicObject mutex) {
        assert (mutex.getDynamicObject().getShape().hasProperty(LOCK_IDENTIFIER));
        return (ReentrantLock)LOCK_PROPERTY.get(mutex.getDynamicObject(), true);
    }

    static {
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        LOCK_PROPERTY = Property.create(LOCK_IDENTIFIER, allocator.locationForType(ReentrantLock.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), 0);
        Shape shape = RubyBasicObject.LAYOUT.createShape(MUTEX_TYPE).addProperty(LOCK_PROPERTY);
        MUTEX_FACTORY = shape.createFactory();
    }

    @CoreMethod(names={"sleep"}, optional=1)
    public static abstract class SleepNode
    extends CoreMethodArrayArgumentsNode {
        public SleepNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long sleep(RubyBasicObject mutex, NotProvided duration) {
            return this.doSleepMillis(mutex, Integer.MAX_VALUE);
        }

        @Specialization(guards={"isNil(duration)"})
        public long sleep(RubyBasicObject mutex, RubyBasicObject duration) {
            return this.sleep(mutex, NotProvided.INSTANCE);
        }

        @Specialization
        public long sleep(RubyBasicObject mutex, long duration) {
            return this.doSleepMillis(mutex, duration * 1000L);
        }

        @Specialization
        public long sleep(RubyBasicObject mutex, double duration) {
            return this.doSleepMillis(mutex, (long)(duration * 1000.0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long doSleepMillis(RubyBasicObject mutex, long durationInMillis) {
            if (durationInMillis < 0L) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("time interval must be positive", this));
            }
            ReentrantLock lock = MutexNodes.getLock(mutex);
            RubyThread thread = this.getContext().getThreadManager().getCurrentThread();
            thread.shouldWakeUp();
            UnlockNode.unlock(lock, thread, this);
            try {
                long l = KernelNodes.SleepNode.sleepFor(this.getContext(), durationInMillis);
                return l;
            }
            finally {
                LockNode.lock(lock, thread, this);
            }
        }
    }

    @CoreMethod(names={"unlock"})
    public static abstract class UnlockNode
    extends UnaryCoreMethodNode {
        public UnlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject unlock(RubyBasicObject mutex) {
            ReentrantLock lock = MutexNodes.getLock(mutex);
            RubyThread thread = this.getContext().getThreadManager().getCurrentThread();
            UnlockNode.unlock(lock, thread, this);
            return mutex;
        }

        protected static void unlock(ReentrantLock lock, RubyThread thread, RubyNode currentNode) {
            RubyContext context = currentNode.getContext();
            try {
                lock.unlock();
            }
            catch (IllegalMonitorStateException e) {
                if (!lock.isLocked()) {
                    throw new RaiseException(context.getCoreLibrary().threadError("Attempt to unlock a mutex which is not locked", currentNode));
                }
                throw new RaiseException(context.getCoreLibrary().threadError("Attempt to unlock a mutex which is locked by another thread", currentNode));
            }
            thread.releasedLock(lock);
        }
    }

    @CoreMethod(names={"try_lock"})
    public static abstract class TryLockNode
    extends UnaryCoreMethodNode {
        public TryLockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean tryLock(RubyBasicObject mutex) {
            ReentrantLock lock = MutexNodes.getLock(mutex);
            if (lock.isHeldByCurrentThread()) {
                return false;
            }
            if (lock.tryLock()) {
                RubyThread thread = this.getContext().getThreadManager().getCurrentThread();
                thread.acquiredLock(lock);
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"owned?"})
    public static abstract class IsOwnedNode
    extends UnaryCoreMethodNode {
        public IsOwnedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isOwned(RubyBasicObject mutex) {
            return MutexNodes.getLock(mutex).isHeldByCurrentThread();
        }
    }

    @CoreMethod(names={"locked?"})
    public static abstract class IsLockedNode
    extends UnaryCoreMethodNode {
        public IsLockedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isLocked(RubyBasicObject mutex) {
            return MutexNodes.getLock(mutex).isLocked();
        }
    }

    @CoreMethod(names={"lock"})
    public static abstract class LockNode
    extends UnaryCoreMethodNode {
        public LockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject lock(RubyBasicObject mutex) {
            ReentrantLock lock = MutexNodes.getLock(mutex);
            RubyThread thread = this.getContext().getThreadManager().getCurrentThread();
            LockNode.lock(lock, thread, this);
            return mutex;
        }

        protected static void lock(final ReentrantLock lock, final RubyThread thread, RubyNode currentNode) {
            RubyContext context = currentNode.getContext();
            if (lock.isHeldByCurrentThread()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(context.getCoreLibrary().threadError("deadlock; recursive locking", currentNode));
            }
            context.getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    lock.lockInterruptibly();
                    thread.acquiredLock(lock);
                    return true;
                }
            });
        }
    }

    public static class MutexAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyBasicObject(rubyClass, MUTEX_FACTORY.newInstance(new ReentrantLock()));
        }
    }

    private static class MutexType
    extends BasicObjectType {
        private MutexType() {
        }
    }
}

