/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.Arrays;
import org.joni.exception.ValueException;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.TaintResultNode;
import org.jruby.truffle.nodes.coerce.ToIntNode;
import org.jruby.truffle.nodes.coerce.ToIntNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyMatchData;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.util.ByteList;

@CoreClass(name="MatchData")
public abstract class MatchDataNodes {

    @NodeChild(value="self")
    public static abstract class RubiniusSourceNode
    extends RubyNode {
        public RubiniusSourceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject rubiniusSource(RubyMatchData matchData) {
            return matchData.getSource();
        }
    }

    @CoreMethod(names={"regexp"})
    public static abstract class RegexpNode
    extends CoreMethodArrayArgumentsNode {
        public RegexpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject regexp(RubyMatchData matchData) {
            return matchData.getRegexp();
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject toS(RubyMatchData matchData) {
            CompilerDirectives.transferToInterpreter();
            ByteList bytes = StringNodes.getByteList(matchData.getGlobal()).dup();
            return this.createString(bytes);
        }
    }

    @CoreMethod(names={"to_a"})
    public static abstract class ToANode
    extends CoreMethodArrayArgumentsNode {
        public ToANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject toA(RubyMatchData matchData) {
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), matchData.getValues());
        }
    }

    @CoreMethod(names={"post_match"})
    public static abstract class PostMatchNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintResultNode taintResultNode = new TaintResultNode(this.getContext(), this.getSourceSection());

        public PostMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object postMatch(RubyMatchData matchData) {
            return this.taintResultNode.maybeTaint(matchData.getSource(), matchData.getPost());
        }
    }

    @CoreMethod(names={"pre_match"})
    public static abstract class PreMatchNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintResultNode taintResultNode = new TaintResultNode(this.getContext(), this.getSourceSection());

        public PreMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object preMatch(RubyMatchData matchData) {
            return this.taintResultNode.maybeTaint(matchData.getSource(), matchData.getPre());
        }
    }

    @CoreMethod(names={"length", "size"})
    public static abstract class LengthNode
    extends CoreMethodArrayArgumentsNode {
        public LengthNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int length(RubyMatchData matchData) {
            return matchData.getValues().length;
        }
    }

    @CoreMethod(names={"full"})
    public static abstract class FullNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode newTupleNode;

        public FullNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object full(VirtualFrame frame, RubyMatchData matchData) {
            if (matchData.getFullTuple() != null) {
                return matchData.getFullTuple();
            }
            if (this.newTupleNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.newTupleNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object fullTuple = this.newTupleNode.call(frame, this.getContext().getCoreLibrary().getTupleClass(), "create", null, matchData.getFullBegin(), matchData.getFullEnd());
            matchData.setFullTuple(fullTuple);
            return fullTuple;
        }
    }

    @CoreMethod(names={"end"}, required=1, lowerFixnumParameters={1})
    public static abstract class EndNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile badIndexProfile = ConditionProfile.createBinaryProfile();

        public EndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object end(RubyMatchData matchData, int index) {
            CompilerDirectives.transferToInterpreter();
            if (this.badIndexProfile.profile(index < 0 || index >= matchData.getNumberOfRegions())) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of matches", index), this));
            }
            return matchData.end(index);
        }
    }

    @CoreMethod(names={"captures"})
    public static abstract class CapturesNode
    extends CoreMethodArrayArgumentsNode {
        public CapturesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject toA(RubyMatchData matchData) {
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), matchData.getCaptures());
        }
    }

    @CoreMethod(names={"begin"}, required=1, lowerFixnumParameters={1})
    public static abstract class BeginNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile badIndexProfile = ConditionProfile.createBinaryProfile();

        public BeginNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object begin(RubyMatchData matchData, int index) {
            CompilerDirectives.transferToInterpreter();
            if (this.badIndexProfile.profile(index < 0 || index >= matchData.getNumberOfRegions())) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of matches", index), this));
            }
            return matchData.begin(index);
        }
    }

    @CoreMethod(names={"[]"}, required=1, optional=1, lowerFixnumParameters={0}, taintFromSelf=true)
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToIntNode toIntNode;

        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object getIndex(RubyMatchData matchData, int index, NotProvided length) {
            CompilerDirectives.transferToInterpreter();
            Object[] values = matchData.getValues();
            int normalizedIndex = ArrayNodes.normalizeIndex(values.length, index);
            if (normalizedIndex < 0 || normalizedIndex >= values.length) {
                return this.nil();
            }
            return values[normalizedIndex];
        }

        @Specialization
        public Object getIndex(RubyMatchData matchData, int index, int length) {
            CompilerDirectives.transferToInterpreter();
            Object[] values = matchData.getValues();
            int normalizedIndex = ArrayNodes.normalizeIndex(values.length, index);
            Object[] store = Arrays.copyOfRange(values, normalizedIndex, normalizedIndex + length);
            return this.createArray(store, length);
        }

        @Specialization(guards={"isRubySymbol(index)"})
        public Object getIndexSymbol(RubyMatchData matchData, RubyBasicObject index, NotProvided length) {
            CompilerDirectives.transferToInterpreter();
            try {
                int i = matchData.getBackrefNumber(SymbolNodes.getByteList(index));
                return this.getIndex(matchData, i, NotProvided.INSTANCE);
            }
            catch (ValueException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("undefined group name reference: %s", SymbolNodes.getString(index)), this));
            }
        }

        @Specialization(guards={"isRubyString(index)"})
        public Object getIndexString(RubyMatchData matchData, RubyBasicObject index, NotProvided length) {
            CompilerDirectives.transferToInterpreter();
            try {
                int i = matchData.getBackrefNumber(StringNodes.getByteList(index));
                return this.getIndex(matchData, i, NotProvided.INSTANCE);
            }
            catch (ValueException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("undefined group name reference: %s", index.toString()), this));
            }
        }

        @Specialization(guards={"!isRubySymbol(index)", "!isRubyString(index)", "!isIntegerFixnumRange(index)"})
        public Object getIndex(VirtualFrame frame, RubyMatchData matchData, Object index, NotProvided length) {
            CompilerDirectives.transferToInterpreter();
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.getIndex(matchData, this.toIntNode.doInt(frame, index), NotProvided.INSTANCE);
        }

        @Specialization(guards={"!isRubySymbol(range)", "!isRubyString(range)"})
        public Object getIndex(VirtualFrame frame, RubyMatchData matchData, RubyRange.IntegerFixnumRange range, NotProvided len) {
            Object[] values = matchData.getValues();
            int normalizedIndex = ArrayNodes.normalizeIndex(values.length, range.getBegin());
            int end = ArrayNodes.normalizeIndex(values.length, range.getEnd());
            int exclusiveEnd = ArrayNodes.clampExclusiveIndex(values.length, range.doesExcludeEnd() ? end : end + 1);
            int length = exclusiveEnd - normalizedIndex;
            Object[] store = Arrays.copyOfRange(values, normalizedIndex, normalizedIndex + length);
            return this.createArray(store, length);
        }
    }
}

