/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.ByteBuffer;
import jnr.ffi.Runtime;
import jnr.ffi.provider.MemoryManager;
import jnr.posix.POSIX;
import org.jcodings.Encoding;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.core.BindingNodes;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.instrument.RubyWrapperNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.sockets.NativeSockets;
import org.jruby.util.ByteList;

@ImportStatic(value={RubyGuards.class})
@TypeSystemReference(value=RubyTypes.class)
public abstract class RubyNode
extends Node {
    private final RubyContext context;
    private boolean atNewline = false;

    public RubyNode(RubyContext context, SourceSection sourceSection) {
        super(sourceSection);
        assert (context != null);
        this.context = context;
    }

    public abstract Object execute(VirtualFrame var1);

    public Object isDefined(VirtualFrame frame) {
        return StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), "expression");
    }

    public void executeVoid(VirtualFrame frame) {
        this.execute(frame);
    }

    public NotProvided executeNotProvided(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof NotProvided) {
            return (NotProvided)value;
        }
        throw new UnexpectedResultException(value);
    }

    public boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new UnexpectedResultException(value);
    }

    public int executeInteger(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    public long executeLong(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new UnexpectedResultException(value);
    }

    public RubyRange.IntegerFixnumRange executeIntegerFixnumRange(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof RubyRange.IntegerFixnumRange) {
            return (RubyRange.IntegerFixnumRange)value;
        }
        throw new UnexpectedResultException(value);
    }

    public RubyRange.LongFixnumRange executeLongFixnumRange(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof RubyRange.LongFixnumRange) {
            return (RubyRange.LongFixnumRange)value;
        }
        throw new UnexpectedResultException(value);
    }

    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new UnexpectedResultException(value);
    }

    public RubyModule executeRubyModule(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof RubyModule) {
            return (RubyModule)value;
        }
        throw new UnexpectedResultException(value);
    }

    public RubyHash executeRubyHash(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (RubyGuards.isRubyHash(value)) {
            return (RubyHash)value;
        }
        throw new UnexpectedResultException(value);
    }

    public RubyBasicObject executeRubyBasicObject(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof RubyBasicObject) {
            return (RubyBasicObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    public Object[] executeObjectArray(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        throw new UnexpectedResultException(value);
    }

    protected boolean isNil(Object value) {
        return value == this.nil();
    }

    protected boolean isRubiniusUndefined(Object value) {
        return value == this.getContext().getCoreLibrary().getRubiniusUndefined();
    }

    protected RubyBasicObject nil() {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    public RubyBasicObject getSymbol(String name) {
        return this.getContext().getSymbol(name);
    }

    public RubyBasicObject getSymbol(ByteList name) {
        return this.getContext().getSymbol(name);
    }

    protected RubyBasicObject createEmptyString() {
        return StringNodes.createEmptyString(this.getContext().getCoreLibrary().getStringClass());
    }

    protected RubyBasicObject createString(String string) {
        return StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), string);
    }

    protected RubyBasicObject createString(String string, Encoding encoding) {
        return StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), string, encoding);
    }

    protected RubyBasicObject createString(byte[] bytes) {
        return StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), bytes);
    }

    protected RubyBasicObject createString(ByteBuffer bytes) {
        return StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), bytes);
    }

    protected RubyBasicObject createString(ByteList bytes) {
        return StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), bytes);
    }

    protected RubyBasicObject createEmptyArray() {
        return ArrayNodes.createEmptyArray(this.getContext().getCoreLibrary().getArrayClass());
    }

    protected RubyBasicObject createArray(Object ... store) {
        return this.createArray(store, store.length);
    }

    protected RubyBasicObject createArray(int[] store, int size) {
        return ArrayNodes.createArray(this.getContext().getCoreLibrary().getArrayClass(), store, size);
    }

    protected RubyBasicObject createArray(long[] store, int size) {
        return ArrayNodes.createArray(this.getContext().getCoreLibrary().getArrayClass(), store, size);
    }

    protected RubyBasicObject createArray(double[] store, int size) {
        return ArrayNodes.createArray(this.getContext().getCoreLibrary().getArrayClass(), store, size);
    }

    protected RubyBasicObject createArray(Object[] store, int size) {
        return ArrayNodes.createArray(this.getContext().getCoreLibrary().getArrayClass(), store, size);
    }

    protected POSIX posix() {
        return this.getContext().getPosix();
    }

    protected NativeSockets nativeSockets() {
        return this.getContext().getNativeSockets();
    }

    protected static int getCacheLimit() {
        return DispatchNode.DISPATCH_POLYMORPHIC_MAX;
    }

    @Override
    public boolean isInstrumentable() {
        return true;
    }

    @Override
    public ProbeNode.WrapperNode createWrapperNode() {
        return new RubyWrapperNode(this);
    }

    public void setAtNewline() {
        this.atNewline = true;
    }

    public boolean isAtNewline() {
        return this.atNewline;
    }

    public RubyNode getNonProxyNode() {
        return this;
    }

    public RubyContext getContext() {
        return this.context;
    }

    public MemoryManager getMemoryManager() {
        return Runtime.getSystemRuntime().getMemoryManager();
    }

    protected Object ruby(VirtualFrame frame, String expression, Object ... arguments) {
        return this.rubyWithSelf(frame, RubyArguments.getSelf(frame.getArguments()), expression, arguments);
    }

    protected Object rubyWithSelf(VirtualFrame frame, Object self, String expression, Object ... arguments) {
        MaterializedFrame evalFrame = this.setupFrame(RubyArguments.getSelf(frame.getArguments()), arguments);
        RubyBasicObject binding = BindingNodes.createRubyBinding(this.getContext().getCoreLibrary().getBindingClass(), self, evalFrame);
        return this.getContext().eval(expression, binding, true, "inline-ruby", (Node)this);
    }

    @CompilerDirectives.TruffleBoundary
    private MaterializedFrame setupFrame(Object self, Object ... arguments) {
        MaterializedFrame evalFrame = Truffle.getRuntime().createMaterializedFrame(RubyArguments.pack(null, null, self, null, new Object[0]));
        if (arguments.length % 2 == 1) {
            throw new UnsupportedOperationException("odd number of name-value pairs for arguments");
        }
        for (int n = 0; n < arguments.length; n += 2) {
            evalFrame.setObject(evalFrame.getFrameDescriptor().findOrAddFrameSlot(arguments[n]), arguments[n + 1]);
        }
        return evalFrame;
    }
}

