/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

public final class TextTagParser {
    protected static final int MAX_KEY_LENGTH = Main.pref.getInteger("tags.paste.max-key-length", 50);
    protected static final int MAX_KEY_COUNT = Main.pref.getInteger("tags.paste.max-key-count", 30);
    protected static final String KEY_PATTERN = Main.pref.get("tags.paste.tag-pattern", "[0-9a-zA-Z:_]*");
    protected static final int MAX_VALUE_LENGTH = 255;

    private TextTagParser() {
    }

    protected static String unescape(String string) {
        if (!string.startsWith("\"") || !string.endsWith("\"")) {
            if (string.contains("=")) {
                return null;
            }
            return string;
        }
        String string2 = string.substring(1, string.length() - 1);
        return new TextAnalyzer(string2).parseString("\r\t\n");
    }

    public static Map<String, String> readTagsByRegexp(String string, String string2, String string3, boolean bl) {
        String[] stringArray = string.split(string2);
        Pattern pattern = Pattern.compile(string3);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string4 = null;
        String string5 = null;
        for (String string6 : stringArray) {
            if (string6.trim().isEmpty()) continue;
            Matcher matcher = pattern.matcher(string6);
            if (matcher.matches()) {
                string4 = matcher.group(1).trim();
                string5 = matcher.group(2).trim();
                if (bl) {
                    string4 = TextTagParser.unescape(string4);
                    string5 = TextTagParser.unescape(string5);
                    if (string4 == null || string5 == null) {
                        return null;
                    }
                }
                hashMap.put(string4, string5);
                continue;
            }
            return null;
        }
        if (!hashMap.isEmpty()) {
            return hashMap;
        }
        return null;
    }

    public static Map<String, String> getValidatedTagsFromText(String string) {
        Map<String, String> map = TextTagParser.readTagsFromText(string);
        return TextTagParser.validateTags(map) ? map : null;
    }

    public static Map<String, String> readTagsFromText(String string) {
        Map<String, String> map = TextTagParser.readTagsByRegexp(string, "[\\r\\n]+", ".*([a-zA-Z0-9:_]+).*\\t(.*?)", false);
        if (map != null) {
            return map;
        }
        map = TextTagParser.readTagsByRegexp(string, "[\\n\\t\\r]+", "(.*?)=(.*?)", true);
        if (map != null) {
            return map;
        }
        String string2 = string.trim();
        if (string2.startsWith("{") && string2.endsWith("}")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if ((map = TextTagParser.readTagsByRegexp(string2, "[\\s]*,[\\s]*", "[\\s]*(\\\".*?[^\\\\]\\\")[\\s]*:[\\s]*(\\\".*?[^\\\\]\\\")[\\s]*", true)) != null) {
            return map;
        }
        TextAnalyzer textAnalyzer = new TextAnalyzer(string);
        map = textAnalyzer.getFreeParsedTags();
        return map;
    }

    public static boolean validateTags(Map<String, String> map) {
        int n;
        int n2 = map.size();
        if (n2 > MAX_KEY_COUNT) {
            n = TextTagParser.warning(I18n.trn("There was {0} tag found in the buffer, it is suspicious!", "There were {0} tags found in the buffer, it is suspicious!", n2, n2), "", "tags.paste.toomanytags");
            if (n == 2 || n == 3) {
                return false;
            }
            if (n == 4) {
                return true;
            }
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string.length() > MAX_KEY_LENGTH) {
                n = TextTagParser.warning(I18n.tr("Key is too long (max {0} characters):", MAX_KEY_LENGTH), string + "=" + string2, "tags.paste.keytoolong");
                if (n == 2 || n == 3) {
                    return false;
                }
                if (n == 4) {
                    return true;
                }
            }
            if (!string.matches(KEY_PATTERN)) {
                n = TextTagParser.warning(I18n.tr("Suspicious characters in key:", new Object[0]), string, "tags.paste.keydoesnotmatch");
                if (n == 2 || n == 3) {
                    return false;
                }
                if (n == 4) {
                    return true;
                }
            }
            if (string2.length() <= 255) continue;
            n = TextTagParser.warning(I18n.tr("Value is too long (max {0} characters):", 255), string2, "tags.paste.valuetoolong");
            if (n == 2 || n == 3) {
                return false;
            }
            if (n != 4) continue;
            return true;
        }
        return true;
    }

    private static int warning(String string, String string2, String string3) {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Do you want to paste these tags?", new Object[0]), new String[]{I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Clear buffer", new Object[0]), I18n.tr("Ignore warnings", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"ok", "cancel", "dialogs/delete", "pastetags"});
        extendedDialog.setContent("<html><b>" + string + "</b><br/><br/><div width=\"300px\">" + XmlWriter.encode(string2, true) + "</html>");
        extendedDialog.setDefaultButton(2);
        extendedDialog.setCancelButton(2);
        extendedDialog.setIcon(2);
        extendedDialog.toggleEnable(string3);
        extendedDialog.showDialog();
        int n = extendedDialog.getValue();
        if (n == 0) {
            n = 2;
        }
        if (n == 3) {
            Utils.copyToClipboard("");
        }
        return n;
    }

    public static void showBadBufferMessage(String string) {
        String string2 = I18n.tr("<html><p> Sorry, it is impossible to paste tags from buffer. It does not contain any JOSM object or suitable text. </p></html>", new Object[0]);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(string2), GBC.eop());
        String string3 = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(string, LanguageInfo.LocaleType.DEFAULT));
        if (string3 != null) {
            jPanel.add((Component)new UrlLabel(string3), GBC.eop());
        }
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Warning", new Object[0]), new String[]{I18n.tr("Ok", new Object[0]), I18n.tr("Clear buffer", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"ok", "dialogs/delete"});
        extendedDialog.setContent(jPanel);
        extendedDialog.setDefaultButton(1);
        extendedDialog.setCancelButton(1);
        extendedDialog.setIcon(2);
        extendedDialog.toggleEnable("tags.paste.cleanbadbuffer");
        extendedDialog.showDialog();
        int n = extendedDialog.getValue();
        if (n == 2) {
            Utils.copyToClipboard("");
        }
    }

    public static class TextAnalyzer {
        private boolean quotesStarted = false;
        private boolean esc = false;
        private StringBuilder s = new StringBuilder(200);
        private int pos = 0;
        private String data;
        private int n;

        public TextAnalyzer(String string) {
            this.data = string;
            this.n = this.data.length();
        }

        Map<String, String> getFreeParsedTags() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (true) {
                this.skipEmpty();
                if (this.pos == this.n) break;
                String string = this.parseString("\n\r\t= ");
                if (this.pos == this.n) {
                    hashMap.clear();
                    break;
                }
                this.skipSign();
                if (this.pos == this.n) {
                    hashMap.clear();
                    break;
                }
                String string2 = this.parseString("\n\r\t ");
                hashMap.put(string, string2);
            }
            return hashMap;
        }

        private String parseString(String string) {
            char[] cArray = string.toCharArray();
            Arrays.sort(cArray);
            while (this.pos < this.n) {
                char c = this.data.charAt(this.pos);
                if (this.esc) {
                    this.esc = false;
                    this.s.append(c);
                } else if (c == '\\') {
                    this.esc = true;
                } else if (c == '\"' && !this.quotesStarted) {
                    if (this.s.toString().trim().length() > 0) {
                        this.s.append(c);
                    } else {
                        this.s.delete(0, this.s.length());
                        this.quotesStarted = true;
                    }
                } else {
                    if (c == '\"' && this.quotesStarted) {
                        this.quotesStarted = false;
                        ++this.pos;
                        break;
                    }
                    if (!this.quotesStarted && Arrays.binarySearch(cArray, c) >= 0) {
                        ++this.pos;
                        break;
                    }
                    if (c >= ' ') {
                        this.s.append(c);
                    }
                }
                ++this.pos;
            }
            String string2 = this.s.toString();
            this.s.delete(0, this.s.length());
            return string2.trim();
        }

        private void skipSign() {
            boolean bl = false;
            while (this.pos < this.n) {
                char c = this.data.charAt(this.pos);
                if (c == '\t' || c == '\n' || c == ' ') {
                    ++this.pos;
                    continue;
                }
                if (c != '=' || bl) break;
                bl = true;
                ++this.pos;
            }
        }

        private void skipEmpty() {
            char c;
            while (this.pos < this.n && ((c = this.data.charAt(this.pos)) == '\t' || c == '\n' || c == '\r' || c == ' ')) {
                ++this.pos;
            }
        }
    }
}

