/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.tools.Utils;

public class MultiMap<A, B> {
    private final Map<A, Set<B>> map;

    public MultiMap() {
        this.map = new HashMap<A, Set<B>>();
    }

    public MultiMap(int n) {
        this.map = new HashMap<A, Set<B>>(n);
    }

    public void put(A a, B b) {
        Set<B> set = this.map.get(a);
        if (set == null) {
            set = new LinkedHashSet<B>();
            this.map.put(a, set);
        }
        set.add(b);
    }

    public void putVoid(A a) {
        if (this.map.containsKey(a)) {
            return;
        }
        this.map.put(a, new LinkedHashSet());
    }

    public void putAll(A a, Collection<B> collection) {
        Set<B> set = this.map.get(a);
        if (set == null) {
            set = new LinkedHashSet<B>(collection);
            this.map.put(a, set);
        }
        set.addAll(collection);
    }

    public Set<A> keySet() {
        return this.map.keySet();
    }

    public Set<B> get(A a) {
        return this.map.get(a);
    }

    public Set<B> getValues(A a) {
        if (!this.map.containsKey(a)) {
            return new LinkedHashSet();
        }
        return this.map.get(a);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(A a) {
        return this.map.containsKey(a);
    }

    public boolean contains(A a, B b) {
        Set<B> set = this.get(a);
        return set == null ? false : set.contains(b);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<Map.Entry<A, Set<B>>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public Collection<Set<B>> values() {
        return this.map.values();
    }

    public boolean remove(A a, B b) {
        Set<B> set = this.get(a);
        if (set != null) {
            return set.remove(b);
        }
        return false;
    }

    public Set<B> remove(A a) {
        return this.map.remove(a);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof MultiMap)) {
            return false;
        }
        return this.map.equals(((MultiMap)object).map);
    }

    public String toString() {
        ArrayList<String> arrayList = new ArrayList<String>(this.map.size());
        for (Map.Entry<A, Set<B>> entry : this.map.entrySet()) {
            arrayList.add(entry.getKey() + "->{" + Utils.join(",", (Collection)entry.getValue()) + "}");
        }
        return "(" + Utils.join(",", arrayList) + ")";
    }
}

