/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import org.openstreetmap.josm.tools.I18n;

public final class LanguageInfo {
    private LanguageInfo() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getWikiLanguagePrefix(LocaleType localeType) {
        if (localeType == LocaleType.ENGLISH) {
            return "";
        }
        String string = LanguageInfo.getJOSMLocaleCode();
        if (localeType == LocaleType.BASELANGUAGE) {
            if (!string.matches("[^_]+_[^_]+")) return null;
            if (!"en".equals(string = string.substring(0, 2))) return string.substring(0, 1).toUpperCase() + string.substring(1) + ":";
            return null;
        }
        if (localeType == LocaleType.DEFAULTNOTENGLISH && "en".equals(string)) {
            return null;
        }
        if (!string.matches(".+@.+")) return string.substring(0, 1).toUpperCase() + string.substring(1) + ":";
        return string.substring(0, 1).toUpperCase() + string.substring(1, 2) + "-" + string.substring(3, 4).toUpperCase() + string.substring(4) + ":";
    }

    public static String getWikiLanguagePrefix() {
        return LanguageInfo.getWikiLanguagePrefix(LocaleType.DEFAULT);
    }

    public static String getJOSMLocaleCode() {
        return LanguageInfo.getJOSMLocaleCode(Locale.getDefault());
    }

    public static String getJOSMLocaleCode(Locale locale) {
        if (locale == null) {
            return "en";
        }
        for (String string : LanguageInfo.getLanguageCodes(locale)) {
            if ("iw_IL".equals(string)) {
                return "he";
            }
            if ("in".equals(string)) {
                return "id";
            }
            if (!I18n.hasCode(string)) continue;
            return string;
        }
        return locale.getLanguage();
    }

    public static String getJavaLocaleCode(String string) {
        if (string == null) {
            return "en";
        }
        if ("ca@valencia".equals(string)) {
            string = "ca__valencia";
        } else if ("he".equals(string)) {
            string = "iw_IL";
        } else if ("id".equals(string)) {
            string = "in";
        }
        return string;
    }

    public static String getDisplayName(Locale locale) {
        return locale.getDisplayName();
    }

    public static Locale getLocale(String string) {
        int n = string.indexOf("_");
        int n2 = string.indexOf("@");
        if (n2 < 0 && n >= 0) {
            n2 = string.indexOf("_", n + 1);
        }
        Locale locale = n2 > 0 && n > 0 ? new Locale(string.substring(0, n), string.substring(n + 1, n2), string.substring(n2 + 1)) : (n2 > 0 ? new Locale(string.substring(0, n2), "", string.substring(n2 + 1)) : (n > 0 ? new Locale(string.substring(0, n), string.substring(n + 1)) : new Locale(string)));
        return locale;
    }

    public static boolean isBetterLanguage(String string, String string2) {
        if (string == null) {
            return true;
        }
        String string3 = LanguageInfo.getJOSMLocaleCode();
        return string3.equals(string2) || !string3.equals(string) && string2.startsWith("en");
    }

    public static String getLanguageCodeXML() {
        String string = LanguageInfo.getJOSMLocaleCode();
        string = string.replace("@", "-");
        return string + ".";
    }

    public static String getLanguageCodeManifest() {
        String string = LanguageInfo.getJOSMLocaleCode();
        string = string.replace("@", "-");
        return string + "_";
    }

    public static Collection<String> getLanguageCodes(Locale locale) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = locale.getVariant();
        if (string2.isEmpty()) {
            string2 = null;
        }
        if (string3 != null && !string3.isEmpty()) {
            if (string2 != null) {
                linkedList.add(string + "_" + string2 + "@" + string3);
            }
            linkedList.add(string + "@" + string3);
        }
        if (string2 != null) {
            linkedList.add(string + "_" + string2);
        }
        linkedList.add(string);
        return linkedList;
    }

    public static enum LocaleType {
        DEFAULT,
        DEFAULTNOTENGLISH,
        BASELANGUAGE,
        ENGLISH;

    }
}

