/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageOverlay {
    public ImageProvider image;
    private double offsetLeft;
    private double offsetRight;
    private double offsetTop;
    private double offsetBottom;

    public ImageOverlay(ImageProvider imageProvider, double d, double d2, double d3, double d4) {
        this.image = imageProvider;
        this.offsetLeft = d;
        this.offsetTop = d2;
        this.offsetRight = d3;
        this.offsetBottom = d4;
    }

    public ImageOverlay(ImageProvider imageProvider) {
        this.image = imageProvider;
        this.offsetLeft = -1.0;
        this.offsetTop = -1.0;
        this.offsetRight = 1.0;
        this.offsetBottom = 1.0;
    }

    public BufferedImage apply(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = -1;
        int n4 = -1;
        if (this.offsetRight > 0.0 && this.offsetLeft > 0.0) {
            n3 = new Double((double)n * (this.offsetRight - this.offsetLeft)).intValue();
        }
        if (this.offsetTop > 0.0 && this.offsetBottom > 0.0) {
            n3 = new Double((double)n2 * (this.offsetBottom - this.offsetTop)).intValue();
        }
        if (n3 != -1 || n4 != -1) {
            this.image = new ImageProvider(this.image).resetMaxSize(new Dimension(n3, n4));
        }
        ImageIcon imageIcon = this.image.get();
        int n5 = n3 == -1 && this.offsetLeft < 0.0 ? new Double((double)n * this.offsetRight).intValue() - imageIcon.getIconWidth() : new Double((double)n * this.offsetLeft).intValue();
        int n6 = n4 == -1 && this.offsetTop < 0.0 ? new Double((double)n2 * this.offsetBottom).intValue() - imageIcon.getIconHeight() : new Double((double)n2 * this.offsetTop).intValue();
        imageIcon.paintIcon(null, bufferedImage.getGraphics(), n5, n6);
        return bufferedImage;
    }
}

