/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.OpenLocationAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class ImportHandler
extends RequestHandler.RawURLParseRequestHandler {
    public static final String command = "import";
    private URL url;
    private Collection<DownloadTask> suitableDownloadTasks;

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        try {
            if (this.suitableDownloadTasks.isEmpty()) {
                Main.debug("Remote control, /import: defaulting to DownloadOsmTask");
                new DownloadOsmTask().loadUrl(this.isLoadInNewLayer(), this.url.toExternalForm(), null);
            } else if (Main.pref.getBoolean("remotecontrol.import.interactive", true)) {
                new OpenLocationAction().openUrl(this.isLoadInNewLayer(), this.url.toExternalForm());
            } else {
                for (DownloadTask downloadTask : this.suitableDownloadTasks) {
                    downloadTask.loadUrl(this.isLoadInNewLayer(), this.url.toExternalForm(), null);
                }
            }
        }
        catch (Exception exception) {
            Main.warn("RemoteControl: Error parsing import remote control request:");
            Main.error(exception);
            throw new RequestHandler.RequestHandlerErrorException(exception);
        }
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"url"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"new_layer"};
    }

    @Override
    public String getUsage() {
        return "downloads the specified OSM file and adds it to the current data set";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/import?url=" + Main.getJOSMWebsite() + "/browser/josm/trunk/data_nodist/direction-arrows.osm"};
    }

    @Override
    public String getPermissionMessage() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.suitableDownloadTasks != null && !this.suitableDownloadTasks.isEmpty()) {
            for (DownloadTask downloadTask : this.suitableDownloadTasks) {
                linkedHashSet.add(Utils.firstNonNull(downloadTask.getConfirmationMessage(this.url), this.url.toString()));
            }
        }
        return I18n.tr("Remote Control has been asked to import data from the following URL:", new Object[0]) + Utils.joinAsHtmlUnorderedList(linkedHashSet);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.IMPORT_DATA;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        String string = (String)this.args.get("url");
        if (Main.pref.getBoolean("remotecontrol.importhandler.fix_url_query", true)) {
            string = Utils.fixURLQuery(string);
        }
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RequestHandler.RequestHandlerBadRequestException("MalformedURLException: " + malformedURLException.getMessage(), malformedURLException);
        }
        this.suitableDownloadTasks = Main.main.menu.openLocation.findDownloadTasks(string, true);
    }
}

