/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.remotecontrol.handler.AddNodeHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.AddWayHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.FeaturesHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.ImageryHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.ImportHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadAndZoomHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadDataHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadObjectHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.OpenFileHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.VersionHandler;
import org.openstreetmap.josm.tools.Utils;

public class RequestProcessor
extends Thread {
    public static final String PROTOCOLVERSION = "{\"protocolversion\": {\"major\": 1, \"minor\": 7}, \"application\": \"JOSM RemoteControl\"}";
    private Socket request;
    private static Map<String, Class<? extends RequestHandler>> handlers = new TreeMap<String, Class<? extends RequestHandler>>();

    public RequestProcessor(Socket socket) {
        super("RemoteControl request processor");
        this.setDaemon(true);
        this.request = socket;
    }

    public static void processRequest(Socket socket) {
        RequestProcessor requestProcessor = new RequestProcessor(socket);
        requestProcessor.start();
    }

    public static void addRequestHandlerClass(String string, Class<? extends RequestHandler> clazz) {
        RequestProcessor.addRequestHandlerClass(string, clazz, false);
    }

    private static void addRequestHandlerClass(String string, Class<? extends RequestHandler> clazz, boolean bl) {
        String string2;
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (handlers.get(string2 = "/" + string) != null) {
            Main.info("RemoteControl: ignoring duplicate command " + string + " with handler " + clazz.getName());
        } else {
            if (!bl) {
                Main.info("RemoteControl: adding command \"" + string + "\" (handled by " + clazz.getSimpleName() + ")");
            }
            handlers.put(string2, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputStreamWriter outputStreamWriter = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.request.getOutputStream());
            outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.request.getInputStream(), "ASCII"));
            String string = bufferedReader.readLine();
            if (string == null) {
                this.sendError(outputStreamWriter);
                return;
            }
            Main.info("RemoteControl received: " + string);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens()) {
                this.sendError(outputStreamWriter);
                return;
            }
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                this.sendError(outputStreamWriter);
                return;
            }
            String string3 = stringTokenizer.nextToken();
            if (!"GET".equals(string2)) {
                this.sendNotImplemented(outputStreamWriter);
                return;
            }
            int n = string3.indexOf(63);
            String string4 = n < 0 ? string3 : string3.substring(0, n);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n2 = 20;
            for (int i = 0; i < n2 && (string = bufferedReader.readLine()) != null; ++i) {
                object4 = string.split(": ", 2);
                if (((String[])object4).length != 2) break;
                hashMap.put(object4[0], object4[1]);
            }
            object4 = null;
            if (!this.request.getInetAddress().isLoopbackAddress()) {
                object4 = this.request.getInetAddress().getHostAddress();
            } else {
                object3 = (String)hashMap.get("Referer");
                object2 = Pattern.compile("(https?://)?([^/]*)");
                if (object3 != null && ((Matcher)(object = ((Pattern)object2).matcher((CharSequence)object3))).find()) {
                    object4 = ((Matcher)object).group(2);
                }
                if (object4 == null) {
                    object4 = "localhost";
                }
            }
            object3 = handlers.get(string4);
            if (object3 == null) {
                object2 = RequestProcessor.getUsageAsHtml();
                object = HelpUtil.getWikiBaseHelpUrl() + "/Help/Preferences/RemoteControl";
                String string5 = "No command specified! The following commands are available:<ul>" + (String)object2 + "</ul>" + "See <a href=\"" + (String)object + "\">" + (String)object + "</a> for complete documentation.";
                this.sendBadRequest(outputStreamWriter, string5);
            } else {
                object2 = (RequestHandler)((Class)object3).newInstance();
                try {
                    ((RequestHandler)object2).setCommand(string4);
                    ((RequestHandler)object2).setUrl(string3);
                    ((RequestHandler)object2).setSender((String)object4);
                    ((RequestHandler)object2).handle();
                    this.sendHeader(outputStreamWriter, "200 OK", ((RequestHandler)object2).getContentType(), false);
                    outputStreamWriter.write("Content-length: " + ((RequestHandler)object2).getContent().length() + "\r\n");
                    outputStreamWriter.write("\r\n");
                    outputStreamWriter.write(((RequestHandler)object2).getContent());
                    ((Writer)outputStreamWriter).flush();
                }
                catch (RequestHandler.RequestHandlerErrorException requestHandlerErrorException) {
                    this.sendError(outputStreamWriter);
                }
                catch (RequestHandler.RequestHandlerBadRequestException requestHandlerBadRequestException) {
                    this.sendBadRequest(outputStreamWriter, requestHandlerBadRequestException.getMessage());
                }
                catch (RequestHandler.RequestHandlerForbiddenException requestHandlerForbiddenException) {
                    this.sendForbidden(outputStreamWriter, requestHandlerForbiddenException.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            Main.debug(Main.getErrorMessage(iOException));
        }
        catch (Exception exception) {
            Main.error(exception);
            try {
                this.sendError(outputStreamWriter);
            }
            catch (IOException iOException) {
                Main.warn(iOException);
            }
        }
        finally {
            try {
                this.request.close();
            }
            catch (IOException iOException) {
                Main.debug(Main.getErrorMessage(iOException));
            }
        }
    }

    private void sendError(Writer writer) throws IOException {
        this.sendHeader(writer, "500 Internal Server Error", "text/html", true);
        writer.write("<HTML>\r\n");
        writer.write("<HEAD><TITLE>Internal Error</TITLE>\r\n");
        writer.write("</HEAD>\r\n");
        writer.write("<BODY>");
        writer.write("<H1>HTTP Error 500: Internal Server Error</H1>\r\n");
        writer.write("</BODY></HTML>\r\n");
        writer.flush();
    }

    private void sendNotImplemented(Writer writer) throws IOException {
        this.sendHeader(writer, "501 Not Implemented", "text/html", true);
        writer.write("<HTML>\r\n");
        writer.write("<HEAD><TITLE>Not Implemented</TITLE>\r\n");
        writer.write("</HEAD>\r\n");
        writer.write("<BODY>");
        writer.write("<H1>HTTP Error 501: Not Implemented</h2>\r\n");
        writer.write("</BODY></HTML>\r\n");
        writer.flush();
    }

    private void sendForbidden(Writer writer, String string) throws IOException {
        this.sendHeader(writer, "403 Forbidden", "text/html", true);
        writer.write("<HTML>\r\n");
        writer.write("<HEAD><TITLE>Forbidden</TITLE>\r\n");
        writer.write("</HEAD>\r\n");
        writer.write("<BODY>");
        writer.write("<H1>HTTP Error 403: Forbidden</h2>\r\n");
        if (string != null) {
            writer.write(string);
        }
        writer.write("</BODY></HTML>\r\n");
        writer.flush();
    }

    private void sendBadRequest(Writer writer, String string) throws IOException {
        this.sendHeader(writer, "400 Bad Request", "text/html", true);
        writer.write("<HTML>\r\n");
        writer.write("<HEAD><TITLE>Bad Request</TITLE>\r\n");
        writer.write("</HEAD>\r\n");
        writer.write("<BODY>");
        writer.write("<H1>HTTP Error 400: Bad Request</h2>\r\n");
        if (string != null) {
            writer.write(string);
        }
        writer.write("</BODY></HTML>\r\n");
        writer.flush();
    }

    private void sendHeader(Writer writer, String string, String string2, boolean bl) throws IOException {
        writer.write("HTTP/1.1 " + string + "\r\n");
        Date date = new Date();
        writer.write("Date: " + date + "\r\n");
        writer.write("Server: JOSM RemoteControl\r\n");
        writer.write("Content-type: " + string2 + "\r\n");
        writer.write("Access-Control-Allow-Origin: *\r\n");
        if (bl) {
            writer.write("\r\n");
        }
    }

    public static String getHandlersInfoAsJSON() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        stringBuilder.append("[");
        for (Map.Entry<String, Class<? extends RequestHandler>> entry : handlers.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(RequestProcessor.getHandlerInfoAsJSON(entry.getKey()));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHandlerInfoAsJSON(String string) {
        try (StringWriter stringWriter = new StringWriter();){
            Object object;
            PrintWriter printWriter = new PrintWriter(stringWriter);
            RequestHandler requestHandler = null;
            try {
                object = handlers.get(string);
                if (object == null) {
                    String string2 = null;
                    return string2;
                }
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                Main.error(reflectiveOperationException);
                String string3 = null;
                if (stringWriter == null) return string3;
                if (var2_3 == null) {
                    stringWriter.close();
                    return string3;
                }
                try {
                    stringWriter.close();
                    return string3;
                }
                catch (Throwable throwable) {
                    var2_3.addSuppressed(throwable);
                    return string3;
                }
            }
            {
                requestHandler = handlers.get(string).newInstance();
            }
            RequestProcessor.printJsonInfo(string, printWriter, requestHandler);
            object = stringWriter.toString();
            return object;
        }
        catch (IOException iOException) {
            Main.error(iOException);
            return null;
        }
    }

    private static void printJsonInfo(String string, PrintWriter printWriter, RequestHandler requestHandler) {
        printWriter.printf("{ \"request\" : \"%s\"", string);
        if (requestHandler.getUsage() != null) {
            printWriter.printf(", \"usage\" : \"%s\"", requestHandler.getUsage());
        }
        printWriter.append(", \"parameters\" : [");
        String[] stringArray = requestHandler.getMandatoryParams();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 0) {
                    printWriter.append('\"');
                } else {
                    printWriter.append(", \"");
                }
                printWriter.append(stringArray[i]).append('\"');
            }
        }
        printWriter.append("], \"optional\" : [");
        String[] stringArray2 = requestHandler.getOptionalParams();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (i == 0) {
                    printWriter.append('\"');
                } else {
                    printWriter.append(", \"");
                }
                printWriter.append(stringArray2[i]).append('\"');
            }
        }
        printWriter.append("], \"examples\" : [");
        String[] stringArray3 = requestHandler.getUsageExamples(string.substring(1));
        if (stringArray3 != null) {
            for (int i = 0; i < stringArray3.length; ++i) {
                if (i == 0) {
                    printWriter.append('\"');
                } else {
                    printWriter.append(", \"");
                }
                printWriter.append(stringArray3[i]).append('\"');
            }
        }
        printWriter.append("]}");
    }

    public static String getUsageAsHtml() throws IllegalAccessException, InstantiationException {
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (Map.Entry<String, Class<? extends RequestHandler>> entry : handlers.entrySet()) {
            RequestHandler requestHandler = entry.getValue().newInstance();
            String[] stringArray = requestHandler.getMandatoryParams();
            String[] stringArray2 = requestHandler.getOptionalParams();
            String[] stringArray3 = requestHandler.getUsageExamples(entry.getKey().substring(1));
            stringBuilder.append("<li>");
            stringBuilder.append(entry.getKey());
            if (requestHandler.getUsage() != null && !requestHandler.getUsage().isEmpty()) {
                stringBuilder.append(" &mdash; <i>").append(requestHandler.getUsage()).append("</i>");
            }
            if (stringArray != null) {
                stringBuilder.append("<br/>mandatory parameters: ").append(Utils.join(", ", Arrays.asList(stringArray)));
            }
            if (stringArray2 != null) {
                stringBuilder.append("<br/>optional parameters: ").append(Utils.join(", ", Arrays.asList(stringArray2)));
            }
            if (stringArray3 != null) {
                stringBuilder.append("<br/>examples: ");
                for (String string : stringArray3) {
                    stringBuilder.append("<br/> <a href=\"http://localhost:8111" + string + "\">" + string + "</a>");
                }
            }
            stringBuilder.append("</li>");
        }
        return stringBuilder.toString();
    }

    static {
        RequestProcessor.addRequestHandlerClass("load_and_zoom", LoadAndZoomHandler.class, true);
        RequestProcessor.addRequestHandlerClass("zoom", LoadAndZoomHandler.class, true);
        RequestProcessor.addRequestHandlerClass("load_data", LoadDataHandler.class, true);
        RequestProcessor.addRequestHandlerClass("imagery", ImageryHandler.class, true);
        RequestProcessor.addRequestHandlerClass("add_node", AddNodeHandler.class, true);
        RequestProcessor.addRequestHandlerClass("add_way", AddWayHandler.class, true);
        RequestProcessor.addRequestHandlerClass("import", ImportHandler.class, true);
        RequestProcessor.addRequestHandlerClass("version", VersionHandler.class, true);
        RequestProcessor.addRequestHandlerClass("load_object", LoadObjectHandler.class, true);
        RequestProcessor.addRequestHandlerClass("open_file", OpenFileHandler.class, true);
        RequestProcessor.addRequestHandlerClass("features", FeaturesHandler.class, true);
    }
}

