/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.GeorefImage;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.io.imagery.WMSException;
import org.openstreetmap.josm.io.imagery.WMSRequest;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WMSGrabber
implements Runnable {
    protected final MapView mv;
    protected final WMSLayer layer;
    private final boolean localOnly;
    protected ProjectionBounds b;
    protected volatile boolean canceled;
    protected String baseURL;
    private ImageryInfo info;
    private Map<String, String> props = new HashMap<String, String>();
    public static final NumberFormat latLonFormat = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));

    public WMSGrabber(MapView mapView, WMSLayer wMSLayer, boolean bl) {
        this.mv = mapView;
        this.layer = wMSLayer;
        this.localOnly = bl;
        this.info = wMSLayer.getInfo();
        this.baseURL = this.info.getUrl();
        if (wMSLayer.getInfo().getCookies() != null && !wMSLayer.getInfo().getCookies().isEmpty()) {
            this.props.put("Cookie", wMSLayer.getInfo().getCookies());
        }
        Pattern pattern = Pattern.compile("\\{header\\(([^,]+),([^}]+)\\)\\}");
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = pattern.matcher(this.baseURL);
        while (matcher.find()) {
            this.props.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        this.baseURL = stringBuffer.toString();
    }

    int width() {
        return this.layer.getBaseImageWidth();
    }

    int height() {
        return this.layer.getBaseImageHeight();
    }

    @Override
    public void run() {
        while (!this.canceled) {
            WMSRequest wMSRequest = this.layer.getRequest(this.localOnly);
            if (wMSRequest == null) {
                return;
            }
            this.b = this.layer.getBounds(wMSRequest);
            if (wMSRequest.isPrecacheOnly()) {
                if (!this.layer.cache.hasExactMatch(Main.getProjection(), wMSRequest.getPixelPerDegree(), this.b.minEast, this.b.minNorth)) {
                    this.attempt(wMSRequest);
                } else if (Main.isDebugEnabled()) {
                    Main.debug("Ignoring " + wMSRequest + " (precache only + exact match)");
                }
            } else if (!this.loadFromCache(wMSRequest)) {
                this.attempt(wMSRequest);
            } else if (Main.isDebugEnabled()) {
                Main.debug("Ignoring " + wMSRequest + " (loaded from cache)");
            }
            this.layer.finishRequest(wMSRequest);
        }
        return;
    }

    protected void attempt(WMSRequest wMSRequest) {
        int n = 5;
        for (int i = 1; i <= n; ++i) {
            if (this.canceled) {
                return;
            }
            try {
                if (!wMSRequest.isPrecacheOnly() && !this.layer.requestIsVisible(wMSRequest)) {
                    return;
                }
                this.fetch(wMSRequest, i);
                break;
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(WMSGrabber.random(1000, 2000));
                }
                catch (InterruptedException interruptedException) {
                    Main.debug("InterruptedException in " + this.getClass().getSimpleName() + " during WMS request");
                }
                if (i != n) continue;
                Main.error(iOException);
                wMSRequest.finish(GeorefImage.State.FAILED, null, null);
                continue;
            }
            catch (WMSException wMSException) {
                Main.error("WMS service exception while requesting " + wMSException.getUrl() + ":\n" + wMSException.getMessage().trim());
                wMSRequest.finish(GeorefImage.State.FAILED, null, wMSException);
                break;
            }
        }
    }

    public static int random(int n, int n2) {
        return (int)(Math.random() * (double)(n2 + 1 - n)) + n;
    }

    public final void cancel() {
        this.canceled = true;
    }

    private void fetch(WMSRequest wMSRequest, int n) throws IOException, WMSException {
        URL uRL = null;
        try {
            uRL = this.getURL(this.b.minEast, this.b.minNorth, this.b.maxEast, this.b.maxNorth, this.width(), this.height());
            wMSRequest.finish(GeorefImage.State.IMAGE, this.grab(wMSRequest, uRL, n), null);
        }
        catch (IOException | OsmTransferException exception) {
            Main.error(exception);
            throw new IOException(exception.getMessage() + "\nImage couldn't be fetched: " + (uRL != null ? uRL.toString() : ""), exception);
        }
    }

    protected URL getURL(double d, double d2, double d3, double d4, int n, int n2) throws MalformedURLException {
        Object object;
        String string = Main.getProjection().toCode();
        if (!this.info.getServerProjections().contains(string) && "EPSG:3857".equals(Main.getProjection().toCode())) {
            LatLon latLon = Main.getProjection().eastNorth2latlon(new EastNorth(d, d2));
            object = Main.getProjection().eastNorth2latlon(new EastNorth(d3, d4));
            string = "EPSG:4326";
            d2 = latLon.lat();
            d = latLon.lon();
            d4 = ((LatLon)object).lat();
            d3 = ((LatLon)object).lon();
        }
        if ("EPSG:4326".equals(string) && !this.info.getServerProjections().contains(string) && this.info.getServerProjections().contains("CRS:84")) {
            string = "CRS:84";
        }
        boolean bl = false;
        if (this.baseURL.toLowerCase().contains("crs=epsg:4326")) {
            bl = true;
        } else if (this.baseURL.toLowerCase().contains("crs=") && "EPSG:4326".equals(string)) {
            bl = true;
        }
        object = bl ? String.format("%s,%s,%s,%s", latLonFormat.format(d2), latLonFormat.format(d), latLonFormat.format(d4), latLonFormat.format(d3)) : String.format("%s,%s,%s,%s", latLonFormat.format(d), latLonFormat.format(d2), latLonFormat.format(d3), latLonFormat.format(d4));
        return new URL(this.baseURL.replaceAll("\\{proj(\\([^})]+\\))?\\}", string).replaceAll("\\{bbox\\}", (String)object).replaceAll("\\{w\\}", latLonFormat.format(d)).replaceAll("\\{s\\}", latLonFormat.format(d2)).replaceAll("\\{e\\}", latLonFormat.format(d3)).replaceAll("\\{n\\}", latLonFormat.format(d4)).replaceAll("\\{width\\}", String.valueOf(n)).replaceAll("\\{height\\}", String.valueOf(n2)).replace(" ", "%20"));
    }

    public boolean loadFromCache(WMSRequest wMSRequest) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = this.layer.cache.getExactMatch(Main.getProjection(), wMSRequest.getPixelPerDegree(), this.b.minEast, this.b.minNorth);
        if (bufferedImage2 != null) {
            wMSRequest.finish(GeorefImage.State.IMAGE, bufferedImage2, null);
            return true;
        }
        if (wMSRequest.isAllowPartialCacheMatch() && (bufferedImage = this.layer.cache.getPartialMatch(Main.getProjection(), wMSRequest.getPixelPerDegree(), this.b.minEast, this.b.minNorth)) != null) {
            wMSRequest.finish(GeorefImage.State.PARTLY_IN_CACHE, bufferedImage, null);
            return true;
        }
        if (!wMSRequest.isReal() && !this.layer.hasAutoDownload()) {
            wMSRequest.finish(GeorefImage.State.NOT_IN_CACHE, null, null);
            return true;
        }
        return false;
    }

    protected BufferedImage grab(WMSRequest wMSRequest, URL uRL, int n) throws WMSException, IOException, OsmTransferException {
        Main.info("Grabbing WMS " + (n > 1 ? "(attempt " + n + ") " : "") + uRL);
        HttpURLConnection httpURLConnection = Utils.openHttpConnection(uRL);
        httpURLConnection.setUseCaches(true);
        for (Map.Entry<String, String> object2 : this.props.entrySet()) {
            httpURLConnection.setRequestProperty(object2.getKey(), object2.getValue());
        }
        httpURLConnection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
        httpURLConnection.setReadTimeout(Main.pref.getInteger("socket.timeout.read", 30) * 1000);
        String string = httpURLConnection.getHeaderField("Content-Type");
        if (httpURLConnection.getResponseCode() != 200 || string != null && !string.startsWith("image")) {
            String string2 = this.readException(httpURLConnection);
            try {
                DocumentBuilder inputStream = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                InputSource inputSource = new InputSource(new StringReader(string2));
                Document throwable = inputStream.parse(inputSource);
                NodeList nodeList = throwable.getElementsByTagName("ServiceException");
                ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    arrayList.add(nodeList.item(i).getTextContent());
                }
                throw new WMSException(wMSRequest, uRL, arrayList);
            }
            catch (ParserConfigurationException | SAXException exception) {
                throw new IOException(string2, exception);
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = new ProgressInputStream(httpURLConnection, null);
        Object object = null;
        try {
            Utils.copyStream(inputStream, byteArrayOutputStream);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (object != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
        inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        object = this.layer.normalizeImage(ImageProvider.read(inputStream, true, (boolean)WMSLayer.PROP_ALPHA_CHANNEL.get()));
        ((ByteArrayInputStream)inputStream).reset();
        this.layer.cache.saveToCache((BufferedImage)(this.layer.isOverlapEnabled() ? object : null), inputStream, Main.getProjection(), wMSRequest.getPixelPerDegree(), this.b.minEast, this.b.minNorth);
        return object;
    }

    protected String readException(URLConnection uRLConnection) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream = uRLConnection.getInputStream();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string.replaceAll("[^\\p{Print}]", ""));
                stringBuilder.append('\n');
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
    }
}

