/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.WMSLayerImporter;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class WMSLayerExporter
extends FileExporter {
    public WMSLayerExporter() {
        super(WMSLayerImporter.FILE_FILTER);
    }

    @Override
    public void exportData(File file, Layer layer) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(file, "file");
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (layer instanceof WMSLayer) {
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));){
                ((WMSLayer)layer).writeExternal(objectOutputStream);
            }
        }
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        this.setEnabled(layer2 instanceof WMSLayer);
    }
}

