/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferException;

public abstract class OsmServerReader
extends OsmConnection {
    private OsmApi api = OsmApi.getOsmApi();
    private boolean doAuthenticate = false;
    protected boolean gpxParsedProperly;

    protected InputStream getInputStream(String string, ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.getInputStream(string, progressMonitor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(String string, ProgressMonitor progressMonitor, String string2) throws OsmTransferException {
        try {
            this.api.initialize(progressMonitor);
            String string3 = string.startsWith("http") ? string : this.getBaseUrl() + string;
            InputStream inputStream = this.getInputStreamRaw(string3, progressMonitor, string2);
            return inputStream;
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    protected String getBaseUrl() {
        return this.api.getBaseUrl();
    }

    protected InputStream getInputStreamRaw(String string, ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.getInputStreamRaw(string, progressMonitor, null);
    }

    protected InputStream getInputStreamRaw(String string, ProgressMonitor progressMonitor, String string2) throws OsmTransferException {
        return this.getInputStreamRaw(string, progressMonitor, string2, false);
    }

    /*
     * Exception decompiling
     */
    protected InputStream getInputStreamRaw(String var1_1, ProgressMonitor var2_2, String var3_3, boolean var4_4) throws OsmTransferException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream fixEncoding(InputStream inputStream, String string) throws IOException {
        if ("gzip".equalsIgnoreCase(string)) {
            inputStream = new GZIPInputStream(inputStream);
        } else if ("deflate".equalsIgnoreCase(string)) {
            inputStream = new InflaterInputStream(inputStream, new Inflater(true));
        }
        return inputStream;
    }

    private InputStream uncompressAccordingToContentDisposition(InputStream inputStream, Map<String, List<String>> map) throws IOException {
        List<String> list = map.get("Content-Disposition");
        if (list != null && list.toString().contains(".gz\"")) {
            return Compression.GZIP.getUncompressedInputStream(inputStream);
        }
        if (list != null && list.toString().contains(".bz2\"")) {
            return Compression.BZIP2.getUncompressedInputStream(inputStream);
        }
        return inputStream;
    }

    public abstract DataSet parseOsm(ProgressMonitor var1) throws OsmTransferException;

    public DataSet parseOsmChange(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmChangeBzip2(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmChangeGzip(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public GpxData parseRawGpsBzip2(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmBzip2(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmGzip(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmZip(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public boolean isDoAuthenticate() {
        return this.doAuthenticate;
    }

    public void setDoAuthenticate(boolean bl) {
        this.doAuthenticate = bl;
    }

    public final boolean isGpxParsedProperly() {
        return this.gpxParsedProperly;
    }

    public List<Note> parseNotes(int n, int n2, ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public List<Note> parseRawNotes(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public List<Note> parseRawNotesBzip2(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }
}

