/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Capabilities {
    private final Map<String, Map<String, String>> capabilities = new HashMap<String, Map<String, String>>();
    private final List<String> imageryBlacklist = new ArrayList<String>();

    public boolean isDefined(String string, String string2) {
        if (!this.capabilities.containsKey(string)) {
            return false;
        }
        Map<String, String> map = this.capabilities.get(string);
        if (map == null) {
            return false;
        }
        return map.get(string2) != null;
    }

    public String get(String string, String string2) {
        if (!this.capabilities.containsKey(string)) {
            return null;
        }
        Map<String, String> map = this.capabilities.get(string);
        if (map == null) {
            return null;
        }
        return map.get(string2);
    }

    public Double getDouble(String string, String string2) throws NumberFormatException {
        String string3 = this.get(string, string2);
        if (string3 == null) {
            return null;
        }
        return Double.parseDouble(string3);
    }

    public Long getLong(String string, String string2) {
        String string3 = this.get(string, string2);
        if (string3 == null) {
            return null;
        }
        return Long.parseLong(string3);
    }

    public void put(String string, String string2, String string3) {
        if ("blacklist".equals(string)) {
            if ("regex".equals(string2)) {
                this.imageryBlacklist.add(string3);
            }
        } else {
            Map<Object, Object> map;
            if (!this.capabilities.containsKey(string)) {
                map = new HashMap();
                this.capabilities.put(string, map);
            }
            map = this.capabilities.get(string);
            map.put(string2, string3);
        }
    }

    public final void clear() {
        this.capabilities.clear();
        this.imageryBlacklist.clear();
    }

    public boolean supportsVersion(String string) {
        return this.get("version", "minimum").compareTo(string) <= 0 && this.get("version", "maximum").compareTo(string) >= 0;
    }

    private static void warnIllegalValue(String string, String string2, Object object) {
        Main.warn(I18n.tr("Illegal value of attribute ''{0}'' of element ''{1}'' in server capabilities. Got ''{2}''", string, string2, object));
    }

    public int getMaxChangesetSize() {
        String string = this.get("changesets", "maximum_elements");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    return n;
                }
                Capabilities.warnIllegalValue("changesets", "maximum_elements", n);
            }
            catch (NumberFormatException numberFormatException) {
                Capabilities.warnIllegalValue("changesets", "maximum_elements", string);
            }
        }
        return -1;
    }

    public long getMaxWayNodes() {
        String string = this.get("waynodes", "maximum");
        if (string != null) {
            try {
                Long l = Long.parseLong(string);
                if (l > 0L) {
                    return l;
                }
                Capabilities.warnIllegalValue("waynodes", "maximum", l);
            }
            catch (NumberFormatException numberFormatException) {
                Capabilities.warnIllegalValue("waynodes", "maximum", string);
            }
        }
        return -1L;
    }

    public boolean isOnImageryBlacklist(String string) {
        if (string != null && this.imageryBlacklist != null) {
            for (String string2 : this.imageryBlacklist) {
                if (!string.matches(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getImageryBlacklist() {
        return Collections.unmodifiableList(this.imageryBlacklist);
    }

    public static final class CapabilitiesParser
    extends DefaultHandler {
        private Capabilities capabilities;

        @Override
        public void startDocument() throws SAXException {
            this.capabilities = new Capabilities();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.capabilities.put(string3, attributes.getQName(i), attributes.getValue(i));
            }
        }

        public Capabilities getCapabilities() {
            return this.capabilities;
        }

        public static Capabilities parse(InputSource inputSource) throws SAXException, IOException, ParserConfigurationException {
            CapabilitiesParser capabilitiesParser = new CapabilitiesParser();
            Utils.newSafeSAXParser().parse(inputSource, (DefaultHandler)capabilitiesParser);
            return capabilitiesParser.getCapabilities();
        }
    }
}

