/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedKeyPressDetector
implements AWTEventListener {
    private final Set<Integer> set = new TreeSet<Integer>();
    private KeyEvent releaseEvent;
    private Timer timer;
    private final List<KeyPressReleaseListener> keyListeners = new ArrayList<KeyPressReleaseListener>();
    private final List<ModifierListener> modifierListeners = new ArrayList<ModifierListener>();
    private int previousModifiers;
    private boolean enabled = true;

    public synchronized void addKeyListener(KeyPressReleaseListener keyPressReleaseListener) {
        this.keyListeners.add(keyPressReleaseListener);
    }

    public synchronized void addModifierListener(ModifierListener modifierListener) {
        this.modifierListeners.add(modifierListener);
    }

    public synchronized void removeKeyListener(KeyPressReleaseListener keyPressReleaseListener) {
        this.keyListeners.remove(keyPressReleaseListener);
    }

    public synchronized void removeModifierListener(ModifierListener modifierListener) {
        this.modifierListeners.remove(modifierListener);
    }

    public void register() {
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            Main.warn(securityException);
        }
        this.timer = new Timer(0, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedKeyPressDetector.this.timer.stop();
                if (AdvancedKeyPressDetector.this.set.remove(AdvancedKeyPressDetector.this.releaseEvent.getKeyCode()) && AdvancedKeyPressDetector.this.enabled) {
                    AdvancedKeyPressDetector advancedKeyPressDetector = AdvancedKeyPressDetector.this;
                    synchronized (advancedKeyPressDetector) {
                        if (AdvancedKeyPressDetector.this.isFocusInMainWindow()) {
                            for (KeyPressReleaseListener keyPressReleaseListener : AdvancedKeyPressDetector.this.keyListeners) {
                                keyPressReleaseListener.doKeyReleased(AdvancedKeyPressDetector.this.releaseEvent);
                            }
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        this.timer.stop();
        this.set.clear();
        AdvancedKeyPressDetector advancedKeyPressDetector = this;
        synchronized (advancedKeyPressDetector) {
            if (!this.keyListeners.isEmpty()) {
                Main.warn(I18n.tr("Some of the key listeners forgot to remove themselves: {0}", new Object[0]), this.keyListeners.toString());
            }
            if (!this.modifierListeners.isEmpty()) {
                Main.warn(I18n.tr("Some of the key modifier listeners forgot to remove themselves: {0}", new Object[0]), this.modifierListeners.toString());
            }
        }
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            Main.warn(securityException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            if (this.timer.isRunning()) {
                this.timer.stop();
            } else if (this.set.add(keyEvent.getKeyCode()) && this.enabled) {
                AdvancedKeyPressDetector advancedKeyPressDetector = this;
                synchronized (advancedKeyPressDetector) {
                    if (this.isFocusInMainWindow()) {
                        for (KeyPressReleaseListener keyPressReleaseListener : this.keyListeners) {
                            keyPressReleaseListener.doKeyPressed(keyEvent);
                        }
                    }
                }
            }
        } else if (keyEvent.getID() == 402) {
            if (this.timer.isRunning()) {
                this.timer.stop();
                if (this.set.remove(keyEvent.getKeyCode()) && this.enabled) {
                    AdvancedKeyPressDetector advancedKeyPressDetector = this;
                    synchronized (advancedKeyPressDetector) {
                        if (this.isFocusInMainWindow()) {
                            for (KeyPressReleaseListener keyPressReleaseListener : this.keyListeners) {
                                keyPressReleaseListener.doKeyReleased(keyEvent);
                            }
                        }
                    }
                }
            } else {
                this.releaseEvent = keyEvent;
                this.timer.restart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof KeyEvent)) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        int n = keyEvent.getModifiers();
        if (this.previousModifiers != n) {
            this.previousModifiers = n;
            AdvancedKeyPressDetector advancedKeyPressDetector = this;
            synchronized (advancedKeyPressDetector) {
                for (ModifierListener modifierListener : this.modifierListeners) {
                    modifierListener.modifiersChanged(n);
                }
            }
        }
        this.processKeyEvent(keyEvent);
    }

    public boolean isKeyPressed(int n) {
        return this.set.contains(n);
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    private boolean isFocusInMainWindow() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return component != null && SwingUtilities.getWindowAncestor(component) instanceof JFrame;
    }
}

