/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.JosmTextField;

public abstract class AddImageryPanel
extends JPanel {
    protected final JosmTextArea rawUrl = new JosmTextArea(3, 40);
    protected final JosmTextField name = new JosmTextField();
    protected final transient Collection<ContentValidationListener> listeners = new ArrayList<ContentValidationListener>();

    protected AddImageryPanel() {
        this(new GridBagLayout());
    }

    protected AddImageryPanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.registerValidableComponent(this.name);
    }

    protected final void registerValidableComponent(AbstractButton abstractButton) {
        abstractButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AddImageryPanel.this.notifyListeners();
            }
        });
    }

    protected final void registerValidableComponent(JTextComponent jTextComponent) {
        jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AddImageryPanel.this.notifyListeners();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AddImageryPanel.this.notifyListeners();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AddImageryPanel.this.notifyListeners();
            }
        });
    }

    protected abstract ImageryInfo getImageryInfo();

    protected static String sanitize(String string) {
        return string.replaceAll("[\r\n]+", "").trim();
    }

    protected final String getImageryName() {
        return AddImageryPanel.sanitize(this.name.getText());
    }

    protected final String getImageryRawUrl() {
        return AddImageryPanel.sanitize(this.rawUrl.getText());
    }

    protected abstract boolean isImageryValid();

    public final void addContentValidationListener(ContentValidationListener contentValidationListener) {
        if (contentValidationListener != null) {
            this.listeners.add(contentValidationListener);
        }
    }

    private final void notifyListeners() {
        for (ContentValidationListener contentValidationListener : this.listeners) {
            contentValidationListener.contentChanged(this.isImageryValid());
        }
    }

    public static interface ContentValidationListener {
        public void contentChanged(boolean var1);
    }
}

