/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;

public abstract class ElemStyle
implements StyleKeys {
    protected static final int ICON_IMAGE_IDX = 0;
    protected static final int ICON_WIDTH_IDX = 1;
    protected static final int ICON_HEIGHT_IDX = 2;
    protected static final int ICON_OPACITY_IDX = 3;
    protected static final int ICON_OFFSET_X_IDX = 4;
    protected static final int ICON_OFFSET_Y_IDX = 5;
    public static final String[] ICON_KEYS = new String[]{"icon-image", "icon-width", "icon-height", "icon-opacity", "icon-offset-x", "icon-offset-y"};
    public static final String[] REPEAT_IMAGE_KEYS = new String[]{"repeat-image", "repeat-image-width", "repeat-image-height", "repeat-image-opacity", null, null};
    public float major_z_index;
    public float z_index;
    public float object_z_index;
    public boolean isModifier;
    private static volatile String DEFAULT_FONT_NAME = null;
    private static volatile Float DEFAULT_FONT_SIZE = null;
    private static final Object lock = new Object();
    private static final Map<FontDescriptor, Font> FONT_MAP = new HashMap<FontDescriptor, Font>();

    public ElemStyle(float f, float f2, float f3, boolean bl) {
        this.major_z_index = f;
        this.z_index = f2;
        this.object_z_index = f3;
        this.isModifier = bl;
    }

    protected ElemStyle(Cascade cascade, float f) {
        this.major_z_index = cascade.get("major-z-index", Float.valueOf(f), Float.class).floatValue();
        this.z_index = cascade.get("z-index", Float.valueOf(0.0f), Float.class).floatValue();
        this.object_z_index = cascade.get("object-z-index", Float.valueOf(0.0f), Float.class).floatValue();
        this.isModifier = cascade.get("modifier", false, Boolean.class);
    }

    public abstract void paintPrimitive(OsmPrimitive var1, MapPaintSettings var2, StyledMapRenderer var3, boolean var4, boolean var5, boolean var6);

    public boolean isProperLineStyle() {
        return false;
    }

    protected static Float getWidth(Cascade cascade, String string, Float f) {
        Float f2 = cascade.get(string, null, Float.class, true);
        if (f2 != null) {
            if (f2.floatValue() > 0.0f) {
                return f2;
            }
        } else {
            Instruction.RelativeFloat relativeFloat;
            Keyword keyword = cascade.get(string, null, Keyword.class, true);
            if (Keyword.THINNEST.equals(keyword)) {
                return Float.valueOf(0.0f);
            }
            if (Keyword.DEFAULT.equals(keyword)) {
                return Float.valueOf(MapPaintSettings.INSTANCE.getDefaultSegmentWidth());
            }
            if (f != null && (relativeFloat = cascade.get(string, null, Instruction.RelativeFloat.class, true)) != null) {
                return Float.valueOf(f.floatValue() + relativeFloat.val);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Float getDefaultFontSize() {
        Float f = DEFAULT_FONT_SIZE;
        if (f == null) {
            Object object = lock;
            synchronized (object) {
                f = DEFAULT_FONT_SIZE;
                if (f == null) {
                    DEFAULT_FONT_SIZE = f = Float.valueOf(Main.pref.getInteger("mappaint.fontsize", 8));
                }
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefaultFontName() {
        String string = DEFAULT_FONT_NAME;
        if (string == null) {
            Object object = lock;
            synchronized (object) {
                string = DEFAULT_FONT_NAME;
                if (string == null) {
                    DEFAULT_FONT_NAME = string = Main.pref.get("mappaint.font", "Droid Sans");
                }
            }
        }
        return string;
    }

    private static Font getCachedFont(FontDescriptor fontDescriptor) {
        Font font = FONT_MAP.get(fontDescriptor);
        if (font != null) {
            return font;
        }
        font = new Font(fontDescriptor.name, fontDescriptor.style, fontDescriptor.size);
        FONT_MAP.put(fontDescriptor, font);
        return font;
    }

    private static Font getCachedFont(String string, int n, int n2) {
        return ElemStyle.getCachedFont(new FontDescriptor(string, n, n2));
    }

    protected static Font getFont(Cascade cascade, String string) {
        Font font;
        String string2 = cascade.get("font-family", ElemStyle.getDefaultFontName(), String.class);
        float f = cascade.get("font-size", ElemStyle.getDefaultFontSize(), Float.class).floatValue();
        int n = 0;
        if ("bold".equalsIgnoreCase(cascade.get("font-weight", null, String.class))) {
            n = 1;
        }
        int n2 = 0;
        if ("italic".equalsIgnoreCase(cascade.get("font-style", null, String.class))) {
            n2 = 2;
        }
        if ((font = ElemStyle.getCachedFont(string2, n2 | n, Math.round(f))).canDisplayUpTo(string) == -1) {
            return font;
        }
        return ElemStyle.getCachedFont("SansSerif", n2 | n, Math.round(f));
    }

    public boolean equals(Object object) {
        if (!(object instanceof ElemStyle)) {
            return false;
        }
        ElemStyle elemStyle = (ElemStyle)object;
        return this.major_z_index == elemStyle.major_z_index && this.z_index == elemStyle.z_index && this.object_z_index == elemStyle.object_z_index && this.isModifier == elemStyle.isModifier;
    }

    public int hashCode() {
        int n = 5;
        n = 41 * n + Float.floatToIntBits(this.major_z_index);
        n = 41 * n + Float.floatToIntBits(this.z_index);
        n = 41 * n + Float.floatToIntBits(this.object_z_index);
        n = 41 * n + (this.isModifier ? 1 : 0);
        return n;
    }

    public String toString() {
        return String.format("z_idx=[%s/%s/%s] ", Float.valueOf(this.major_z_index), Float.valueOf(this.z_index), Float.valueOf(this.object_z_index)) + (this.isModifier ? "modifier " : "");
    }

    private static class FontDescriptor {
        public String name;
        public int style;
        public int size;

        public FontDescriptor(String string, int n, int n2) {
            this.name = string;
            this.style = n;
            this.size = n2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            n = 31 * n + this.size;
            n = 31 * n + this.style;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FontDescriptor fontDescriptor = (FontDescriptor)object;
            if (this.name == null ? fontDescriptor.name != null : !this.name.equals(fontDescriptor.name)) {
                return false;
            }
            if (this.size != fontDescriptor.size) {
                return false;
            }
            return this.style == fontDescriptor.style;
        }
    }
}

