/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.io.CacheFiles;
import org.openstreetmap.josm.tools.ExifReader;

public class ThumbsLoader
implements Runnable {
    public static final int maxSize = 120;
    public static final int minSize = 22;
    public volatile boolean stop = false;
    private List<ImageEntry> data;
    private GeoImageLayer layer;
    private MediaTracker tracker;
    private CacheFiles cache;
    private boolean cacheOff = Main.pref.getBoolean("geoimage.noThumbnailCache", false);

    public ThumbsLoader(GeoImageLayer geoImageLayer) {
        this.layer = geoImageLayer;
        this.data = new ArrayList<ImageEntry>(geoImageLayer.data);
        if (!this.cacheOff) {
            this.cache = new CacheFiles("geoimage-thumbnails", false);
            this.cache.setExpire(-1, false);
            this.cache.setMaxSize(120, false);
        }
    }

    @Override
    public void run() {
        Main.debug("Load Thumbnails");
        this.tracker = new MediaTracker(Main.map.mapView);
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.stop) {
                return;
            }
            if (this.data.get((int)i).thumbnail != null) continue;
            this.data.get((int)i).thumbnail = this.loadThumb(this.data.get(i));
            if (!Main.isDisplayingMapView()) continue;
            this.layer.updateOffscreenBuffer = true;
            Main.map.mapView.repaint();
        }
        this.layer.thumbsLoaded();
        this.layer.updateOffscreenBuffer = true;
        Main.map.mapView.repaint();
    }

    private BufferedImage loadThumb(ImageEntry imageEntry) {
        int n;
        int n2;
        Image image;
        String string = imageEntry.getFile().toString() + ":" + 120;
        if (!this.cacheOff && (image = this.cache.getImg(string)) != null) {
            Main.debug(" from cache");
            return image;
        }
        image = Toolkit.getDefaultToolkit().createImage(imageEntry.getFile().getPath());
        this.tracker.addImage(image, 0);
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            Main.error(" InterruptedException while loading thumb");
            return null;
        }
        if (this.tracker.isErrorID(1) || image.getWidth(null) <= 0 || image.getHeight(null) <= 0) {
            Main.error(" Invalid image");
            return null;
        }
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        if (ExifReader.orientationSwitchesDimensions(imageEntry.getExifOrientation())) {
            n2 = n4;
            n = n3;
        } else {
            n2 = n3;
            n = n4;
        }
        Rectangle rectangle = ImageDisplay.calculateDrawImageRectangle(new Rectangle(0, 0, n2, n), new Rectangle(0, 0, 120, 120));
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        AffineTransform affineTransform = ExifReader.getRestoreOrientationTransform(imageEntry.getExifOrientation(), n3, n4);
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance((double)rectangle.width / (double)n2, (double)rectangle.height / (double)n);
        affineTransform2.concatenate(affineTransform);
        while (!graphics2D.drawImage(image, affineTransform2, null)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                Main.warn("InterruptedException while drawing thumb");
            }
        }
        graphics2D.dispose();
        this.tracker.removeImage(image);
        if (bufferedImage.getWidth() <= 0 || bufferedImage.getHeight() <= 0) {
            Main.error(" Invalid image");
            return null;
        }
        if (!this.cacheOff) {
            this.cache.saveImg(string, bufferedImage);
        }
        return bufferedImage;
    }
}

