/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.openstreetmap.gui.jmapviewer.AttributionSupport;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.CachedTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.ScanexTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TemplatedTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.CacheCustomContent;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TMSLayer
extends ImageryLayer
implements ImageObserver,
TileLoaderListener {
    public static final String PREFERENCE_PREFIX = "imagery.tms";
    public static final int MAX_ZOOM = 30;
    public static final int MIN_ZOOM = 2;
    public static final int DEFAULT_MAX_ZOOM = 20;
    public static final int DEFAULT_MIN_ZOOM = 2;
    public static final BooleanProperty PROP_DEFAULT_AUTOZOOM = new BooleanProperty("imagery.tms.default_autozoom", true);
    public static final BooleanProperty PROP_DEFAULT_AUTOLOAD = new BooleanProperty("imagery.tms.default_autoload", true);
    public static final BooleanProperty PROP_DEFAULT_SHOWERRORS = new BooleanProperty("imagery.tms.default_showerrors", true);
    public static final IntegerProperty PROP_MIN_ZOOM_LVL = new IntegerProperty("imagery.tms.min_zoom_lvl", 2);
    public static final IntegerProperty PROP_MAX_ZOOM_LVL = new IntegerProperty("imagery.tms.max_zoom_lvl", 20);
    public static final BooleanProperty PROP_ADD_TO_SLIPPYMAP_CHOOSER = new BooleanProperty("imagery.tms.add_to_slippymap_chooser", true);
    public static final StringProperty PROP_TILECACHE_DIR;
    protected TileCache tileCache;
    protected TileSource tileSource;
    protected TileLoader tileLoader;
    public static TileLoaderFactory loaderFactory;
    public int currentZoomLevel;
    private Tile clickedTile;
    private boolean needRedraw;
    private JPopupMenu tileOptionMenu;
    private JCheckBoxMenuItem autoZoomPopup;
    private JCheckBoxMenuItem autoLoadPopup;
    private JCheckBoxMenuItem showErrorsPopup;
    private Tile showMetadataTile;
    private AttributionSupport attribution = new AttributionSupport();
    private static final Font InfoFont;
    protected boolean autoZoom;
    protected boolean autoLoad;
    protected boolean showErrors;
    private final TileSet nullTileSet = new TileSet((LatLon)null, (LatLon)null, 0);

    public static void setCustomTileLoaderFactory(TileLoaderFactory tileLoaderFactory) {
        loaderFactory = tileLoaderFactory;
    }

    @Override
    public synchronized void tileLoadingFinished(Tile tile, boolean bl) {
        if (tile.hasError()) {
            bl = false;
            tile.setImage(null);
        }
        if (this.sharpenLevel != 0 && bl) {
            tile.setImage(this.sharpenImage(tile.getImage()));
        }
        tile.setLoaded(bl);
        this.needRedraw = true;
        if (Main.map != null) {
            Main.map.repaint(100L);
        }
        if (Main.isDebugEnabled()) {
            Main.debug("tileLoadingFinished() tile: " + tile + " success: " + bl);
        }
    }

    void clearTileCache(ProgressMonitor progressMonitor) {
        this.tileCache.clear();
        if (this.tileLoader instanceof CachedTileLoader) {
            ((CachedTileLoader)((Object)this.tileLoader)).clearCache(this.tileSource);
        }
    }

    void redraw() {
        this.needRedraw = true;
        Main.map.repaint();
    }

    static int checkMaxZoomLvl(int n, TileSource tileSource) {
        if (n > 30) {
            n = 30;
        }
        if (n < PROP_MIN_ZOOM_LVL.get()) {
            n = PROP_MIN_ZOOM_LVL.get();
        }
        if (tileSource != null && tileSource.getMaxZoom() != 0 && tileSource.getMaxZoom() < n) {
            n = tileSource.getMaxZoom();
        }
        return n;
    }

    public static int getMaxZoomLvl(TileSource tileSource) {
        return TMSLayer.checkMaxZoomLvl(PROP_MAX_ZOOM_LVL.get(), tileSource);
    }

    public static void setMaxZoomLvl(int n) {
        n = TMSLayer.checkMaxZoomLvl(n, null);
        PROP_MAX_ZOOM_LVL.put(n);
    }

    static int checkMinZoomLvl(int n, TileSource tileSource) {
        if (n < 2) {
            n = 2;
        }
        if (n > PROP_MAX_ZOOM_LVL.get()) {
            n = TMSLayer.getMaxZoomLvl(tileSource);
        }
        if (tileSource != null && tileSource.getMinZoom() > n) {
            n = tileSource.getMinZoom();
        }
        return n;
    }

    public static int getMinZoomLvl(TileSource tileSource) {
        return TMSLayer.checkMinZoomLvl(PROP_MIN_ZOOM_LVL.get(), tileSource);
    }

    public static void setMinZoomLvl(int n) {
        n = TMSLayer.checkMinZoomLvl(n, null);
        PROP_MIN_ZOOM_LVL.put(n);
    }

    public static TileSource getTileSource(ImageryInfo imageryInfo) {
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.TMS) {
            TMSLayer.checkUrl(imageryInfo.getUrl());
            TemplatedTMSTileSource templatedTMSTileSource = new TemplatedTMSTileSource(imageryInfo.getName(), imageryInfo.getUrl(), imageryInfo.getId(), imageryInfo.getMinZoom(), imageryInfo.getMaxZoom(), imageryInfo.getCookies());
            imageryInfo.setAttribution(templatedTMSTileSource);
            return templatedTMSTileSource;
        }
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.BING) {
            return new CachedAttributionBingAerialTileSource(imageryInfo.getId());
        }
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.SCANEX) {
            return new ScanexTileSource(imageryInfo.getName(), imageryInfo.getUrl(), imageryInfo.getId(), imageryInfo.getMaxZoom());
        }
        return null;
    }

    public static void checkUrl(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        Matcher matcher = Pattern.compile("\\{[^}]*\\}").matcher(string);
        while (matcher.find()) {
            boolean bl = false;
            for (String string2 : TemplatedTMSTileSource.ALL_PATTERNS) {
                if (!matcher.group().matches(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new IllegalArgumentException(I18n.tr("{0} is not a valid TMS argument. Please check this server URL:\n{1}", matcher.group(), string));
        }
    }

    private void initTileSource(TileSource tileSource) {
        this.tileSource = tileSource;
        this.attribution.initialize(tileSource);
        this.currentZoomLevel = this.getBestZoom();
        Map<String, String> map = null;
        if (tileSource instanceof TemplatedTMSTileSource) {
            map = ((TemplatedTMSTileSource)tileSource).getHeaders();
        }
        this.tileLoader = loaderFactory.makeTileLoader(this, map);
        this.tileCache = this.tileLoader instanceof TMSCachedTileLoader ? (TileCache)((Object)this.tileLoader) : new MemoryTileCache();
        if (this.tileLoader == null) {
            this.tileLoader = new OsmTileLoader(this);
        }
    }

    @Override
    public void setOffset(double d, double d2) {
        super.setOffset(d, d2);
        this.needRedraw = true;
    }

    private double getScaleFactor(int n) {
        if (!Main.isDisplayingMapView()) {
            return 1.0;
        }
        MapView mapView = Main.map.mapView;
        LatLon latLon = mapView.getLatLon(0, 0);
        LatLon latLon2 = mapView.getLatLon(mapView.getWidth(), mapView.getHeight());
        double d = this.tileSource.lonToTileX(latLon.lon(), n);
        double d2 = this.tileSource.latToTileY(latLon.lat(), n);
        double d3 = this.tileSource.lonToTileX(latLon2.lon(), n);
        double d4 = this.tileSource.latToTileY(latLon2.lat(), n);
        int n2 = mapView.getWidth() * mapView.getHeight();
        double d5 = Math.abs((d4 - d2) * (d3 - d) * (double)this.tileSource.getTileSize() * (double)this.tileSource.getTileSize());
        if (n2 == 0 || d5 == 0.0) {
            return 1.0;
        }
        return (double)n2 / d5;
    }

    private final int getBestZoom() {
        double d = this.getScaleFactor(1);
        double d2 = Math.log(d) / Math.log(2.0) / 2.0 + 1.0;
        int n = (int)Math.floor(d2);
        if (n > this.getMaxZoomLvl()) {
            return this.getMaxZoomLvl();
        }
        if (n < this.getMinZoomLvl()) {
            return this.getMinZoomLvl();
        }
        return n;
    }

    public TMSLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
        if (!this.isProjectionSupported(Main.getProjection())) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("TMS layers do not support the projection {0}.\n{1}\nChange the projection or remove the layer.", Main.getProjection().toCode(), this.nameSupportedProjections()), I18n.tr("Warning", new Object[0]), 2);
        }
        this.setBackgroundLayer(true);
        this.setVisible(true);
        TileSource tileSource = TMSLayer.getTileSource(imageryInfo);
        if (tileSource == null) {
            throw new IllegalStateException("Cannot create TMSLayer with non-TMS ImageryInfo");
        }
        this.initTileSource(tileSource);
    }

    @Override
    public void hookUpMapView() {
        this.tileOptionMenu = new JPopupMenu();
        this.autoZoom = PROP_DEFAULT_AUTOZOOM.get();
        this.autoZoomPopup = new JCheckBoxMenuItem();
        this.autoZoomPopup.setAction(new AbstractAction(I18n.tr("Auto Zoom", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.autoZoom = !TMSLayer.this.autoZoom;
            }
        });
        this.autoZoomPopup.setSelected(this.autoZoom);
        this.tileOptionMenu.add(this.autoZoomPopup);
        this.autoLoad = PROP_DEFAULT_AUTOLOAD.get();
        this.autoLoadPopup = new JCheckBoxMenuItem();
        this.autoLoadPopup.setAction(new AbstractAction(I18n.tr("Auto load tiles", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.autoLoad = !TMSLayer.this.autoLoad;
            }
        });
        this.autoLoadPopup.setSelected(this.autoLoad);
        this.tileOptionMenu.add(this.autoLoadPopup);
        this.showErrors = PROP_DEFAULT_SHOWERRORS.get();
        this.showErrorsPopup = new JCheckBoxMenuItem();
        this.showErrorsPopup.setAction(new AbstractAction(I18n.tr("Show Errors", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.showErrors = !TMSLayer.this.showErrors;
            }
        });
        this.showErrorsPopup.setSelected(this.showErrors);
        this.tileOptionMenu.add(this.showErrorsPopup);
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Load Tile", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TMSLayer.this.clickedTile != null) {
                    TMSLayer.this.loadTile(TMSLayer.this.clickedTile, true);
                    TMSLayer.this.redraw();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Show Tile Info", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TMSLayer.this.clickedTile != null) {
                    TMSLayer.this.showMetadataTile = TMSLayer.this.clickedTile;
                    TMSLayer.this.redraw();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Load All Tiles", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.loadAllTiles(true);
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Load All Error Tiles", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.loadAllErrorTiles(true);
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Increase zoom", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.increaseZoomLevel();
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Decrease zoom", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.decreaseZoomLevel();
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Snap to tile size", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = Math.sqrt(TMSLayer.this.getScaleFactor(TMSLayer.this.currentZoomLevel));
                Main.map.mapView.zoomToFactor(d);
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Flush Tile Cache", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new PleaseWaitRunnable(I18n.tr("Flush Tile Cache", new Object[0])){

                    @Override
                    protected void realRun() throws SAXException, IOException, OsmTransferException {
                        TMSLayer.this.clearTileCache(this.getProgressMonitor());
                    }

                    @Override
                    protected void finish() {
                    }

                    @Override
                    protected void cancel() {
                    }
                }.run();
            }
        }));
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!TMSLayer.this.isVisible()) {
                    return;
                }
                if (mouseEvent.getButton() == 3) {
                    TMSLayer.this.clickedTile = TMSLayer.this.getTileForPixelpos(mouseEvent.getX(), mouseEvent.getY());
                    TMSLayer.this.tileOptionMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getButton() == 1) {
                    TMSLayer.this.attribution.handleAttribution(mouseEvent.getPoint(), true);
                }
            }
        };
        Main.map.mapView.addMouseListener(mouseAdapter);
        MapView.addLayerChangeListener(new MapView.LayerChangeListener(){

            @Override
            public void activeLayerChange(Layer layer, Layer layer2) {
            }

            @Override
            public void layerAdded(Layer layer) {
            }

            @Override
            public void layerRemoved(Layer layer) {
                if (layer == TMSLayer.this) {
                    Main.map.mapView.removeMouseListener(mouseAdapter);
                    MapView.removeLayerChangeListener(this);
                }
            }
        });
    }

    void zoomChanged() {
        if (Main.isDebugEnabled()) {
            Main.debug("zoomChanged(): " + this.currentZoomLevel);
        }
        this.needRedraw = true;
    }

    int getMaxZoomLvl() {
        if (this.info.getMaxZoom() != 0) {
            return TMSLayer.checkMaxZoomLvl(this.info.getMaxZoom(), this.tileSource);
        }
        return TMSLayer.getMaxZoomLvl(this.tileSource);
    }

    int getMinZoomLvl() {
        return TMSLayer.getMinZoomLvl(this.tileSource);
    }

    public boolean zoomIncreaseAllowed() {
        boolean bl;
        boolean bl2 = bl = this.currentZoomLevel < this.getMaxZoomLvl();
        if (Main.isDebugEnabled()) {
            Main.debug("zoomIncreaseAllowed(): " + bl + " " + this.currentZoomLevel + " vs. " + this.getMaxZoomLvl());
        }
        return bl;
    }

    public boolean increaseZoomLevel() {
        if (this.zoomIncreaseAllowed()) {
            ++this.currentZoomLevel;
            if (Main.isDebugEnabled()) {
                Main.debug("increasing zoom level to: " + this.currentZoomLevel);
            }
        } else {
            Main.warn("Current zoom level (" + this.currentZoomLevel + ") could not be increased. " + "Max.zZoom Level " + this.getMaxZoomLvl() + " reached.");
            return false;
        }
        this.zoomChanged();
        return true;
    }

    public boolean setZoomLevel(int n) {
        if (n == this.currentZoomLevel) {
            return true;
        }
        if (n > this.getMaxZoomLvl()) {
            return false;
        }
        if (n < this.getMinZoomLvl()) {
            return false;
        }
        this.currentZoomLevel = n;
        this.zoomChanged();
        return true;
    }

    public boolean zoomDecreaseAllowed() {
        return this.currentZoomLevel > this.getMinZoomLvl();
    }

    public boolean decreaseZoomLevel() {
        if (this.zoomDecreaseAllowed()) {
            if (Main.isDebugEnabled()) {
                Main.debug("decreasing zoom level to: " + this.currentZoomLevel);
            }
            --this.currentZoomLevel;
        } else {
            return false;
        }
        this.zoomChanged();
        return true;
    }

    Tile tempCornerTile(Tile tile) {
        int n;
        int n2;
        int n3 = tile.getXtile() + 1;
        Tile tile2 = this.getTile(n3, n2 = tile.getYtile() + 1, n = tile.getZoom());
        if (tile2 != null) {
            return tile2;
        }
        return new Tile(this.tileSource, n3, n2, n);
    }

    Tile getOrCreateTile(int n, int n2, int n3) {
        Tile tile = this.getTile(n, n2, n3);
        if (tile == null) {
            tile = new Tile(this.tileSource, n, n2, n3);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        return tile;
    }

    Tile getTile(int n, int n2, int n3) {
        int n4 = 1 << n3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4) {
            return null;
        }
        return this.tileCache.getTile(this.tileSource, n, n2, n3);
    }

    boolean loadTile(Tile tile, boolean bl) {
        if (tile == null) {
            return false;
        }
        if (!bl && (tile.isLoaded() || tile.hasError())) {
            return false;
        }
        if (tile.isLoading()) {
            return false;
        }
        this.tileLoader.createTileLoaderJob(tile).submit();
        return true;
    }

    void loadAllTiles(boolean bl) {
        EastNorth eastNorth;
        MapView mapView = Main.map.mapView;
        EastNorth eastNorth2 = mapView.getEastNorth(0, 0);
        TileSet tileSet = new TileSet(eastNorth2, eastNorth = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight()), this.currentZoomLevel);
        if (tileSet.tooLarge()) {
            Main.warn("Not downloading all tiles because there is more than 18 tiles on an axis!");
            return;
        }
        tileSet.loadAllTiles(bl);
    }

    void loadAllErrorTiles(boolean bl) {
        MapView mapView = Main.map.mapView;
        EastNorth eastNorth = mapView.getEastNorth(0, 0);
        EastNorth eastNorth2 = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight());
        TileSet tileSet = new TileSet(eastNorth, eastNorth2, this.currentZoomLevel);
        tileSet.loadAllErrorTiles(bl);
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = (n & 0x70) != 0;
        this.needRedraw = true;
        if (Main.isDebugEnabled()) {
            Main.debug("imageUpdate() done: " + bl + " calling repaint");
        }
        Main.map.repaint(bl ? 0L : 100L);
        return !bl;
    }

    boolean imageLoaded(Image image) {
        if (image == null) {
            return false;
        }
        int n = Toolkit.getDefaultToolkit().checkImage(image, -1, -1, this);
        return (n & 0x20) != 0;
    }

    Image getLoadedTileImage(Tile tile) {
        if (!tile.isLoaded()) {
            return null;
        }
        BufferedImage bufferedImage = tile.getImage();
        if (!this.imageLoaded(bufferedImage)) {
            return null;
        }
        return bufferedImage;
    }

    LatLon tileLatLon(Tile tile) {
        int n = tile.getZoom();
        return new LatLon(this.tileSource.tileYToLat(tile.getYtile(), n), this.tileSource.tileXToLon(tile.getXtile(), n));
    }

    Rectangle tileToRect(Tile tile) {
        Tile tile2 = this.tempCornerTile(tile);
        Rectangle rectangle = new Rectangle(this.pixelPos(tile));
        rectangle.add(this.pixelPos(tile2));
        return rectangle;
    }

    void drawImageInside(Graphics graphics, Image image, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangle;
        if (rectangle2 != null) {
            rectangle3 = rectangle.intersection(rectangle2);
            if (Main.isDebugEnabled()) {
                Main.debug("source: " + rectangle + "\nborder: " + rectangle2 + "\nintersection: " + rectangle3);
            }
        }
        double d = (double)image.getHeight(this) / rectangle.getHeight();
        double d2 = (double)image.getWidth(this) / rectangle.getWidth();
        int n = rectangle3.x - rectangle.x;
        int n2 = rectangle3.y - rectangle.y;
        int n3 = (int)((double)n * d2 + 0.5);
        int n4 = (int)((double)n2 * d + 0.5);
        int n5 = n3 + (int)(rectangle3.getWidth() * d2 + 0.5);
        int n6 = n4 + (int)(rectangle3.getHeight() * d + 0.5);
        if (Main.isDebugEnabled()) {
            Main.debug("drawing image into target rect: " + rectangle3);
        }
        graphics.drawImage(image, rectangle3.x, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height, n3, n4, n5, n6, this);
        if (PROP_FADE_AMOUNT.get() != 0) {
            graphics.setColor(TMSLayer.getFadeColorWithAlpha());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
    }

    List<Tile> paintTileImages(Graphics graphics, TileSet tileSet, int n, Tile tile) {
        if (n <= 0) {
            return Collections.emptyList();
        }
        Rectangle rectangle = null;
        if (tile != null) {
            rectangle = this.tileToRect(tile);
        }
        LinkedList<Tile> linkedList = new LinkedList<Tile>();
        for (Tile tile2 : tileSet.allTilesCreate()) {
            Image image = this.getLoadedTileImage(tile2);
            if (image == null || tile2.hasError()) {
                if (Main.isDebugEnabled()) {
                    Main.debug("missed tile: " + tile2);
                }
                linkedList.add(tile2);
                continue;
            }
            Rectangle rectangle2 = this.tileToRect(tile2);
            if (rectangle != null && !rectangle2.intersects(rectangle)) continue;
            this.drawImageInside(graphics, image, rectangle2, rectangle);
        }
        return linkedList;
    }

    void myDrawString(Graphics graphics, String string, int n, int n2) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.drawString(string, n + 1, n2 + 1);
        graphics.setColor(color);
        graphics.drawString(string, n, n2);
    }

    void paintTileText(TileSet tileSet, Tile tile, Graphics graphics, MapView mapView, int n, Tile tile2) {
        int n2 = graphics.getFontMetrics().getHeight();
        if (tile == null) {
            return;
        }
        Point point = this.pixelPos(tile2);
        int n3 = point.y + 2 + n2;
        if (tile == this.showMetadataTile) {
            Map<String, String> map;
            String string = tile.toString();
            if (string != null) {
                this.myDrawString(graphics, string, point.x + 2, n3);
                n3 += 1 + n2;
            }
            if ((map = tile.getMetadata()) != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.myDrawString(graphics, entry.getKey() + ": " + entry.getValue(), point.x + 2, n3);
                    n3 += 1 + n2;
                }
            }
        }
        if (tile.hasError() && this.showErrors) {
            this.myDrawString(graphics, I18n.tr("Error", new Object[0]) + ": " + I18n.tr(tile.getErrorMessage(), new Object[0]), point.x + 2, n3);
            n3 += 1 + n2;
        }
    }

    private Point pixelPos(LatLon latLon) {
        return Main.map.mapView.getPoint(Main.getProjection().latlon2eastNorth(latLon).add(this.getDx(), this.getDy()));
    }

    private Point pixelPos(Tile tile) {
        double d = this.tileSource.tileXToLon(tile.getXtile(), tile.getZoom());
        LatLon latLon = new LatLon(this.tileSource.tileYToLat(tile.getYtile(), tile.getZoom()), d);
        return this.pixelPos(latLon);
    }

    private LatLon getShiftedLatLon(EastNorth eastNorth) {
        return Main.getProjection().eastNorth2latlon(eastNorth.add(-this.getDx(), -this.getDy()));
    }

    private Coordinate getShiftedCoord(EastNorth eastNorth) {
        LatLon latLon = this.getShiftedLatLon(eastNorth);
        return new Coordinate(latLon.lat(), latLon.lon());
    }

    private static TileSetInfo getTileSetInfo(TileSet tileSet) {
        List<Tile> list = tileSet.allExistingTiles();
        TileSetInfo tileSetInfo = new TileSetInfo();
        tileSetInfo.hasLoadingTiles = list.size() < tileSet.size();
        for (Tile tile : list) {
            if (tile.isLoaded()) {
                if (!tile.hasError()) {
                    tileSetInfo.hasVisibleTiles = true;
                }
                if (!"no-tile".equals(tile.getValue("tile-info"))) continue;
                tileSetInfo.hasOverzoomedTiles = true;
                continue;
            }
            tileSetInfo.hasLoadingTiles = true;
        }
        return tileSetInfo;
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        LinkedList<Tile> linkedList;
        double d;
        EastNorth eastNorth = mapView.getEastNorth(0, 0);
        EastNorth eastNorth2 = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight());
        if (eastNorth2.east() == 0.0 || eastNorth2.north() == 0.0) {
            return;
        }
        this.needRedraw = false;
        int n = this.currentZoomLevel;
        if (this.autoZoom && ((d = this.getScaleFactor(n)) > 3.0 || d < 0.7)) {
            n = this.getBestZoom();
        }
        DeepTileSet deepTileSet = new DeepTileSet(eastNorth, eastNorth2, this.getMinZoomLvl(), n);
        TileSet tileSet = deepTileSet.getTileSet(n);
        int n2 = n;
        boolean bl = false;
        if (this.autoZoom && this.autoLoad) {
            linkedList = deepTileSet.getTileSetInfo(n);
            if (!(((TileSetInfo)((Object)linkedList)).hasVisibleTiles || ((TileSetInfo)((Object)linkedList)).hasLoadingTiles && !((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles)) {
                bl = true;
            }
            for (int i = n; i > deepTileSet.minZoom; --i) {
                if (!deepTileSet.getTileSetInfo((int)i).hasVisibleTiles) continue;
                n2 = i;
                break;
            }
            while (n > n2 && !((TileSetInfo)((Object)linkedList)).hasVisibleTiles && ((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles) {
                n = (n + n2) / 2;
                linkedList = deepTileSet.getTileSetInfo(n);
            }
            this.setZoomLevel(n);
            if (n == n2 && !((TileSetInfo)((Object)linkedList)).hasLoadingTiles && n < deepTileSet.maxZoom) {
                linkedList = deepTileSet.getTileSetInfo(++n);
            }
            while (n > deepTileSet.minZoom && ((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles && !((TileSetInfo)((Object)linkedList)).hasLoadingTiles) {
                linkedList = deepTileSet.getTileSetInfo(--n);
            }
            tileSet = deepTileSet.getTileSet(n);
        } else if (this.autoZoom) {
            this.setZoomLevel(n);
        }
        if (!tileSet.tooLarge()) {
            tileSet.loadAllTiles(false);
        }
        if (n2 != n) {
            tileSet = deepTileSet.getTileSet(n2);
        }
        graphics2D.setColor(Color.DARK_GRAY);
        linkedList = this.paintTileImages(graphics2D, tileSet, n2, null);
        int[] nArray = new int[]{-1, 1, -2, 2, -3, -4, -5};
        for (int n3 : nArray) {
            if (!this.autoZoom) break;
            int n4 = n2 + n3;
            if (n4 < 2) continue;
            if (linkedList.isEmpty()) break;
            LinkedList<Tile> object2 = new LinkedList<Tile>();
            for (Tile tile : linkedList) {
                LatLon latLon;
                if ("no-tile".equals(tile.getValue("tile-info")) && n3 > 0) {
                    object2.add(tile);
                    continue;
                }
                Tile tile2 = this.tempCornerTile(tile);
                LatLon latLon2 = this.tileLatLon(tile);
                TileSet tileSet2 = new TileSet(latLon2, latLon = this.tileLatLon(tile2), n4);
                if (tileSet2.allLoadedTiles().isEmpty()) {
                    object2.add(tile);
                    continue;
                }
                if (tileSet2.tooLarge()) continue;
                object2.addAll(this.paintTileImages(graphics2D, tileSet2, n4, tile));
            }
            linkedList = object2;
        }
        if (Main.isDebugEnabled() && !linkedList.isEmpty()) {
            Main.debug("still missed " + linkedList.size() + " in the end");
        }
        graphics2D.setColor(Color.red);
        graphics2D.setFont(InfoFont);
        Object object = tileSet.allExistingTiles().iterator();
        while (object.hasNext()) {
            Tile tile = (Tile)object.next();
            this.paintTileText(tileSet, tile, graphics2D, mapView, n2, tile);
        }
        this.attribution.paintAttribution(graphics2D, mapView.getWidth(), mapView.getHeight(), this.getShiftedCoord(eastNorth), this.getShiftedCoord(eastNorth2), n2, this);
        graphics2D.setColor(Color.lightGray);
        if (!this.autoZoom) {
            if (tileSet.insane()) {
                this.myDrawString(graphics2D, I18n.tr("zoom in to load any tiles", new Object[0]), 120, 120);
            } else if (tileSet.tooLarge()) {
                this.myDrawString(graphics2D, I18n.tr("zoom in to load more tiles", new Object[0]), 120, 120);
            } else if (tileSet.tooSmall()) {
                this.myDrawString(graphics2D, I18n.tr("increase zoom level to see more detail", new Object[0]), 120, 120);
            }
        }
        if (bl) {
            this.myDrawString(graphics2D, I18n.tr("No tiles at this zoom level", new Object[0]), 120, 120);
        }
        if (Main.isDebugEnabled()) {
            this.myDrawString(graphics2D, I18n.tr("Current zoom: {0}", this.currentZoomLevel), 50, 140);
            this.myDrawString(graphics2D, I18n.tr("Display zoom: {0}", n2), 50, 155);
            this.myDrawString(graphics2D, I18n.tr("Pixel scale: {0}", this.getScaleFactor(this.currentZoomLevel)), 50, 170);
            this.myDrawString(graphics2D, I18n.tr("Best zoom: {0}", Math.log(this.getScaleFactor(1)) / Math.log(2.0) / 2.0 + 1.0), 50, 185);
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                object = (TMSCachedTileLoader)this.tileLoader;
                int n5 = 185;
                for (String string : ((TMSCachedTileLoader)object).getStats().split("\n")) {
                    this.myDrawString(graphics2D, I18n.tr("Cache stats: {0}", string), 50, n5 += 15);
                }
            }
        }
    }

    Tile getTileForPixelpos(int n, int n2) {
        int n3;
        EastNorth eastNorth;
        if (Main.isDebugEnabled()) {
            Main.debug("getTileForPixelpos(" + n + ", " + n2 + ")");
        }
        MapView mapView = Main.map.mapView;
        Point point = new Point(n, n2);
        EastNorth eastNorth2 = mapView.getEastNorth(0, 0);
        TileSet tileSet = new TileSet(eastNorth2, eastNorth = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight()), n3 = this.currentZoomLevel);
        if (!tileSet.tooLarge()) {
            tileSet.loadAllTiles(false);
        }
        Tile tile = null;
        for (Tile tile2 : tileSet.allExistingTiles()) {
            Tile tile3 = this.tempCornerTile(tile2);
            Rectangle rectangle = new Rectangle(this.pixelPos(tile2));
            rectangle.add(this.pixelPos(tile3));
            if (Main.isDebugEnabled()) {
                Main.debug("r: " + rectangle + " clicked: " + point);
            }
            if (!rectangle.contains(point)) continue;
            tile = tile2;
            break;
        }
        if (tile == null) {
            return null;
        }
        return tile;
    }

    @Override
    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new ImageryLayer.OffsetAction(), new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    @Override
    public String getToolTipText() {
        return I18n.tr("TMS layer ({0}), downloading in zoom {1}", this.getName(), this.currentZoomLevel);
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
    }

    @Override
    public boolean isChanged() {
        return this.needRedraw;
    }

    @Override
    public final boolean isProjectionSupported(Projection projection) {
        return "EPSG:3857".equals(projection.toCode()) || "EPSG:4326".equals(projection.toCode());
    }

    @Override
    public final String nameSupportedProjections() {
        return I18n.tr("EPSG:4326 and Mercator projection are supported", new Object[0]);
    }

    static {
        String string = null;
        try {
            string = new File(Main.pref.getCacheDirectory(), "tms").getAbsolutePath();
        }
        catch (SecurityException securityException) {
            Main.warn(securityException);
        }
        PROP_TILECACHE_DIR = new StringProperty("imagery.tms.tilecache", string);
        loaderFactory = new TileLoaderFactory(){

            @Override
            public TileLoader makeTileLoader(TileLoaderListener tileLoaderListener, Map<String, String> map) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("User-Agent", Version.getInstance().getFullAgentString());
                hashMap.put("Accept", "text/html, image/png, image/jpeg, image/gif, */*");
                if (map != null) {
                    hashMap.putAll(map);
                }
                try {
                    return new TMSCachedTileLoader(tileLoaderListener, "TMS", Main.pref.getInteger("socket.timeout.connect", 15) * 1000, Main.pref.getInteger("socket.timeout.read", 30) * 1000, hashMap, PROP_TILECACHE_DIR.get());
                }
                catch (IOException iOException) {
                    Main.warn(iOException);
                    return null;
                }
            }

            @Override
            public TileLoader makeTileLoader(TileLoaderListener tileLoaderListener) {
                return this.makeTileLoader(tileLoaderListener, null);
            }
        };
        InfoFont = new Font("sansserif", 1, 13);
    }

    private class DeepTileSet {
        private final EastNorth topLeft;
        private final EastNorth botRight;
        private final int minZoom;
        private final int maxZoom;
        private final TileSet[] tileSets;
        private final TileSetInfo[] tileSetInfos;

        public DeepTileSet(EastNorth eastNorth, EastNorth eastNorth2, int n, int n2) {
            this.topLeft = eastNorth;
            this.botRight = eastNorth2;
            this.minZoom = n;
            this.maxZoom = n2;
            this.tileSets = new TileSet[n2 - n + 1];
            this.tileSetInfos = new TileSetInfo[n2 - n + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileSet getTileSet(int n) {
            if (n < this.minZoom) {
                return TMSLayer.this.nullTileSet;
            }
            TileSet[] tileSetArray = this.tileSets;
            synchronized (this.tileSets) {
                TileSet tileSet = this.tileSets[n - this.minZoom];
                if (tileSet == null) {
                    this.tileSets[n - this.minZoom] = tileSet = new TileSet(this.topLeft, this.botRight, n);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return tileSet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileSetInfo getTileSetInfo(int n) {
            if (n < this.minZoom) {
                return new TileSetInfo();
            }
            TileSetInfo[] tileSetInfoArray = this.tileSetInfos;
            synchronized (this.tileSetInfos) {
                TileSetInfo tileSetInfo = this.tileSetInfos[n - this.minZoom];
                if (tileSetInfo == null) {
                    this.tileSetInfos[n - this.minZoom] = tileSetInfo = TMSLayer.getTileSetInfo(this.getTileSet(n));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return tileSetInfo;
            }
        }
    }

    private static class TileSetInfo {
        public boolean hasVisibleTiles = false;
        public boolean hasOverzoomedTiles = false;
        public boolean hasLoadingTiles = false;

        private TileSetInfo() {
        }
    }

    private class TileSet {
        private int x0;
        private int x1;
        private int y0;
        private int y1;
        private int zoom;
        private int tileMax = -1;

        TileSet(EastNorth eastNorth, EastNorth eastNorth2, int n) {
            this(tMSLayer.getShiftedLatLon(eastNorth), tMSLayer.getShiftedLatLon(eastNorth2), n);
        }

        TileSet(LatLon latLon, LatLon latLon2, int n) {
            int n2;
            this.zoom = n;
            if (n == 0) {
                return;
            }
            this.x0 = (int)TMSLayer.this.tileSource.lonToTileX(latLon.lon(), n);
            this.y0 = (int)TMSLayer.this.tileSource.latToTileY(latLon.lat(), n);
            this.x1 = (int)TMSLayer.this.tileSource.lonToTileX(latLon2.lon(), n);
            this.y1 = (int)TMSLayer.this.tileSource.latToTileY(latLon2.lat(), n);
            if (this.x0 > this.x1) {
                n2 = this.x0;
                this.x0 = this.x1;
                this.x1 = n2;
            }
            if (this.y0 > this.y1) {
                n2 = this.y0;
                this.y0 = this.y1;
                this.y1 = n2;
            }
            this.tileMax = (int)Math.pow(2.0, n);
            if (this.x0 < 0) {
                this.x0 = 0;
            }
            if (this.y0 < 0) {
                this.y0 = 0;
            }
            if (this.x1 > this.tileMax) {
                this.x1 = this.tileMax;
            }
            if (this.y1 > this.tileMax) {
                this.y1 = this.tileMax;
            }
        }

        boolean tooSmall() {
            return this.tilesSpanned() < 2.1;
        }

        boolean tooLarge() {
            return this.tilesSpanned() > 10.0;
        }

        boolean insane() {
            return this.tilesSpanned() > 100.0;
        }

        double tilesSpanned() {
            return Math.sqrt(1.0 * (double)this.size());
        }

        int size() {
            int n = this.x1 - this.x0 + 1;
            int n2 = this.y1 - this.y0 + 1;
            return n * n2;
        }

        List<Tile> allExistingTiles() {
            return this.__allTiles(false);
        }

        List<Tile> allTilesCreate() {
            return this.__allTiles(true);
        }

        private List<Tile> __allTiles(boolean bl) {
            if (this.zoom == 0 || this.insane()) {
                return Collections.emptyList();
            }
            ArrayList<Tile> arrayList = new ArrayList<Tile>();
            for (int i = this.x0; i <= this.x1; ++i) {
                for (int j = this.y0; j <= this.y1; ++j) {
                    Tile tile = bl ? TMSLayer.this.getOrCreateTile(i % this.tileMax, j % this.tileMax, this.zoom) : TMSLayer.this.getTile(i % this.tileMax, j % this.tileMax, this.zoom);
                    if (tile == null) continue;
                    arrayList.add(tile);
                }
            }
            return arrayList;
        }

        private List<Tile> allLoadedTiles() {
            ArrayList<Tile> arrayList = new ArrayList<Tile>();
            for (Tile tile : this.allExistingTiles()) {
                if (!tile.isLoaded()) continue;
                arrayList.add(tile);
            }
            return arrayList;
        }

        void loadAllTiles(boolean bl) {
            if (!TMSLayer.this.autoLoad && !bl) {
                return;
            }
            for (Tile tile : this.allTilesCreate()) {
                TMSLayer.this.loadTile(tile, false);
            }
        }

        void loadAllErrorTiles(boolean bl) {
            if (!TMSLayer.this.autoLoad && !bl) {
                return;
            }
            for (Tile tile : this.allTilesCreate()) {
                if (!tile.hasError()) continue;
                TMSLayer.this.loadTile(tile, true);
            }
        }
    }

    private static class CachedAttributionBingAerialTileSource
    extends BingAerialTileSource {
        public CachedAttributionBingAerialTileSource(String string) {
            super(string);
        }

        @Override
        protected Callable<List<BingAerialTileSource.Attribution>> getAttributionLoaderCallable() {
            return new Callable<List<BingAerialTileSource.Attribution>>(){

                @Override
                public List<BingAerialTileSource.Attribution> call() throws Exception {
                    BingAttributionData bingAttributionData = new BingAttributionData();
                    int n = 1;
                    while (true) {
                        try {
                            String string = bingAttributionData.updateIfRequiredString();
                            return CachedAttributionBingAerialTileSource.this.parseAttributionText(new InputSource(new StringReader(string)));
                        }
                        catch (IOException iOException) {
                            Main.warn("Could not connect to Bing API. Will retry in " + n + " seconds.");
                            Thread.sleep((long)n * 1000L);
                            n *= 2;
                            continue;
                        }
                        break;
                    }
                }
            };
        }

        class BingAttributionData
        extends CacheCustomContent<IOException> {
            public BingAttributionData() {
                super("bing.attribution.xml", 3600);
            }

            @Override
            protected byte[] updateData() throws IOException {
                URL uRL = CachedAttributionBingAerialTileSource.this.getAttributionUrl();
                try (Scanner scanner = new Scanner(UTFInputStreamReader.create(Utils.openURL(uRL)));){
                    String string = scanner.useDelimiter("\\A").next();
                    Main.info("Successfully loaded Bing attribution data.");
                    byte[] byArray = string.getBytes("UTF-8");
                    return byArray;
                }
            }
        }
    }

    public static interface TileLoaderFactory {
        public TileLoader makeTileLoader(TileLoaderListener var1);

        public TileLoader makeTileLoader(TileLoaderListener var1, Map<String, String> var2);
    }
}

