/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.actions.SaveAsAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class Layer
implements Destroyable,
MapViewPaintable,
ProjectionChangeListener {
    public static final String VISIBLE_PROP = Layer.class.getName() + ".visible";
    public static final String OPACITY_PROP = Layer.class.getName() + ".opacity";
    public static final String NAME_PROP = Layer.class.getName() + ".name";
    public static final int ICON_SIZE = 16;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean visible = true;
    private double opacity = 1.0;
    private boolean background = false;
    private String name;
    private File associatedFile;

    public Layer(String string) {
        this.setName(string);
    }

    public void hookUpMapView() {
    }

    @Override
    public abstract void paint(Graphics2D var1, MapView var2, Bounds var3);

    public abstract Icon getIcon();

    public Color getColor(boolean bl) {
        return null;
    }

    public abstract String getToolTipText();

    public abstract void mergeFrom(Layer var1);

    public abstract boolean isMergable(Layer var1);

    public abstract void visitBoundingBox(BoundingXYVisitor var1);

    public abstract Object getInfoComponent();

    public boolean isInfoResizable() {
        return false;
    }

    public abstract Action[] getMenuEntries();

    @Override
    public void destroy() {
    }

    public File getAssociatedFile() {
        return this.associatedFile;
    }

    public void setAssociatedFile(File file) {
        this.associatedFile = file;
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = this.name;
        this.name = string;
        if (!this.name.equals(string2)) {
            this.propertyChangeSupport.firePropertyChange(NAME_PROP, string2, this.name);
        }
    }

    public boolean isBackgroundLayer() {
        return this.background;
    }

    public void setBackgroundLayer(boolean bl) {
        this.background = bl;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        this.visible = bl;
        if (bl && this.opacity == 0.0) {
            this.setOpacity(1.0);
        } else if (bl2 != this.isVisible()) {
            this.fireVisibleChanged(bl2, this.isVisible());
        }
    }

    public boolean isVisible() {
        return this.visible && this.opacity != 0.0;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        if (!(d >= 0.0) || !(d <= 1.0)) {
            throw new IllegalArgumentException("Opacity value must be between 0 and 1");
        }
        double d2 = this.getOpacity();
        boolean bl = this.isVisible();
        this.opacity = d;
        if (d2 != this.getOpacity()) {
            this.fireOpacityChanged(d2, this.getOpacity());
        }
        if (bl != this.isVisible()) {
            this.fireVisibleChanged(bl, this.isVisible());
        }
    }

    public void toggleVisible() {
        this.setVisible(!this.isVisible());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void fireVisibleChanged(boolean bl, boolean bl2) {
        this.propertyChangeSupport.firePropertyChange(VISIBLE_PROP, bl, bl2);
    }

    protected void fireOpacityChanged(double d, double d2) {
        this.propertyChangeSupport.firePropertyChange(OPACITY_PROP, d, d2);
    }

    public boolean isChanged() {
        return true;
    }

    public boolean isProjectionSupported(Projection projection) {
        return true;
    }

    public String nameSupportedProjections() {
        return I18n.tr("All projections are supported", new Object[0]);
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        if (!this.isProjectionSupported(projection2)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The layer {0} does not support the new projection {1}.\n{2}\nChange the projection again or remove the layer.", this.getName(), projection2.toCode(), this.nameSupportedProjections()), I18n.tr("Warning", new Object[0]), 2);
        }
    }

    public void onPostLoadFromFile() {
    }

    public boolean isSavable() {
        return false;
    }

    public boolean checkSaveConditions() {
        return true;
    }

    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save Layer", new Object[0]), "lay");
    }

    public static class LayerGpxExportAction
    extends AbstractAction {
        private final transient Layer layer;

        public LayerGpxExportAction(Layer layer) {
            this.putValue("SmallIcon", ImageProvider.get("exportgpx"));
            this.putValue("ShortDescription", I18n.tr("Export the data to GPX file.", new Object[0]));
            this.putValue("Name", I18n.tr("Export to GPX...", new Object[0]));
            this.setEnabled(true);
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new GpxExportAction().export(this.layer);
        }
    }

    public static class LayerSaveAsAction
    extends AbstractAction {
        private final transient Layer layer;

        public LayerSaveAsAction(Layer layer) {
            this.putValue("SmallIcon", ImageProvider.get("save_as"));
            this.putValue("ShortDescription", I18n.tr("Save the current data to a new file.", new Object[0]));
            this.putValue("Name", I18n.tr("Save As...", new Object[0]));
            this.setEnabled(true);
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveAsAction.getInstance().doSave(this.layer);
        }
    }

    public static class LayerSaveAction
    extends AbstractAction {
        private final transient Layer layer;

        public LayerSaveAction(Layer layer) {
            this.putValue("SmallIcon", ImageProvider.get("save"));
            this.putValue("ShortDescription", I18n.tr("Save the current data.", new Object[0]));
            this.putValue("Name", I18n.tr("Save", new Object[0]));
            this.setEnabled(true);
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveAction.getInstance().doSave(this.layer);
        }
    }

    public static class SeparatorLayerAction
    extends AbstractAction
    implements LayerAction {
        public static final SeparatorLayerAction INSTANCE = new SeparatorLayerAction();

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Component createMenuComponent() {
            return new JSeparator();
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return false;
        }
    }

    public static interface MultiLayerAction {
        public Action getMultiLayerAction(List<Layer> var1);
    }

    public static interface LayerAction {
        public boolean supportLayers(List<Layer> var1);

        public Component createMenuComponent();
    }
}

