/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.util.CellEditorSupport;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

class LayerNameAndFilePathTableCell
extends JPanel
implements TableCellRenderer,
TableCellEditor {
    private static final Color colorError = new Color(255, 197, 197);
    private static final String separator = System.getProperty("file.separator");
    private static final String ellipsis = "\u2026" + separator;
    private final JLabel lblLayerName = new JLabel();
    private final JLabel lblFilename = new JLabel("");
    private final JosmTextField tfFilename = new JosmTextField();
    private final JButton btnFileChooser = new JButton(new LaunchFileChooserAction());
    private static final GBC defaultCellStyle = GBC.eol().fill(2).insets(2, 0, 2, 0);
    private final transient CellEditorSupport cellEditorSupport = new CellEditorSupport(this);
    private File value;

    public LayerNameAndFilePathTableCell() {
        this.setLayout(new GridBagLayout());
        this.lblLayerName.setPreferredSize(new Dimension(this.lblLayerName.getPreferredSize().width, 19));
        this.lblLayerName.setFont(this.lblLayerName.getFont().deriveFont(1));
        this.lblFilename.setPreferredSize(new Dimension(this.lblFilename.getPreferredSize().width, 19));
        this.lblFilename.setOpaque(true);
        this.tfFilename.setToolTipText(I18n.tr("Either edit the path manually in the text field or click the \"...\" button to open a file chooser.", new Object[0]));
        this.tfFilename.setPreferredSize(new Dimension(this.tfFilename.getPreferredSize().width, 19));
        this.tfFilename.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                LayerNameAndFilePathTableCell.this.tfFilename.selectAll();
            }
        });
        this.tfFilename.setBorder(BorderFactory.createLineBorder(this.getBackground()));
        this.btnFileChooser.setPreferredSize(new Dimension(20, 19));
        this.btnFileChooser.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.removeAll();
        SaveLayerInfo saveLayerInfo = (SaveLayerInfo)object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(this.addLblLayerName(saveLayerInfo));
        stringBuilder.append("<br>");
        this.add((Component)this.btnFileChooser, GBC.std());
        stringBuilder.append(this.addLblFilename(saveLayerInfo));
        stringBuilder.append("</html>");
        this.setToolTipText(stringBuilder.toString());
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.removeAll();
        SaveLayerInfo saveLayerInfo = (SaveLayerInfo)object;
        object = saveLayerInfo.getFile();
        this.tfFilename.setText(object == null ? "" : object.toString());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(this.addLblLayerName(saveLayerInfo));
        stringBuilder.append("<br/>");
        this.add((Component)this.btnFileChooser, GBC.std());
        this.add((Component)this.tfFilename, GBC.eol().fill(2).insets(1, 0, 0, 0));
        this.tfFilename.selectAll();
        stringBuilder.append(this.tfFilename.getToolTipText());
        stringBuilder.append("</html>");
        this.setToolTipText(stringBuilder.toString());
        return this;
    }

    private static boolean canWrite(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        if (file.exists() && file.canWrite()) {
            return true;
        }
        return !file.exists() && file.getParentFile() != null && file.getParentFile().canWrite();
    }

    private String addLblLayerName(SaveLayerInfo saveLayerInfo) {
        this.lblLayerName.setIcon(saveLayerInfo.getLayer().getIcon());
        this.lblLayerName.setText(saveLayerInfo.getName());
        this.add((Component)this.lblLayerName, defaultCellStyle);
        return I18n.tr("The bold text is the name of the layer.", new Object[0]);
    }

    private String addLblFilename(SaveLayerInfo saveLayerInfo) {
        String string = "";
        boolean bl = false;
        if (saveLayerInfo.getFile() == null) {
            bl = saveLayerInfo.isDoSaveToFile();
            this.lblFilename.setText(I18n.tr("Click here to choose save path", new Object[0]));
            this.lblFilename.setFont(this.lblFilename.getFont().deriveFont(2));
            string = I18n.tr("Layer ''{0}'' is not backed by a file", saveLayerInfo.getName());
        } else {
            String string2 = saveLayerInfo.getFile().getPath();
            this.lblFilename.setText(this.makePathFit(string2));
            string = saveLayerInfo.getFile().getAbsolutePath();
            if (saveLayerInfo.isDoSaveToFile() && !LayerNameAndFilePathTableCell.canWrite(saveLayerInfo.getFile())) {
                bl = true;
                string = I18n.tr("File ''{0}'' is not writable. Please enter another file name.", saveLayerInfo.getFile().getPath());
            }
        }
        this.lblFilename.setBackground(bl ? colorError : this.getBackground());
        this.btnFileChooser.setBackground(bl ? colorError : this.getBackground());
        this.add((Component)this.lblFilename, defaultCellStyle);
        return I18n.tr("Click cell to change the file path.", new Object[0]) + "<br/>" + string;
    }

    private String makePathFit(String string) {
        int n;
        boolean bl = false;
        while (string != null && !string.isEmpty() && (n = this.lblFilename.getFontMetrics(this.lblFilename.getFont()).stringWidth(string)) >= this.lblFilename.getWidth() && string.lastIndexOf(separator) >= ellipsis.length()) {
            string = bl ? string.substring(ellipsis.length()) : string;
            string = ellipsis + string.substring(string.indexOf(separator) + 1);
            bl = true;
        }
        return string;
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.cellEditorSupport.addCellEditorListener(cellEditorListener);
    }

    @Override
    public void cancelCellEditing() {
        this.cellEditorSupport.fireEditingCanceled();
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.cellEditorSupport.removeCellEditorListener(cellEditorListener);
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.value = this.tfFilename.getText() == null || this.tfFilename.getText().trim().isEmpty() ? null : new File(this.tfFilename.getText());
        this.cellEditorSupport.fireEditingStopped();
        return true;
    }

    private class LaunchFileChooserAction
    extends AbstractAction {
        public LaunchFileChooserAction() {
            this.putValue("Name", "...");
            this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Select filename", new Object[0]), "osm");
            if (file != null) {
                LayerNameAndFilePathTableCell.this.tfFilename.setText(file.toString());
                LayerNameAndFilePathTableCell.this.stopCellEditing();
            }
        }
    }
}

