/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.HelpAction;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.LanguageInfo;

public final class HelpUtil {
    private HelpUtil() {
    }

    public static String getWikiBaseUrl() {
        return Main.pref.get("help.baseurl", Main.getJOSMWebsite());
    }

    public static String getWikiBaseHelpUrl() {
        return HelpUtil.getWikiBaseUrl() + "/wiki";
    }

    public static String getHelpTopicUrl(String string) {
        if (string == null) {
            return null;
        }
        String string2 = HelpUtil.getWikiBaseHelpUrl();
        string2 = string2.replaceAll("\\/+$", "");
        string = string.replace(" ", "%20");
        string = string.replaceAll("^\\/+", "/");
        return string2 + string;
    }

    public static String getHelpTopicEditUrl(String string) {
        String string2 = HelpUtil.getHelpTopicUrl(string);
        string2 = string2.replaceAll("#[^#]*$", "");
        return string2 + "?action=edit";
    }

    public static String extractRelativeHelpTopic(String string) {
        String string2 = HelpUtil.extractAbsoluteHelpTopic(string);
        if (string2 == null) {
            return null;
        }
        String string3 = "/[A-Z][a-z]{1,2}(_[A-Z]{2})?:" + HelpUtil.getHelpTopicPrefix(LanguageInfo.LocaleType.ENGLISH).replaceAll("^\\/+", "");
        if (string.matches(string3)) {
            return string2.substring(string3.length());
        }
        return null;
    }

    public static String extractAbsoluteHelpTopic(String string) {
        String string2;
        if (!string.startsWith(HelpUtil.getWikiBaseHelpUrl())) {
            return null;
        }
        if ((string = string.substring(HelpUtil.getWikiBaseHelpUrl().length())).startsWith(string2 = HelpUtil.getHelpTopicPrefix(LanguageInfo.LocaleType.ENGLISH))) {
            return string;
        }
        String string3 = "/[A-Z][a-z]{1,2}(_[A-Z]{2})?:" + string2.replaceAll("^\\/+", "");
        if (string.matches(string3)) {
            return string;
        }
        return null;
    }

    private static String getHelpTopicPrefix(LanguageInfo.LocaleType localeType) {
        String string = LanguageInfo.getWikiLanguagePrefix(localeType);
        if (string == null) {
            return string;
        }
        string = "/" + string + Main.pref.get("help.pathhelp", "/Help").replaceAll("^\\/+", "");
        return string.replaceAll("\\/+", "\\/");
    }

    public static String buildAbsoluteHelpTopic(String string, LanguageInfo.LocaleType localeType) {
        String string2 = HelpUtil.getHelpTopicPrefix(localeType);
        if (string2 == null || string == null || string.trim().length() == 0 || "/".equals(string.trim())) {
            return string2;
        }
        string2 = string2 + "/" + string;
        return string2.replaceAll("\\/+", "\\/");
    }

    public static String getContextSpecificHelpTopic(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Helpful) {
            return ((Helpful)object).helpTopic();
        }
        if (object instanceof JMenu) {
            JMenu jMenu = (JMenu)object;
            if (jMenu.getClientProperty("help") != null) {
                return (String)jMenu.getClientProperty("help");
            }
            return null;
        }
        if (object instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)object;
            if (abstractButton.getClientProperty("help") != null) {
                return (String)abstractButton.getClientProperty("help");
            }
            return HelpUtil.getContextSpecificHelpTopic(abstractButton.getAction());
        }
        if (object instanceof Action) {
            return (String)((Action)object).getValue("help");
        }
        if (object instanceof JComponent && ((JComponent)object).getClientProperty("help") != null) {
            return (String)((JComponent)object).getClientProperty("help");
        }
        if (object instanceof Component) {
            return HelpUtil.getContextSpecificHelpTopic(((Component)object).getParent());
        }
        return null;
    }

    private static Action getHelpAction() {
        if (Main.main != null && Main.main.menu != null) {
            return Main.main.menu.help;
        }
        return new HelpAction();
    }

    public static void setHelpContext(JComponent jComponent, String string) {
        jComponent.getInputMap(2).put(KeyStroke.getKeyStroke("F1"), "help");
        jComponent.getActionMap().put("help", HelpUtil.getHelpAction());
        jComponent.putClientProperty("help", string == null ? "/" : string);
    }

    public static String ht(String string) {
        return string;
    }
}

