/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDiscussionTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDiscussionTableModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetHeaderDownloadTask;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetDiscussionPanel
extends JPanel
implements PropertyChangeListener {
    private final UpdateChangesetDiscussionAction actUpdateChangesets = new UpdateChangesetDiscussionAction();
    private final ChangesetDiscussionTableModel model = new ChangesetDiscussionTableModel();
    private JTable table;
    private transient Changeset current = null;

    protected JPanel buildActionButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.add(this.actUpdateChangesets);
        this.actUpdateChangesets.initProperties(this.current);
        jPanel.add(jToolBar);
        return jPanel;
    }

    public ChangesetDiscussionPanel() {
        this.build();
    }

    protected void setCurrentChangeset(Changeset changeset) {
        this.current = changeset;
        if (changeset == null) {
            this.clearView();
        } else {
            this.updateView(changeset);
        }
        this.actUpdateChangesets.initProperties(this.current);
        if (changeset != null && changeset.getDiscussion().size() < changeset.getCommentsCount()) {
            this.actUpdateChangesets.actionPerformed(null);
        }
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)this.buildActionButtonPanel(), "West");
        this.add(this.buildDiscussionPanel(), "Center");
    }

    private Component buildDiscussionPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.table = new JTable(this.model, new ChangesetDiscussionTableColumnModel());
        this.table.getColumnModel().getColumn(2).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("width".equals(propertyChangeEvent.getPropertyName())) {
                    ChangesetDiscussionPanel.this.updateRowHeights();
                }
            }
        });
        jPanel.add((Component)new JScrollPane(this.table), "Center");
        return jPanel;
    }

    protected void clearView() {
        this.model.populate(null);
    }

    protected void updateView(Changeset changeset) {
        this.model.populate(changeset.getDiscussion());
        this.updateRowHeights();
    }

    protected void updateRowHeights() {
        int n = this.table.getIntercellSpacing().width;
        int n2 = this.table.getColumnModel().getColumn(2).getWidth();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            int n3 = this.table.getRowHeight();
            Component component = this.table.prepareRenderer(this.table.getCellRenderer(i, 2), i, 2);
            component.setBounds(new Rectangle(0, 0, n2 - n, Integer.MAX_VALUE));
            n3 = Math.max(n3, component.getPreferredSize().height);
            this.table.setRowHeight(i, n3);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals(ChangesetCacheManagerModel.CHANGESET_IN_DETAIL_VIEW_PROP)) {
            return;
        }
        this.setCurrentChangeset((Changeset)propertyChangeEvent.getNewValue());
    }

    class UpdateChangesetDiscussionAction
    extends AbstractAction {
        public UpdateChangesetDiscussionAction() {
            this.putValue("Name", I18n.tr("Update changeset discussion", new Object[0]));
            this.putValue("SmallIcon", ChangesetCacheManager.UPDATE_CONTENT_ICON);
            this.putValue("ShortDescription", I18n.tr("Update the changeset discussion from the OSM server", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ChangesetDiscussionPanel.this.current == null) {
                return;
            }
            Main.worker.submit(new ChangesetHeaderDownloadTask((Component)ChangesetDiscussionPanel.this, Collections.singleton(ChangesetDiscussionPanel.this.current.getId()), true));
        }

        public void initProperties(Changeset changeset) {
            this.setEnabled(changeset != null && !Main.isOffline(OnlineResource.OSM_API));
        }
    }
}

