/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractSelectAction;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.relation.EditRelationAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreePanel;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class ValidatorDialog
extends ToggleDialog
implements SelectionChangedListener,
MapView.LayerChangeListener {
    public ValidatorTreePanel tree;
    private SideButton fixButton;
    private SideButton ignoreButton;
    private SideButton selectButton;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final transient PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this.popupMenu);
    private DefaultMutableTreeNode lastSelectedNode = null;
    private transient OsmDataLayer linkedLayer;

    public ValidatorDialog() {
        super(I18n.tr("Validation Results", new Object[0]), "validator", I18n.tr("Open the validation window.", new Object[0]), Shortcut.registerShortcut("subwindow:validator", I18n.tr("Toggle: {0}", I18n.tr("Validation results", new Object[0])), 86, 5007), 150, false, ValidatorPreference.class);
        this.popupMenuHandler.addAction(Main.main.menu.autoScaleActions.get("problem"));
        this.popupMenuHandler.addAction(new EditRelationAction());
        this.tree = new ValidatorTreePanel();
        this.tree.addMouseListener(new MouseEventHandler());
        this.addTreeSelectionListener(new SelectionWatch());
        InputMapUtils.unassignCtrlShiftUpDown(this.tree, 0);
        LinkedList<SideButton> linkedList = new LinkedList<SideButton>();
        this.selectButton = new SideButton(new AbstractSelectAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidatorDialog.this.setSelectedItems();
            }
        });
        InputMapUtils.addEnterAction(this.tree, this.selectButton.getAction());
        this.selectButton.setEnabled(false);
        linkedList.add(this.selectButton);
        linkedList.add(new SideButton(Main.main.validator.validateAction));
        this.fixButton = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Fix", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Fix the selected issue.", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "fix"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidatorDialog.this.fixErrors();
            }
        });
        this.fixButton.setEnabled(false);
        linkedList.add(this.fixButton);
        if (Main.pref.getBoolean("validator.ignore", true)) {
            this.ignoreButton = new SideButton(new AbstractAction(){
                {
                    this.putValue("Name", I18n.tr("Ignore", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Ignore the selected issue next time.", new Object[0]));
                    this.putValue("SmallIcon", ImageProvider.get("dialogs", "fix"));
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ValidatorDialog.this.ignoreErrors();
                }
            });
            this.ignoreButton.setEnabled(false);
            linkedList.add(this.ignoreButton);
        } else {
            this.ignoreButton = null;
        }
        this.createLayout(this.tree, true, linkedList);
    }

    @Override
    public void showNotify() {
        DataSet.addSelectionListener(this);
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet != null) {
            this.updateSelection(dataSet.getAllSelected());
        }
        MapView.addLayerChangeListener(this);
        Layer layer = Main.map.mapView.getActiveLayer();
        if (layer != null) {
            this.activeLayerChange(null, layer);
        }
    }

    @Override
    public void hideNotify() {
        MapView.removeLayerChangeListener(this);
        DataSet.removeSelectionListener(this);
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.tree != null) {
            this.tree.setVisible(bl);
        }
        super.setVisible(bl);
        Main.map.repaint();
    }

    private void fixErrors() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        HashSet<DefaultMutableTreeNode> hashSet = new HashSet<DefaultMutableTreeNode>();
        LinkedList<TestError> linkedList = new LinkedList<TestError>();
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode == null) continue;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (hashSet.contains(defaultMutableTreeNode2)) continue;
                hashSet.add(defaultMutableTreeNode2);
                Object object = defaultMutableTreeNode2.getUserObject();
                if (!(object instanceof TestError)) continue;
                linkedList.add((TestError)object);
            }
        }
        FixTask fixTask = new FixTask(linkedList);
        Main.worker.submit(fixTask);
    }

    private void ignoreErrors() {
        int n = -1;
        boolean bl = false;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (TreePath treePath : treePathArray) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode == null) continue;
            Object object6 = defaultMutableTreeNode.getUserObject();
            if (!(object6 instanceof TestError)) {
                object5 = new HashSet();
                if (n == -1) {
                    object4 = new String[]{I18n.tr("Whole group", new Object[0]), I18n.tr("Single elements", new Object[0]), I18n.tr("Nothing", new Object[0])};
                    n = JOptionPane.showOptionDialog(Main.parent, I18n.tr("Ignore whole group or individual elements?", new Object[0]), I18n.tr("Ignoring elements", new Object[0]), 1, 2, null, object4, object4[1]);
                }
                if (n == 0) {
                    object4 = defaultMutableTreeNode.breadthFirstEnumeration();
                    while (object4.hasMoreElements()) {
                        object3 = (DefaultMutableTreeNode)object4.nextElement();
                        if (hashSet.contains(object3)) continue;
                        hashSet.add(object3);
                        object2 = ((DefaultMutableTreeNode)object3).getUserObject();
                        if (!(object2 instanceof TestError)) continue;
                        object = (TestError)object2;
                        ((TestError)object).setIgnored(true);
                        bl = true;
                        object5.add(defaultMutableTreeNode.getDepth() == 1 ? ((TestError)object).getIgnoreSubGroup() : ((TestError)object).getIgnoreGroup());
                    }
                    object3 = object5.iterator();
                    while (object3.hasNext()) {
                        object2 = (String)object3.next();
                        OsmValidator.addIgnoredError((String)object2);
                    }
                    continue;
                }
                if (n == 2 || n == -1) continue;
            }
            object5 = defaultMutableTreeNode.breadthFirstEnumeration();
            while (object5.hasMoreElements()) {
                object4 = (DefaultMutableTreeNode)object5.nextElement();
                if (hashSet.contains(object4)) continue;
                hashSet.add(object4);
                object3 = object4.getUserObject();
                if (!(object3 instanceof TestError)) continue;
                object2 = (TestError)object3;
                object = ((TestError)object2).getIgnoreState();
                if (object != null) {
                    OsmValidator.addIgnoredError((String)object);
                }
                bl = true;
                ((TestError)object2).setIgnored(true);
            }
        }
        if (bl) {
            this.tree.resetErrors();
            OsmValidator.saveIgnoredErrors();
            Main.map.repaint();
        }
    }

    private void setSelectedItems() {
        if (this.tree == null) {
            return;
        }
        HashSet<? extends OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(40);
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                Object object = defaultMutableTreeNode2.getUserObject();
                if (!(object instanceof TestError)) continue;
                TestError testError = (TestError)object;
                hashSet.addAll(testError.getSelectablePrimitives());
            }
        }
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet != null) {
            dataSet.setSelected(hashSet);
        }
    }

    private boolean setSelection(Collection<OsmPrimitive> collection, boolean bl) {
        TestError testError;
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode;
        Enumeration<TreeNode> enumeration;
        boolean bl2 = false;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.lastSelectedNode != null && !this.lastSelectedNode.equals(defaultMutableTreeNode2)) {
            enumeration = this.lastSelectedNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                object = defaultMutableTreeNode.getUserObject();
                if (!(object instanceof TestError)) continue;
                testError = (TestError)object;
                testError.setSelected(false);
            }
        }
        this.lastSelectedNode = defaultMutableTreeNode2;
        if (defaultMutableTreeNode2 == null) {
            return bl2;
        }
        enumeration = defaultMutableTreeNode2.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof TestError)) continue;
            testError = (TestError)object;
            testError.setSelected(true);
            boolean bl3 = bl2 = bl2 || testError.isFixable();
            if (!bl) continue;
            collection.addAll(testError.getSelectablePrimitives());
        }
        this.selectButton.setEnabled(true);
        if (this.ignoreButton != null) {
            this.ignoreButton.setEnabled(true);
        }
        return bl2;
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        if (layer2 instanceof OsmDataLayer) {
            this.linkedLayer = (OsmDataLayer)layer2;
            this.tree.setErrorList(this.linkedLayer.validationErrors);
        }
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void layerRemoved(Layer layer) {
        if (layer == this.linkedLayer) {
            this.tree.setErrorList(new ArrayList<TestError>());
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.removeTreeSelectionListener(treeSelectionListener);
    }

    public PopupMenuHandler getPopupMenuHandler() {
        return this.popupMenuHandler;
    }

    public TestError getSelectedError() {
        Object object;
        Object object2 = this.tree.getLastSelectedPathComponent();
        if (object2 instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)object2).getUserObject()) instanceof TestError) {
            return (TestError)object;
        }
        return null;
    }

    public void updateSelection(Collection<? extends OsmPrimitive> collection) {
        if (!Main.pref.getBoolean("validator.selectionFilter", false)) {
            return;
        }
        if (collection.isEmpty()) {
            this.tree.setFilter(null);
        }
        this.tree.setFilter(new HashSet<OsmPrimitive>(collection));
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.updateSelection(collection);
    }

    class FixTask
    extends PleaseWaitRunnable {
        private Collection<TestError> testErrors;
        private boolean canceled;

        public FixTask(Collection<TestError> arrayList) {
            super(I18n.tr("Fixing errors ...", new Object[0]), false);
            this.testErrors = arrayList == null ? new ArrayList() : arrayList;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
        }

        protected void fixError(TestError testError) throws InterruptedException, InvocationTargetException {
            if (testError.isFixable()) {
                final Command command = testError.getFix();
                if (command != null) {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Main.main.undoRedo.addNoRedraw(command);
                        }
                    });
                }
                testError.setIgnored(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            ProgressMonitor progressMonitor = this.getProgressMonitor();
            try {
                progressMonitor.setTicksCount(this.testErrors.size());
                int n = 0;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Main.main.getCurrentDataSet().beginUpdate();
                    }
                });
                try {
                    for (TestError testError : this.testErrors) {
                        progressMonitor.subTask(I18n.tr("Fixing ({0}/{1}): ''{2}''", ++n, this.testErrors.size(), testError.getMessage()));
                        if (!this.canceled) break block10;
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Main.main.getCurrentDataSet().endUpdate();
                        }
                    });
                    throw throwable;
                }
                {
                    TestError testError;
                    block10: {
                        SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    this.fixError(testError);
                    progressMonitor.worked(1);
                    continue;
                }
                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                progressMonitor.subTask(I18n.tr("Updating map ...", new Object[0]));
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Main.main.undoRedo.afterAdd();
                        Main.map.repaint();
                        ValidatorDialog.this.tree.resetErrors();
                        Main.main.getCurrentDataSet().fireSelectionChanged();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
            finally {
                progressMonitor.finishTask();
            }
        }
    }

    public static class ValidatorBoundingXYVisitor
    extends BoundingXYVisitor
    implements ValidatorVisitor {
        @Override
        public void visit(OsmPrimitive osmPrimitive) {
            if (osmPrimitive.isUsable()) {
                osmPrimitive.accept(this);
            }
        }

        @Override
        public void visit(WaySegment waySegment) {
            if (waySegment.lowerIndex < 0 || waySegment.lowerIndex + 1 >= waySegment.way.getNodesCount()) {
                return;
            }
            this.visit(waySegment.way.getNodes().get(waySegment.lowerIndex));
            this.visit(waySegment.way.getNodes().get(waySegment.lowerIndex + 1));
        }

        @Override
        public void visit(List<Node> list) {
            for (Node node : list) {
                this.visit(node);
            }
        }

        @Override
        public void visit(TestError testError) {
            if (testError != null) {
                testError.visitHighlighted(this);
            }
        }
    }

    public class SelectionWatch
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            ValidatorDialog.this.fixButton.setEnabled(false);
            if (ValidatorDialog.this.ignoreButton != null) {
                ValidatorDialog.this.ignoreButton.setEnabled(false);
            }
            ValidatorDialog.this.selectButton.setEnabled(false);
            HashSet hashSet = new HashSet();
            boolean bl = ValidatorDialog.this.setSelection(hashSet, true);
            ValidatorDialog.this.fixButton.setEnabled(bl);
            ValidatorDialog.this.popupMenuHandler.setPrimitives(hashSet);
            if (Main.map != null) {
                Main.map.repaint();
            }
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        public MouseEventHandler() {
            super(ValidatorDialog.this.popupMenu);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ValidatorDialog.this.fixButton.setEnabled(false);
            if (ValidatorDialog.this.ignoreButton != null) {
                ValidatorDialog.this.ignoreButton.setEnabled(false);
            }
            ValidatorDialog.this.selectButton.setEnabled(false);
            boolean bl = MouseEventHandler.isDoubleClick(mouseEvent);
            HashSet<OsmPrimitive> hashSet = bl ? new HashSet<OsmPrimitive>(40) : null;
            boolean bl2 = ValidatorDialog.this.setSelection(hashSet, bl);
            ValidatorDialog.this.fixButton.setEnabled(bl2);
            if (bl) {
                Main.main.getCurrentDataSet().setSelected(hashSet);
                if (Main.pref.getBoolean("validator.autozoom", false)) {
                    AutoScaleAction.zoomTo(hashSet);
                }
            }
        }

        @Override
        public void launch(MouseEvent mouseEvent) {
            TreePath treePath = ValidatorDialog.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
            if (!(defaultMutableTreeNode.getUserObject() instanceof TestError)) {
                return;
            }
            super.launch(mouseEvent);
        }
    }
}

