/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class UserListDialog
extends ToggleDialog
implements SelectionChangedListener,
MapView.LayerChangeListener {
    private JTable userTable;
    private UserTableModel model;
    private SelectUsersPrimitivesAction selectionUsersPrimitivesAction;
    private ShowUserInfoAction showUserInfoAction;

    public UserListDialog() {
        super(I18n.tr("Authors", new Object[0]), "userlist", I18n.tr("Open a list of people working on the selected objects.", new Object[0]), Shortcut.registerShortcut("subwindow:authors", I18n.tr("Toggle: {0}", I18n.tr("Authors", new Object[0])), 65, 5007), 150);
        this.build();
    }

    @Override
    public void showNotify() {
        DataSet.addSelectionListener(this);
        MapView.addLayerChangeListener(this);
    }

    @Override
    public void hideNotify() {
        MapView.removeLayerChangeListener(this);
        DataSet.removeSelectionListener(this);
    }

    protected void build() {
        this.model = new UserTableModel();
        this.userTable = new JTable(this.model);
        this.userTable.setSelectionMode(2);
        this.userTable.addMouseListener(new DoubleClickAdapter());
        this.selectionUsersPrimitivesAction = new SelectUsersPrimitivesAction();
        this.userTable.getSelectionModel().addListSelectionListener(this.selectionUsersPrimitivesAction);
        this.showUserInfoAction = new ShowUserInfoAction();
        this.userTable.getSelectionModel().addListSelectionListener(this.showUserInfoAction);
        this.createLayout(this.userTable, true, Arrays.asList(new SideButton(this.selectionUsersPrimitivesAction), new SideButton(this.showUserInfoAction)));
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.refresh(collection);
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        if (layer2 instanceof OsmDataLayer) {
            this.refresh(((OsmDataLayer)layer2).data.getAllSelected());
        } else {
            this.refresh(null);
        }
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void layerRemoved(Layer layer) {
    }

    public void refresh(Collection<? extends OsmPrimitive> collection) {
        this.model.populate(collection);
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (UserListDialog.this.model.getRowCount() != 0) {
                    UserListDialog.this.setTitle(I18n.trn("{0} Author", "{0} Authors", UserListDialog.this.model.getRowCount(), UserListDialog.this.model.getRowCount()));
                } else {
                    UserListDialog.this.setTitle(I18n.tr("Authors", new Object[0]));
                }
            }
        });
    }

    @Override
    public void showDialog() {
        super.showDialog();
        Layer layer = Main.main.getActiveLayer();
        if (layer instanceof OsmDataLayer) {
            this.refresh(((OsmDataLayer)layer).data.getAllSelected());
        }
    }

    static class UserTableModel
    extends DefaultTableModel {
        private transient List<UserInfo> data;

        public UserTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr("Author", new Object[0]), I18n.tr("# Objects", new Object[0]), "%"});
            this.data = new ArrayList<UserInfo>();
        }

        protected Map<User, Integer> computeStatistics(Collection<? extends OsmPrimitive> collection) {
            HashMap<User, Integer> hashMap = new HashMap<User, Integer>();
            if (collection == null || collection.isEmpty()) {
                return hashMap;
            }
            for (OsmPrimitive osmPrimitive : collection) {
                if (hashMap.containsKey(osmPrimitive.getUser())) {
                    hashMap.put(osmPrimitive.getUser(), (Integer)hashMap.get(osmPrimitive.getUser()) + 1);
                    continue;
                }
                hashMap.put(osmPrimitive.getUser(), 1);
            }
            return hashMap;
        }

        public void populate(Collection<? extends OsmPrimitive> collection) {
            Map<User, Integer> map = this.computeStatistics(collection);
            this.data.clear();
            if (collection != null) {
                for (Map.Entry<User, Integer> entry : map.entrySet()) {
                    this.data.add(new UserInfo(entry.getKey(), entry.getValue(), (double)entry.getValue().intValue() / (double)collection.size()));
                }
            }
            Collections.sort(this.data);
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    UserTableModel.this.fireTableDataChanged();
                }
            });
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            UserInfo userInfo = this.data.get(n);
            switch (n2) {
                case 0: {
                    return userInfo.getName() == null ? "" : userInfo.getName();
                }
                case 1: {
                    return userInfo.count;
                }
                case 2: {
                    return NumberFormat.getPercentInstance().format(userInfo.percent);
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void selectPrimitivesOwnedBy(int[] nArray) {
            HashSet<User> hashSet = new HashSet<User>();
            for (int n : nArray) {
                hashSet.add(this.data.get((int)n).user);
            }
            Object object = Main.main.getCurrentDataSet().getAllSelected();
            LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                OsmPrimitive osmPrimitive = (OsmPrimitive)iterator.next();
                if (!hashSet.contains(osmPrimitive.getUser())) continue;
                linkedList.add(osmPrimitive);
            }
            Main.main.getCurrentDataSet().setSelected(linkedList);
        }

        public List<User> getSelectedUsers(int[] nArray) {
            LinkedList<User> linkedList = new LinkedList<User>();
            if (nArray == null || nArray.length == 0) {
                return linkedList;
            }
            for (int n : nArray) {
                if (this.data.get((int)n).user == null) continue;
                linkedList.add(this.data.get((int)n).user);
            }
            return linkedList;
        }
    }

    private static class UserInfo
    implements Comparable<UserInfo> {
        public User user;
        public int count;
        public double percent;

        UserInfo(User user, int n, double d) {
            this.user = user;
            this.count = n;
            this.percent = d;
        }

        @Override
        public int compareTo(UserInfo userInfo) {
            if (this.count < userInfo.count) {
                return 1;
            }
            if (this.count > userInfo.count) {
                return -1;
            }
            if (this.user == null || this.user.getName() == null) {
                return 1;
            }
            if (userInfo.user == null || userInfo.user.getName() == null) {
                return -1;
            }
            return this.user.getName().compareTo(userInfo.user.getName());
        }

        public String getName() {
            if (this.user == null) {
                return I18n.tr("<new object>", new Object[0]);
            }
            return this.user.getName();
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                UserListDialog.this.selectionUsersPrimitivesAction.select();
            }
        }
    }

    class ShowUserInfoAction
    extends AbstractInfoAction
    implements ListSelectionListener {
        public ShowUserInfoAction() {
            super(false);
            this.putValue("Name", I18n.tr("Show info", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Launches a browser with information about the user", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help/internet"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            int[] nArray = UserListDialog.this.userTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            List<User> list = UserListDialog.this.model.getSelectedUsers(nArray);
            if (list.isEmpty()) {
                return;
            }
            if (list.size() > 10) {
                Main.warn(I18n.tr("Only launching info browsers for the first {0} of {1} selected users", 10, list.size()));
            }
            Iterator<User> iterator = list.iterator();
            for (int i = Math.min(10, list.size()); iterator.hasNext() && i > 0 && (string = this.createInfoUrl(iterator.next())) != null; --i) {
                OpenBrowser.displayUrl(string);
            }
        }

        @Override
        protected String createInfoUrl(Object object) {
            User user = (User)object;
            return Main.getBaseUserUrl() + "/" + Utils.encodeUrl(user.getName()).replaceAll("\\+", "%20");
        }

        @Override
        protected void updateEnabledState() {
            this.setEnabled(UserListDialog.this.userTable != null && UserListDialog.this.userTable.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class SelectUsersPrimitivesAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectUsersPrimitivesAction() {
            this.putValue("Name", I18n.tr("Select", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Select objects submitted by this user", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.updateEnabledState();
        }

        public void select() {
            int[] nArray = UserListDialog.this.userTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            UserListDialog.this.model.selectPrimitivesOwnedBy(UserListDialog.this.userTable.getSelectedRows());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.select();
        }

        protected void updateEnabledState() {
            this.setEnabled(UserListDialog.this.userTable != null && UserListDialog.this.userTable.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }
}

