/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Timer;
import org.openstreetmap.josm.tools.ImageProvider;

public class ScrollViewport
extends JPanel {
    private static final int NO_SCROLL = 0;
    public static final int UP_DIRECTION = 1;
    public static final int DOWN_DIRECTION = 2;
    public static final int LEFT_DIRECTION = 4;
    public static final int RIGHT_DIRECTION = 8;
    public static final int VERTICAL_DIRECTION = 3;
    public static final int HORIZONTAL_DIRECTION = 12;
    public static final int ALL_DIRECTION = 15;
    private JViewport vp = new JViewport();
    private JComponent component = null;
    private transient List<JButton> buttons = new ArrayList<JButton>();
    private Timer timer = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScrollViewport.this.scroll();
        }
    });
    private int scrollDirection = 0;

    public ScrollViewport(JComponent jComponent, int n) {
        this(n);
        this.add(jComponent);
    }

    public ScrollViewport(int n) {
        JButton jButton;
        this.setLayout(new BorderLayout());
        if ((n & 1) > 0) {
            jButton = new JButton();
            jButton.addMouseListener(new ScrollViewPortMouseListener(1));
            jButton.setPreferredSize(new Dimension(10, 10));
            jButton.setIcon(ImageProvider.get("svpUp"));
            this.add((Component)jButton, "North");
            this.buttons.add(jButton);
        }
        if ((n & 2) > 0) {
            jButton = new JButton();
            jButton.addMouseListener(new ScrollViewPortMouseListener(2));
            jButton.setPreferredSize(new Dimension(10, 10));
            jButton.setIcon(ImageProvider.get("svpDown"));
            this.add((Component)jButton, "South");
            this.buttons.add(jButton);
        }
        if ((n & 4) > 0) {
            jButton = new JButton();
            jButton.addMouseListener(new ScrollViewPortMouseListener(4));
            jButton.setPreferredSize(new Dimension(10, 10));
            jButton.setIcon(ImageProvider.get("svpLeft"));
            this.add((Component)jButton, "West");
            this.buttons.add(jButton);
        }
        if ((n & 8) > 0) {
            jButton = new JButton();
            jButton.addMouseListener(new ScrollViewPortMouseListener(8));
            jButton.setPreferredSize(new Dimension(10, 10));
            jButton.setIcon(ImageProvider.get("svpRight"));
            this.add((Component)jButton, "East");
            this.buttons.add(jButton);
        }
        this.add((Component)this.vp, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ScrollViewport.this.showOrHideButtons();
            }
        });
        this.showOrHideButtons();
        this.timer.setRepeats(true);
        this.timer.setInitialDelay(400);
    }

    public synchronized void scroll() {
        int n = this.scrollDirection;
        if (this.component == null || n == 0) {
            return;
        }
        Rectangle rectangle = this.vp.getViewRect();
        int n2 = 0;
        int n3 = 0;
        if (n < 4) {
            n3 = rectangle.height * 2 / 7;
        } else {
            n2 = rectangle.width * 2 / 7;
        }
        switch (n) {
            case 1: {
                n3 *= -1;
                break;
            }
            case 4: {
                n2 *= -1;
            }
        }
        this.scroll(n2, n3);
    }

    public synchronized void scroll(int n, int n2) {
        if (this.component == null) {
            return;
        }
        Dimension dimension = this.component.getSize();
        Rectangle rectangle = this.vp.getViewRect();
        int n3 = rectangle.x + n;
        int n4 = rectangle.y + n2;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 > dimension.height - rectangle.height) {
            n4 = dimension.height - rectangle.height;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > dimension.width - rectangle.width) {
            n3 = dimension.width - rectangle.width;
        }
        this.vp.setViewPosition(new Point(n3, n4));
    }

    public void showOrHideButtons() {
        boolean bl = this.vp.getViewSize().height > this.vp.getViewRect().height || this.vp.getViewSize().width > this.vp.getViewRect().width;
        for (JButton jButton : this.buttons) {
            jButton.setVisible(bl);
        }
    }

    public Rectangle getViewRect() {
        return this.vp.getViewRect();
    }

    public Dimension getViewSize() {
        return this.vp.getViewSize();
    }

    public Point getViewPosition() {
        return this.vp.getViewPosition();
    }

    public void add(JComponent jComponent) {
        this.vp.removeAll();
        this.component = jComponent;
        this.vp.add(jComponent);
    }

    private class ScrollViewPortMouseListener
    extends MouseAdapter {
        private int direction;

        public ScrollViewPortMouseListener(int n) {
            this.direction = n;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ScrollViewport.this.scrollDirection = 0;
            ScrollViewport.this.timer.stop();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ScrollViewport.this.scrollDirection = 0;
            ScrollViewport.this.timer.stop();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ScrollViewport.this.scrollDirection = this.direction;
            ScrollViewport.this.scroll();
            ScrollViewport.this.timer.restart();
        }
    }
}

