/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.ImageProvider;

public class OsmPrimitivRenderer
implements ListCellRenderer<OsmPrimitive>,
TableCellRenderer {
    private DefaultNameFormatter formatter = DefaultNameFormatter.getInstance();
    private DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
    private DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();

    @Override
    public Component getListCellRendererComponent(JList<? extends OsmPrimitive> jList, OsmPrimitive osmPrimitive, int n, boolean bl, boolean bl2) {
        Component component = this.defaultListCellRenderer.getListCellRendererComponent(jList, osmPrimitive, n, bl, bl2);
        return this.renderer(component, osmPrimitive);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = this.defaultTableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object instanceof OsmPrimitive) {
            return this.renderer(component, (OsmPrimitive)object);
        }
        if (object instanceof HistoryOsmPrimitive) {
            return this.renderer(component, (HistoryOsmPrimitive)object);
        }
        return component;
    }

    private Component renderer(Component component, OsmPrimitive osmPrimitive) {
        if (osmPrimitive != null && component instanceof JLabel) {
            ((JLabel)component).setText(this.getComponentText(osmPrimitive));
            ImageIcon imageIcon = ImageProvider.get(osmPrimitive.getDisplayType());
            if (imageIcon != null) {
                ((JLabel)component).setIcon(imageIcon);
            } else {
                Main.warn("Null icon for " + (Object)((Object)osmPrimitive.getDisplayType()));
            }
            ((JLabel)component).setToolTipText(this.getComponentToolTipText(osmPrimitive));
        }
        return component;
    }

    private Component renderer(Component component, HistoryOsmPrimitive historyOsmPrimitive) {
        if (historyOsmPrimitive != null && component instanceof JLabel) {
            ((JLabel)component).setText(historyOsmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
            ((JLabel)component).setIcon(ImageProvider.get(historyOsmPrimitive.getType()));
            ((JLabel)component).setToolTipText(this.formatter.buildDefaultToolTip(historyOsmPrimitive));
        }
        return component;
    }

    protected String getComponentText(OsmPrimitive osmPrimitive) {
        return osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance());
    }

    protected String getComponentToolTipText(OsmPrimitive osmPrimitive) {
        return this.formatter.buildDefaultToolTip(osmPrimitive);
    }
}

