/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class FilterMatcher {
    private final List<FilterInfo> hiddenFilters = new ArrayList<FilterInfo>();
    private final List<FilterInfo> disabledFilters = new ArrayList<FilterInfo>();

    public void update(Collection<Filter> collection) throws SearchCompiler.ParseError {
        this.hiddenFilters.clear();
        this.disabledFilters.clear();
        for (Filter filter : collection) {
            if (!filter.enable) continue;
            FilterInfo filterInfo = new FilterInfo(filter);
            if (filterInfo.isDelete) {
                if (filter.hiding) {
                    this.hiddenFilters.add(filterInfo);
                    continue;
                }
                this.disabledFilters.add(filterInfo);
                this.hiddenFilters.add(filterInfo);
                continue;
            }
            if (filter.mode == SearchAction.SearchMode.replace && filter.hiding) {
                this.hiddenFilters.clear();
                this.disabledFilters.clear();
            }
            this.disabledFilters.add(filterInfo);
            if (!filter.hiding) continue;
            this.hiddenFilters.add(filterInfo);
        }
    }

    private boolean isFiltered(OsmPrimitive osmPrimitive, boolean bl) {
        return bl ? osmPrimitive.isDisabledAndHidden() : osmPrimitive.isDisabled();
    }

    private boolean isFilterExplicit(OsmPrimitive osmPrimitive, boolean bl) {
        return bl ? osmPrimitive.getHiddenType() : osmPrimitive.getDisabledType();
    }

    private boolean allParentWaysFiltered(OsmPrimitive osmPrimitive, boolean bl) {
        List<OsmPrimitive> list = osmPrimitive.getReferrers();
        boolean bl2 = false;
        for (OsmPrimitive osmPrimitive2 : list) {
            if (!(osmPrimitive2 instanceof Way)) continue;
            if (!this.isFiltered(osmPrimitive2, bl)) {
                return false;
            }
            bl2 |= this.isFilterExplicit(osmPrimitive2, bl);
        }
        return bl2;
    }

    private boolean oneParentWayNotFiltered(OsmPrimitive osmPrimitive, boolean bl) {
        List<OsmPrimitive> list = osmPrimitive.getReferrers();
        for (OsmPrimitive osmPrimitive2 : list) {
            if (!(osmPrimitive2 instanceof Way) || this.isFiltered(osmPrimitive2, bl)) continue;
            return true;
        }
        return false;
    }

    private boolean allParentMultipolygonsFiltered(OsmPrimitive osmPrimitive, boolean bl) {
        boolean bl2 = false;
        for (Relation relation : new SubclassFilteredCollection(osmPrimitive.getReferrers(), OsmPrimitive.multipolygonPredicate)) {
            if (!this.isFiltered(relation, bl)) {
                return false;
            }
            bl2 |= this.isFilterExplicit(relation, bl);
        }
        return bl2;
    }

    private boolean oneParentMultipolygonNotFiltered(OsmPrimitive osmPrimitive, boolean bl) {
        for (Relation relation : new SubclassFilteredCollection(osmPrimitive.getReferrers(), OsmPrimitive.multipolygonPredicate)) {
            if (this.isFiltered(relation, bl)) continue;
            return true;
        }
        return false;
    }

    private FilterType test(List<FilterInfo> list, OsmPrimitive osmPrimitive, boolean bl) {
        if (osmPrimitive.isIncomplete()) {
            return FilterType.NOT_FILTERED;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (FilterInfo filterInfo : list) {
            if (filterInfo.isDelete) {
                if (!bl2 || !filterInfo.match.match(osmPrimitive)) continue;
                bl2 = false;
                continue;
            }
            if (bl2 && (bl3 || filterInfo.isInverted) || !filterInfo.match.match(osmPrimitive)) continue;
            bl2 = true;
            if (filterInfo.isInverted) continue;
            bl3 = true;
        }
        if (osmPrimitive instanceof Node) {
            if (bl2) {
                if (bl3) {
                    return FilterType.PASSIV;
                }
                if (this.oneParentWayNotFiltered(osmPrimitive, bl)) {
                    return FilterType.NOT_FILTERED;
                }
                return FilterType.PASSIV;
            }
            if (!osmPrimitive.isTagged() && this.allParentWaysFiltered(osmPrimitive, bl)) {
                return FilterType.PASSIV;
            }
            return FilterType.NOT_FILTERED;
        }
        if (osmPrimitive instanceof Way) {
            if (bl2) {
                if (bl3) {
                    return FilterType.EXPLICIT;
                }
                if (this.oneParentMultipolygonNotFiltered(osmPrimitive, bl)) {
                    return FilterType.NOT_FILTERED;
                }
                return FilterType.PASSIV;
            }
            if (!osmPrimitive.isTagged() && this.allParentMultipolygonsFiltered(osmPrimitive, bl)) {
                return FilterType.EXPLICIT;
            }
            return FilterType.NOT_FILTERED;
        }
        if (bl2) {
            return bl3 ? FilterType.EXPLICIT : FilterType.PASSIV;
        }
        return FilterType.NOT_FILTERED;
    }

    public FilterType isHidden(OsmPrimitive osmPrimitive) {
        return this.test(this.hiddenFilters, osmPrimitive, true);
    }

    public FilterType isDisabled(OsmPrimitive osmPrimitive) {
        return this.test(this.disabledFilters, osmPrimitive, false);
    }

    private static class FilterInfo {
        private final SearchCompiler.Match match;
        private final boolean isDelete;
        private final boolean isInverted;

        FilterInfo(Filter filter) throws SearchCompiler.ParseError {
            this.isDelete = filter.mode == SearchAction.SearchMode.remove || filter.mode == SearchAction.SearchMode.in_selection;
            SearchCompiler.Match match = SearchCompiler.compile(filter.text, filter.caseSensitive, filter.regexSearch);
            this.match = filter.inverted ? new SearchCompiler.Not(match) : match;
            this.isInverted = filter.inverted;
        }
    }

    public static enum FilterType {
        NOT_FILTERED,
        EXPLICIT,
        PASSIV;

    }
}

