/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderJob;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.data.preferences.IntegerProperty;

public abstract class JCSCachedTileLoaderJob<K, V extends CacheEntry>
implements ICachedLoaderJob<K>,
Runnable {
    private static final Logger log = FeatureAdapter.getLogger(JCSCachedTileLoaderJob.class.getCanonicalName());
    protected static final long DEFAULT_EXPIRE_TIME = 604800000L;
    protected static final long EXPIRE_TIME_SERVER_LIMIT = 2419200000L;
    protected static final long ABSOLUTE_EXPIRE_TIME_LIMIT = Long.MAX_VALUE;
    public static final IntegerProperty THREAD_LIMIT = new IntegerProperty("cache.jcs.max_threads", 10);
    private static Executor DOWNLOAD_JOB_DISPATCHER = new ThreadPoolExecutor(2, THREAD_LIMIT.get(), 30L, TimeUnit.SECONDS, new LIFOQueue(5));
    private static ConcurrentMap<String, Set<ICachedLoaderListener>> inProgress = new ConcurrentHashMap<String, Set<ICachedLoaderListener>>();
    private static ConcurrentMap<String, Boolean> useHead = new ConcurrentHashMap<String, Boolean>();
    private long now;
    private ICacheAccess<K, V> cache;
    private ICacheElement<K, V> cacheElement;
    protected V cacheData = null;
    protected CacheEntryAttributes attributes = null;
    private int connectTimeout;
    private int readTimeout;
    private Map<String, String> headers;

    public JCSCachedTileLoaderJob(ICacheAccess<K, V> iCacheAccess, int n, int n2, Map<String, String> map) {
        this.cache = iCacheAccess;
        this.now = System.currentTimeMillis();
        this.connectTimeout = n;
        this.readTimeout = n2;
        this.headers = map;
    }

    private void ensureCacheElement() {
        if (this.cacheElement == null && this.getCacheKey() != null) {
            this.cacheElement = this.cache.getCacheElement(this.getCacheKey());
            if (this.cacheElement != null) {
                this.attributes = (CacheEntryAttributes)this.cacheElement.getElementAttributes();
                this.cacheData = (CacheEntry)this.cacheElement.getVal();
            }
        }
    }

    public V get() {
        this.ensureCacheElement();
        return this.cacheData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(ICachedLoaderListener iCachedLoaderListener) {
        boolean bl = false;
        URL uRL = this.getUrl();
        String string = null;
        if (uRL != null) {
            string = uRL.toString();
        }
        if (string == null) {
            log.log(Level.WARNING, "No url returned for: {0}, skipping", this.getCacheKey());
            return;
        }
        ConcurrentMap<String, Set<ICachedLoaderListener>> concurrentMap = inProgress;
        synchronized (concurrentMap) {
            HashSet<ICachedLoaderListener> hashSet = (HashSet<ICachedLoaderListener>)inProgress.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<ICachedLoaderListener>();
                inProgress.put(string, hashSet);
                bl = true;
            }
            hashSet.add(iCachedLoaderListener);
        }
        if (bl) {
            this.ensureCacheElement();
            if (this.cacheElement != null && this.isCacheElementValid() && this.isObjectLoadable()) {
                log.log(Level.FINE, "JCS - Returning object from cache: {0}", this.getCacheKey());
                this.finishLoading(ICachedLoaderListener.LoadResult.SUCCESS);
                return;
            }
            try {
                if (this.executionGuard()) {
                    this.getDownloadExecutor().execute(this);
                } else {
                    log.log(Level.FINE, "JCS - guard rejected job for: {0}", this.getCacheKey());
                    this.finishLoading(ICachedLoaderListener.LoadResult.REJECTED);
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                log.log(Level.FINE, "JCS - rejected job for: {0}", this.getCacheKey());
                this.finishLoading(ICachedLoaderListener.LoadResult.REJECTED);
            }
        }
    }

    protected boolean executionGuard() {
        return true;
    }

    protected void executionFinished() {
    }

    protected boolean isObjectLoadable() {
        byte[] byArray = ((CacheEntry)this.cacheData).getContent();
        return byArray != null && byArray.length > 0;
    }

    protected boolean cacheAsEmpty() {
        return false;
    }

    protected String getServerKey() {
        return this.getUrl().getHost();
    }

    protected Executor getDownloadExecutor() {
        return DOWNLOAD_JOB_DISPATCHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        String string = thread.getName();
        thread.setName("JCS Downloading: " + this.getUrl());
        try {
            if (this.loadObject()) {
                this.finishLoading(ICachedLoaderListener.LoadResult.SUCCESS);
            } else if (this.isObjectLoadable()) {
                this.finishLoading(ICachedLoaderListener.LoadResult.SUCCESS);
                log.log(Level.FINE, "JCS - found stale object in cache: {0}", this.getUrl());
            } else {
                this.finishLoading(ICachedLoaderListener.LoadResult.FAILURE);
            }
        }
        finally {
            this.executionFinished();
            thread.setName(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishLoading(ICachedLoaderListener.LoadResult loadResult) {
        Set set = null;
        ConcurrentMap<String, Set<ICachedLoaderListener>> concurrentMap = inProgress;
        synchronized (concurrentMap) {
            set = (Set)inProgress.remove(this.getUrl().toString());
        }
        if (set == null) {
            log.log(Level.WARNING, "Listener not found for URL: {0}. Listener not notified!", this.getUrl());
            return;
        }
        try {
            for (ICachedLoaderListener iCachedLoaderListener : set) {
                iCachedLoaderListener.loadingFinished((CacheEntry)this.cacheData, loadResult);
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "JCS - Error while loading object from cache: {0}; {1}", new Object[]{exception.getMessage(), this.getUrl()});
            Main.warn(exception);
            for (ICachedLoaderListener iCachedLoaderListener : set) {
                iCachedLoaderListener.loadingFinished((CacheEntry)this.cacheData, ICachedLoaderListener.LoadResult.FAILURE);
            }
        }
    }

    private boolean isCacheElementValid() {
        long l = this.attributes.getExpirationTime();
        if (l != 0L) {
            if (this.now > (l = Math.min(l, this.attributes.getCreateTime() + 2419200000L))) {
                log.log(Level.FINE, "JCS - Object {0} has expired -> valid to {1}, now is: {2}", new Object[]{this.getUrl(), Long.toString(l), Long.toString(this.now)});
                return false;
            }
        } else if (this.now - this.attributes.getLastModification() > 604800000L) {
            log.log(Level.FINE, "JCS - Object has expired, maximum file age reached {0}", this.getUrl());
            return false;
        }
        return true;
    }

    private boolean loadObject() {
        try {
            if (this.isObjectLoadable() && Boolean.TRUE.equals(useHead.get(this.getServerKey())) && this.isCacheValidUsingHead()) {
                log.log(Level.FINE, "JCS - cache entry verified using HEAD request: {0}", this.getUrl());
                return true;
            }
            HttpURLConnection httpURLConnection = this.getURLConnection();
            if (this.isObjectLoadable() && this.now - this.attributes.getLastModification() <= Long.MAX_VALUE) {
                httpURLConnection.setIfModifiedSince(this.attributes.getLastModification());
            }
            if (this.isObjectLoadable() && this.attributes.getEtag() != null) {
                httpURLConnection.addRequestProperty("If-None-Match", this.attributes.getEtag());
            }
            if (httpURLConnection instanceof HttpURLConnection && httpURLConnection.getResponseCode() == 304) {
                log.log(Level.FINE, "JCS - IfModifiedSince/Etag test: local version is up to date: {0}", this.getUrl());
                return true;
            }
            if (this.isObjectLoadable() && (this.attributes.getEtag() != null && this.attributes.getEtag().equals(httpURLConnection.getRequestProperty("ETag")) || this.attributes.getLastModification() == httpURLConnection.getLastModified())) {
                String string = this.getServerKey();
                log.log(Level.INFO, "JCS - Host: {0} found not to return 304 codes for If-Modifed-Since or If-None-Match headers", string);
                useHead.put(string, Boolean.TRUE);
            }
            this.attributes = this.parseHeaders(httpURLConnection);
            for (int i = 0; i < 5; ++i) {
                if (!(httpURLConnection instanceof HttpURLConnection) || httpURLConnection.getResponseCode() != 503) {
                    byte[] byArray = JCSCachedTileLoaderJob.read(httpURLConnection);
                    if (!this.cacheAsEmpty() && byArray != null && byArray.length > 0) {
                        this.cacheData = this.createCacheEntry(byArray);
                        this.cache.put(this.getCacheKey(), this.cacheData, this.attributes);
                        log.log(Level.FINE, "JCS - downloaded key: {0}, length: {1}, url: {2}", new Object[]{this.getCacheKey(), byArray.length, this.getUrl()});
                        return true;
                    }
                    this.cacheData = this.createCacheEntry(new byte[0]);
                    this.cache.put(this.getCacheKey(), this.cacheData, this.attributes);
                    log.log(Level.FINE, "JCS - Caching empty object {0}", this.getUrl());
                    return true;
                }
                Thread.sleep(5000 + new Random().nextInt(5000));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.log(Level.FINE, "JCS - Caching empty object as server returned 404 for: {0}", this.getUrl());
            this.cache.put(this.getCacheKey(), this.createCacheEntry(new byte[0]), this.attributes);
            return this.handleNotFound();
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "JCS - Exception during download {0}", this.getUrl());
            Main.warn(exception);
        }
        log.log(Level.WARNING, "JCS - Silent failure during download: {0}", this.getUrl());
        return false;
    }

    protected abstract boolean handleNotFound();

    protected abstract V createCacheEntry(byte[] var1);

    private CacheEntryAttributes parseHeaders(URLConnection uRLConnection) {
        CacheEntryAttributes cacheEntryAttributes = new CacheEntryAttributes();
        cacheEntryAttributes.setNoTileAtZoom("no-tile".equals(uRLConnection.getHeaderField("X-VE-Tile-Info")));
        Long l = uRLConnection.getExpiration();
        if (l.equals(0L)) {
            try {
                String string = uRLConnection.getHeaderField("Cache-Control");
                if (string != null) {
                    for (String string2 : string.split(",")) {
                        if (!string2.startsWith("max-age=")) continue;
                        l = Long.parseLong(string2.substring(8)) * 1000L + System.currentTimeMillis();
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        cacheEntryAttributes.setExpirationTime(l);
        cacheEntryAttributes.setLastModification(this.now);
        cacheEntryAttributes.setEtag(uRLConnection.getHeaderField("ETag"));
        return cacheEntryAttributes;
    }

    private HttpURLConnection getURLConnection() throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)this.getUrl().openConnection();
        httpURLConnection.setRequestProperty("Accept", "text/html, image/png, image/jpeg, image/gif, */*");
        httpURLConnection.setReadTimeout(this.readTimeout);
        httpURLConnection.setConnectTimeout(this.connectTimeout);
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        return httpURLConnection;
    }

    private boolean isCacheValidUsingHead() throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)this.getUrl().openConnection();
        httpURLConnection.setRequestMethod("HEAD");
        long l = httpURLConnection.getLastModified();
        return this.attributes.getEtag() != null && this.attributes.getEtag().equals(httpURLConnection.getRequestProperty("ETag")) || l != 0L && l <= this.attributes.getLastModification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] read(URLConnection uRLConnection) throws IOException {
        try (InputStream inputStream = uRLConnection.getInputStream();){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
            byte[] byArray = new byte[2048];
            boolean bl = false;
            do {
                int n;
                if ((n = inputStream.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                    continue;
                }
                bl = true;
            } while (!bl);
            if (byteArrayOutputStream.size() == 0) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            return byArray3;
        }
    }

    public static class LIFOQueue
    extends LinkedBlockingDeque<Runnable> {
        public LIFOQueue(int n) {
            super(n);
        }

        @Override
        public boolean offer(Runnable runnable) {
            return super.offerFirst(runnable);
        }

        @Override
        public Runnable remove() {
            return (Runnable)super.removeFirst();
        }
    }
}

