/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheFactory;
import org.apache.commons.jcs.engine.CompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.preferences.IntegerProperty;

public class JCSCacheManager {
    private static final Logger log = FeatureAdapter.getLogger(JCSCacheManager.class.getCanonicalName());
    private static volatile CompositeCacheManager cacheManager = null;
    private static long maxObjectTTL = Long.MAX_VALUE;
    private static final String PREFERENCE_PREFIX = "jcs.cache";
    private static final IndexedDiskCacheFactory diskCacheFactory = new IndexedDiskCacheFactory();
    private static FileLock cacheDirLock = null;
    public static final IntegerProperty DEFAULT_MAX_OBJECTS_IN_MEMORY = new IntegerProperty("jcs.cache.max_objects_in_memory", 1000);

    private static void initialize() throws IOException {
        File file = new File(Main.pref.getCacheDirectory(), "jcs");
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Cannot access cache directory");
        }
        File file2 = new File(file, ".lock");
        if (!file2.exists()) {
            file2.createNewFile();
        }
        if ((cacheDirLock = new FileOutputStream(file2).getChannel().tryLock()) == null) {
            log.log(Level.WARNING, "Cannot lock cache directory. Will not use disk cache");
        }
        Logger logger = Logger.getLogger("org.apache.commons.jcs");
        logger.setLevel(Level.INFO);
        logger.setUseParentHandlers(false);
        logger.addHandler(new Handler(){

            @Override
            public void publish(LogRecord logRecord) {
                String string = MessageFormat.format(logRecord.getMessage(), logRecord.getParameters());
                if (logRecord.getLevel().intValue() >= Level.SEVERE.intValue()) {
                    Main.error(string);
                } else if (logRecord.getLevel().intValue() >= Level.WARNING.intValue()) {
                    Main.warn(string);
                } else if (logRecord.getLevel().intValue() >= Level.INFO.intValue()) {
                    Main.debug(string);
                } else {
                    Main.trace(string);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        });
        CompositeCacheManager compositeCacheManager = CompositeCacheManager.getUnconfiguredInstance();
        Properties properties = new Properties();
        properties.setProperty("jcs.default.cacheattributes", CompositeCacheAttributes.class.getCanonicalName());
        properties.setProperty("jcs.default.cacheattributes.MaxObjects", DEFAULT_MAX_OBJECTS_IN_MEMORY.get().toString());
        properties.setProperty("jcs.default.cacheattributes.UseMemoryShrinker", "true");
        properties.setProperty("jcs.default.cacheattributes.DiskUsagePatternName", "UPDATE");
        properties.setProperty("jcs.default.elementattributes", CacheEntryAttributes.class.getCanonicalName());
        properties.setProperty("jcs.default.elementattributes.IsEternal", "false");
        properties.setProperty("jcs.default.elementattributes.MaxLife", Long.toString(maxObjectTTL));
        properties.setProperty("jcs.default.elementattributes.IdleTime", Long.toString(maxObjectTTL));
        properties.setProperty("jcs.default.elementattributes.IsSpool", "true");
        compositeCacheManager.configure(properties);
        cacheManager = compositeCacheManager;
    }

    public static <K, V> CacheAccess<K, V> getCache(String string) throws IOException {
        return JCSCacheManager.getCache(string, DEFAULT_MAX_OBJECTS_IN_MEMORY.get(), 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> CacheAccess<K, V> getCache(String string, int n, int n2, String string2) throws IOException {
        if (cacheManager != null) {
            return JCSCacheManager.getCacheInner(string, n, n2, string2);
        }
        Class<JCSCacheManager> clazz = JCSCacheManager.class;
        synchronized (JCSCacheManager.class) {
            if (cacheManager == null) {
                JCSCacheManager.initialize();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return JCSCacheManager.getCacheInner(string, n, n2, string2);
        }
    }

    private static <K, V> CacheAccess<K, V> getCacheInner(String string, int n, int n2, String string2) {
        CompositeCache compositeCache = cacheManager.getCache(string, JCSCacheManager.getCacheAttributes(n));
        if (string2 != null && cacheDirLock != null) {
            IndexedDiskCacheAttributes indexedDiskCacheAttributes = JCSCacheManager.getDiskCacheAttributes(n2, string2);
            indexedDiskCacheAttributes.setCacheName(string);
            AuxiliaryCache auxiliaryCache = diskCacheFactory.createCache(indexedDiskCacheAttributes, cacheManager, null, new StandardSerializer());
            compositeCache.setAuxCaches(new AuxiliaryCache[]{auxiliaryCache});
        }
        return new CacheAccess(compositeCache);
    }

    public static void shutdown() {
        CompositeCacheManager compositeCacheManager = cacheManager;
        if (compositeCacheManager != null) {
            compositeCacheManager.shutDown();
        }
    }

    private static IndexedDiskCacheAttributes getDiskCacheAttributes(int n, String string) {
        IndexedDiskCacheAttributes indexedDiskCacheAttributes = new IndexedDiskCacheAttributes();
        indexedDiskCacheAttributes.setMaxKeySize(n);
        if (string != null) {
            File file = new File(string);
            if (!file.exists() && !file.mkdirs()) {
                log.log(Level.WARNING, "Failed to create cache path: {0}", string);
            } else {
                indexedDiskCacheAttributes.setDiskPath(file);
            }
        }
        return indexedDiskCacheAttributes;
    }

    private static CompositeCacheAttributes getCacheAttributes(int n) {
        CompositeCacheAttributes compositeCacheAttributes = new CompositeCacheAttributes();
        compositeCacheAttributes.setMaxObjects(n);
        compositeCacheAttributes.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.UPDATE);
        return compositeCacheAttributes;
    }
}

