/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jcs.engine.ElementAttributes;

public class CacheEntryAttributes
extends ElementAttributes {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> attrs = new HashMap<String, String>();
    private static final String NO_TILE_AT_ZOOM = "noTileAtZoom";
    private static final String ETAG = "Etag";
    private static final String LAST_MODIFICATION = "lastModification";
    private static final String EXPIRATION_TIME = "expirationTime";

    public CacheEntryAttributes() {
        this.attrs.put(NO_TILE_AT_ZOOM, "false");
        this.attrs.put(ETAG, null);
        this.attrs.put(LAST_MODIFICATION, "0");
        this.attrs.put(EXPIRATION_TIME, "0");
    }

    public boolean isNoTileAtZoom() {
        return Boolean.toString(true).equals(this.attrs.get(NO_TILE_AT_ZOOM));
    }

    public void setNoTileAtZoom(boolean bl) {
        this.attrs.put(NO_TILE_AT_ZOOM, Boolean.toString(bl));
    }

    public String getEtag() {
        return this.attrs.get(ETAG);
    }

    public void setEtag(String string) {
        this.attrs.put(ETAG, string);
    }

    private long getLongAttr(String string) {
        try {
            return Long.parseLong(this.attrs.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            this.attrs.put(string, "0");
            return 0L;
        }
    }

    public long getLastModification() {
        return this.getLongAttr(LAST_MODIFICATION);
    }

    public void setLastModification(long l) {
        this.attrs.put(LAST_MODIFICATION, Long.toString(l));
    }

    public long getExpirationTime() {
        return this.getLongAttr(EXPIRATION_TIME);
    }

    public void setExpirationTime(long l) {
        this.attrs.put(EXPIRATION_TIME, Long.toString(l));
    }
}

