/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.cache.CacheEntry;

public class BufferedImageCacheEntry
extends CacheEntry {
    private static final long serialVersionUID = 1L;
    private volatile transient BufferedImage img = null;
    private volatile transient boolean writtenToDisk = false;

    public BufferedImageCacheEntry(byte[] byArray) {
        super(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() throws IOException {
        if (this.img != null) {
            return this.img;
        }
        BufferedImageCacheEntry bufferedImageCacheEntry = this;
        synchronized (bufferedImageCacheEntry) {
            if (this.img != null) {
                return this.img;
            }
            byte[] byArray = this.getContent();
            if (byArray != null) {
                this.img = ImageIO.read(new ByteArrayInputStream(byArray));
                if (this.writtenToDisk) {
                    byArray = null;
                }
            }
        }
        return this.img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        BufferedImageCacheEntry bufferedImageCacheEntry = this;
        synchronized (bufferedImageCacheEntry) {
            if (this.content == null && this.img != null) {
                throw new AssertionError((Object)"Trying to serialize (save to disk?) an BufferedImageCacheEntry that was converted to BufferedImage and no raw data is present anymore");
            }
            objectOutputStream.writeObject(this);
            this.writtenToDisk = true;
            if (this.img != null) {
                this.content = null;
            }
        }
    }
}

