/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class Bounds {
    private double minLat;
    private double minLon;
    private double maxLat;
    private double maxLon;

    public LatLon getMin() {
        return new LatLon(this.minLat, this.minLon);
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public LatLon getMax() {
        return new LatLon(this.maxLat, this.maxLon);
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public Bounds(LatLon latLon, LatLon latLon2) {
        this(latLon.lat(), latLon.lon(), latLon2.lat(), latLon2.lon());
    }

    public Bounds(LatLon latLon, LatLon latLon2, boolean bl) {
        this(latLon.lat(), latLon.lon(), latLon2.lat(), latLon2.lon(), bl);
    }

    public Bounds(LatLon latLon) {
        this(latLon, true);
    }

    public Bounds(LatLon latLon, boolean bl) {
        this(latLon.lat(), latLon.lon(), bl);
    }

    public Bounds(double d, double d2, boolean bl) {
        if (bl) {
            this.minLat = LatLon.roundToOsmPrecision(d);
            this.minLon = LatLon.roundToOsmPrecision(d2);
        } else {
            this.minLat = d;
            this.minLon = d2;
        }
        this.maxLat = this.minLat;
        this.maxLon = this.minLon;
    }

    public Bounds(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, true);
    }

    public Bounds(double d, double d2, double d3, double d4, boolean bl) {
        if (bl) {
            this.minLat = LatLon.roundToOsmPrecision(d);
            this.minLon = LatLon.roundToOsmPrecision(d2);
            this.maxLat = LatLon.roundToOsmPrecision(d3);
            this.maxLon = LatLon.roundToOsmPrecision(d4);
        } else {
            this.minLat = d;
            this.minLon = d2;
            this.maxLat = d3;
            this.maxLon = d4;
        }
    }

    public Bounds(double[] dArray) {
        this(dArray, true);
    }

    public Bounds(double[] dArray, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(dArray, "coords");
        if (dArray.length != 4) {
            throw new IllegalArgumentException(MessageFormat.format("Expected array of length 4, got {0}", dArray.length));
        }
        if (bl) {
            this.minLat = LatLon.roundToOsmPrecision(dArray[0]);
            this.minLon = LatLon.roundToOsmPrecision(dArray[1]);
            this.maxLat = LatLon.roundToOsmPrecision(dArray[2]);
            this.maxLon = LatLon.roundToOsmPrecision(dArray[3]);
        } else {
            this.minLat = dArray[0];
            this.minLon = dArray[1];
            this.maxLat = dArray[2];
            this.maxLon = dArray[3];
        }
    }

    public Bounds(String string, String string2) {
        this(string, string2, ParseMethod.MINLAT_MINLON_MAXLAT_MAXLON);
    }

    public Bounds(String string, String string2, ParseMethod parseMethod) {
        this(string, string2, parseMethod, true);
    }

    public Bounds(String string, String string2, ParseMethod parseMethod, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(string, "asString");
        String[] stringArray = string.split(string2);
        if (stringArray.length != 4) {
            throw new IllegalArgumentException(MessageFormat.format("Exactly four doubles expected in string, got {0}: {1}", stringArray.length, string));
        }
        double[] dArray = new double[4];
        for (int i = 0; i < 4; ++i) {
            try {
                dArray[i] = Double.parseDouble(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(MessageFormat.format("Illegal double value ''{0}''", stringArray[i]), numberFormatException);
            }
        }
        switch (parseMethod) {
            case LEFT_BOTTOM_RIGHT_TOP: {
                this.minLat = Bounds.initLat(dArray[1], bl);
                this.minLon = Bounds.initLon(dArray[0], bl);
                this.maxLat = Bounds.initLat(dArray[3], bl);
                this.maxLon = Bounds.initLon(dArray[2], bl);
                break;
            }
            default: {
                this.minLat = Bounds.initLat(dArray[0], bl);
                this.minLon = Bounds.initLon(dArray[1], bl);
                this.maxLat = Bounds.initLat(dArray[2], bl);
                this.maxLon = Bounds.initLon(dArray[3], bl);
            }
        }
    }

    protected static double initLat(double d, boolean bl) {
        if (!LatLon.isValidLat(d)) {
            throw new IllegalArgumentException(I18n.tr("Illegal latitude value ''{0}''", d));
        }
        return bl ? LatLon.roundToOsmPrecision(d) : d;
    }

    protected static double initLon(double d, boolean bl) {
        if (!LatLon.isValidLon(d)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value ''{0}''", d));
        }
        return bl ? LatLon.roundToOsmPrecision(d) : d;
    }

    public Bounds(Bounds bounds) {
        this(bounds.minLat, bounds.minLon, bounds.maxLat, bounds.maxLon);
    }

    public Bounds(Rectangle2D rectangle2D) {
        this(rectangle2D.getMinY(), rectangle2D.getMinX(), rectangle2D.getMaxY(), rectangle2D.getMaxX());
    }

    public Bounds(LatLon latLon, double d, double d2) {
        CheckParameterUtil.ensureParameterNotNull(latLon, "center");
        if (d <= 0.0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0.0 expected, got {1}", "latExtent", d));
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0.0 expected, got {1}", "lonExtent", d2));
        }
        this.minLat = LatLon.roundToOsmPrecision(LatLon.toIntervalLat(latLon.lat() - d / 2.0));
        this.minLon = LatLon.roundToOsmPrecision(LatLon.toIntervalLon(latLon.lon() - d2 / 2.0));
        this.maxLat = LatLon.roundToOsmPrecision(LatLon.toIntervalLat(latLon.lat() + d / 2.0));
        this.maxLon = LatLon.roundToOsmPrecision(LatLon.toIntervalLon(latLon.lon() + d2 / 2.0));
    }

    public BBox toBBox() {
        return new BBox(this.minLon, this.minLat, this.maxLon, this.maxLat);
    }

    public String toString() {
        return "Bounds[" + this.minLat + "," + this.minLon + "," + this.maxLat + "," + this.maxLon + "]";
    }

    public String toShortString(DecimalFormat decimalFormat) {
        return decimalFormat.format(this.minLat) + " " + decimalFormat.format(this.minLon) + " / " + decimalFormat.format(this.maxLat) + " " + decimalFormat.format(this.maxLon);
    }

    public LatLon getCenter() {
        if (this.crosses180thMeridian()) {
            double d = (this.minLat + this.maxLat) / 2.0;
            double d2 = (this.minLon + this.maxLon - 360.0) / 2.0;
            if (d2 < -180.0) {
                d2 += 360.0;
            }
            return new LatLon(d, d2);
        }
        return new LatLon((this.minLat + this.maxLat) / 2.0, (this.minLon + this.maxLon) / 2.0);
    }

    public void extend(LatLon latLon) {
        this.extend(latLon.lat(), latLon.lon());
    }

    public void extend(double d, double d2) {
        if (d < this.minLat) {
            this.minLat = LatLon.roundToOsmPrecision(d);
        }
        if (d > this.maxLat) {
            this.maxLat = LatLon.roundToOsmPrecision(d);
        }
        if (this.crosses180thMeridian()) {
            if (d2 > this.maxLon && d2 < this.minLon) {
                if (Math.abs(d2 - this.minLon) <= Math.abs(d2 - this.maxLon)) {
                    this.minLon = LatLon.roundToOsmPrecision(d2);
                } else {
                    this.maxLon = LatLon.roundToOsmPrecision(d2);
                }
            }
        } else {
            if (d2 < this.minLon) {
                this.minLon = LatLon.roundToOsmPrecision(d2);
            }
            if (d2 > this.maxLon) {
                this.maxLon = LatLon.roundToOsmPrecision(d2);
            }
        }
    }

    public void extend(Bounds bounds) {
        this.extend(bounds.minLat, bounds.minLon);
        this.extend(bounds.maxLat, bounds.maxLon);
    }

    public boolean contains(LatLon latLon) {
        if (latLon.lat() < this.minLat || latLon.lat() > this.maxLat) {
            return false;
        }
        return !(this.crosses180thMeridian() ? latLon.lon() > this.maxLon && latLon.lon() < this.minLon : latLon.lon() < this.minLon || latLon.lon() > this.maxLon);
    }

    private static boolean intersectsLonCrossing(Bounds bounds, Bounds bounds2) {
        return bounds2.minLon <= bounds.maxLon || bounds2.maxLon >= bounds.minLon;
    }

    public boolean intersects(Bounds bounds) {
        if (bounds.maxLat < this.minLat || bounds.minLat > this.maxLat) {
            return false;
        }
        if (this.crosses180thMeridian() && !bounds.crosses180thMeridian()) {
            return Bounds.intersectsLonCrossing(this, bounds);
        }
        if (!this.crosses180thMeridian() && bounds.crosses180thMeridian()) {
            return Bounds.intersectsLonCrossing(bounds, this);
        }
        if (this.crosses180thMeridian() && bounds.crosses180thMeridian()) {
            return true;
        }
        return bounds.maxLon >= this.minLon && bounds.minLon <= this.maxLon;
    }

    public boolean crosses180thMeridian() {
        return this.minLon > this.maxLon;
    }

    public Rectangle2D.Double asRect() {
        double d = this.maxLon - this.minLon + (this.crosses180thMeridian() ? 360.0 : 0.0);
        return new Rectangle2D.Double(this.minLon, this.minLat, d, this.maxLat - this.minLat);
    }

    public double getArea() {
        double d = this.maxLon - this.minLon + (this.crosses180thMeridian() ? 360.0 : 0.0);
        return d * (this.maxLat - this.minLat);
    }

    public String encodeAsString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.minLat).append(string).append(this.minLon).append(string).append(this.maxLat).append(string).append(this.maxLon);
        return stringBuilder.toString();
    }

    public boolean isCollapsed() {
        return Double.doubleToLongBits(this.minLat) == Double.doubleToLongBits(this.maxLat) && Double.doubleToLongBits(this.minLon) == Double.doubleToLongBits(this.maxLon);
    }

    public boolean isOutOfTheWorld() {
        return this.minLat < -90.0 || this.minLat > 90.0 || this.maxLat < -90.0 || this.maxLat > 90.0 || this.minLon < -180.0 || this.minLon > 180.0 || this.maxLon < -180.0 || this.maxLon > 180.0;
    }

    public void normalize() {
        this.minLat = LatLon.toIntervalLat(this.minLat);
        this.maxLat = LatLon.toIntervalLat(this.maxLat);
        this.minLon = LatLon.toIntervalLon(this.minLon);
        this.maxLon = LatLon.toIntervalLon(this.maxLon);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.maxLat);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.maxLon);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.minLat);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.minLon);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Bounds bounds = (Bounds)object;
        if (Double.doubleToLongBits(this.maxLat) != Double.doubleToLongBits(bounds.maxLat)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxLon) != Double.doubleToLongBits(bounds.maxLon)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minLat) != Double.doubleToLongBits(bounds.minLat)) {
            return false;
        }
        return Double.doubleToLongBits(this.minLon) == Double.doubleToLongBits(bounds.minLon);
    }

    public static enum ParseMethod {
        MINLAT_MINLON_MAXLAT_MAXLON,
        LEFT_BOTTOM_RIGHT_TOP;

    }
}

