/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class AbstractInfoAction
extends JosmAction {
    public AbstractInfoAction(boolean bl) {
        super(bl);
    }

    public AbstractInfoAction(String string, String string2, String string3, Shortcut shortcut, boolean bl, String string4, boolean bl2) {
        super(string, string2, string3, shortcut, bl, string4, bl2);
    }

    public static boolean confirmLaunchMultiple(int n) {
        String string = I18n.trn("You are about to launch {0} browser window.<br>This may both clutter your screen with browser windows<br>and take some time to finish.", "You are about to launch {0} browser windows.<br>This may both clutter your screen with browser windows<br>and take some time to finish.", n, n);
        string = "<html>" + string + "</html>";
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue", new Object[0]), ImageProvider.get("ok"), I18n.trn("Click to continue and to open {0} browser", "Click to continue and to open {0} browsers", n, n), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to abort launching external browsers", new Object[0]), null)};
        int n2 = HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Warning", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/WarningMessages#ToManyBrowsersToOpen"));
        return n2 == 0;
    }

    protected void launchInfoBrowsersForSelectedPrimitives() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(AbstractInfoAction.getCurrentDataSet().getAllSelected());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!((OsmPrimitive)iterator.next()).isNew()) continue;
            iterator.remove();
        }
        if (arrayList.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one already uploaded node, way, or relation.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        int n = Math.min(10, arrayList.size());
        if (arrayList.size() > n && !AbstractInfoAction.confirmLaunchMultiple(arrayList.size())) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            OpenBrowser.displayUrl(this.createInfoUrl(arrayList.get(i)));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.launchInfoBrowsersForSelectedPrimitives();
    }

    protected abstract String createInfoUrl(Object var1);

    @Override
    protected void updateEnabledState() {
        this.setEnabled(AbstractInfoAction.getCurrentDataSet() != null && !AbstractInfoAction.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

