/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.io.IOException;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTileSource;

public abstract class AbstractTMSTileSource
extends AbstractTileSource {
    protected String name;
    protected String baseUrl;
    protected String id;

    public AbstractTMSTileSource(String string, String string2, String string3) {
        this.name = string;
        this.baseUrl = string2;
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        this.id = string3;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getMaxZoom() {
        return 21;
    }

    @Override
    public int getMinZoom() {
        return 0;
    }

    public String getExtension() {
        return "png";
    }

    public String getTilePath(int n, int n2, int n3) throws IOException {
        return "/" + n + "/" + n2 + "/" + n3 + "." + this.getExtension();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getTileUrl(int n, int n2, int n3) throws IOException {
        return this.getBaseUrl() + this.getTilePath(n, n2, n3);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getTileType() {
        return "png";
    }

    @Override
    public int getTileSize() {
        return OsmMercator.TILE_SIZE;
    }

    @Override
    public double getDistance(double d, double d2, double d3, double d4) {
        return OsmMercator.getDistance(d, d2, d3, d4);
    }

    @Override
    public int LonToX(double d, int n) {
        return (int)OsmMercator.LonToX(d, n);
    }

    @Override
    public int LatToY(double d, int n) {
        return (int)OsmMercator.LatToY(d, n);
    }

    @Override
    public double XToLon(int n, int n2) {
        return OsmMercator.XToLon(n, n2);
    }

    @Override
    public double YToLat(int n, int n2) {
        return OsmMercator.YToLat(n, n2);
    }

    @Override
    public double latToTileY(double d, int n) {
        return OsmMercator.LatToY(d, n) / (double)OsmMercator.TILE_SIZE;
    }

    @Override
    public double lonToTileX(double d, int n) {
        return OsmMercator.LonToX(d, n) / (double)OsmMercator.TILE_SIZE;
    }

    @Override
    public double tileYToLat(int n, int n2) {
        return OsmMercator.YToLat(n * OsmMercator.TILE_SIZE, n2);
    }

    @Override
    public double tileXToLon(int n, int n2) {
        return OsmMercator.XToLon(n * OsmMercator.TILE_SIZE, n2);
    }
}

