/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class FeatureAdapter {
    private static BrowserAdapter browserAdapter = new DefaultBrowserAdapter();
    private static TranslationAdapter translationAdapter = new DefaultTranslationAdapter();
    private static LoggingAdapter loggingAdapter = new DefaultLoggingAdapter();

    public static void registerBrowserAdapter(BrowserAdapter browserAdapter) {
        FeatureAdapter.browserAdapter = browserAdapter;
    }

    public static void registerTranslationAdapter(TranslationAdapter translationAdapter) {
        FeatureAdapter.translationAdapter = translationAdapter;
    }

    public static void registerLoggingAdapter(LoggingAdapter loggingAdapter) {
        FeatureAdapter.loggingAdapter = loggingAdapter;
    }

    public static void openLink(String string) {
        browserAdapter.openLink(string);
    }

    public static String tr(String string, Object ... objectArray) {
        return translationAdapter.tr(string, objectArray);
    }

    public static Logger getLogger(String string) {
        return loggingAdapter.getLogger(string);
    }

    public static class DefaultLoggingAdapter
    implements LoggingAdapter {
        @Override
        public Logger getLogger(String string) {
            return Logger.getLogger(string);
        }
    }

    public static class DefaultTranslationAdapter
    implements TranslationAdapter {
        @Override
        public String tr(String string, Object ... objectArray) {
            return MessageFormat.format(string, objectArray);
        }
    }

    public static class DefaultBrowserAdapter
    implements BrowserAdapter {
        @Override
        public void openLink(String string) {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(new URI(string));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
            } else {
                System.err.println(FeatureAdapter.tr("Opening link not supported on current platform (''{0}'')", string));
            }
        }
    }

    public static interface LoggingAdapter {
        public Logger getLogger(String var1);
    }

    public static interface TranslationAdapter {
        public String tr(String var1, Object ... var2);
    }

    public static interface BrowserAdapter {
        public void openLink(String var1);
    }
}

