/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.control;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.admin.JCSAdminBean;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.commons.jcs.engine.CompositeCacheAttributes;
import org.apache.commons.jcs.engine.ElementAttributes;
import org.apache.commons.jcs.engine.behavior.ICache;
import org.apache.commons.jcs.engine.behavior.ICacheType;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.behavior.IProvideScheduler;
import org.apache.commons.jcs.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheConfigurator;
import org.apache.commons.jcs.engine.control.event.ElementEventQueue;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventQueue;
import org.apache.commons.jcs.engine.stats.CacheStats;
import org.apache.commons.jcs.engine.stats.behavior.ICacheStats;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.jcs.utils.threadpool.ThreadPoolManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeCacheManager
implements IRemoteCacheConstants,
ICompositeCacheManager,
IProvideScheduler {
    private static final Log log = LogFactory.getLog(CompositeCacheManager.class);
    public static final String JMX_OBJECT_NAME = "org.apache.commons.jcs:type=JCSAdminBean";
    private final Map<String, ICache<?, ?>> caches = new ConcurrentHashMap();
    private int clients;
    private ICompositeCacheAttributes defaultCacheAttr = new CompositeCacheAttributes();
    private IElementAttributes defaultElementAttr = new ElementAttributes();
    private final Map<String, AuxiliaryCacheFactory> auxiliaryFactoryRegistry = new ConcurrentHashMap<String, AuxiliaryCacheFactory>(11);
    private final Map<String, AuxiliaryCacheAttributes> auxiliaryAttributeRegistry = new ConcurrentHashMap<String, AuxiliaryCacheAttributes>(11);
    private final Map<String, AuxiliaryCache<?, ?>> auxiliaryCaches = new ConcurrentHashMap(11);
    private Properties configurationProperties;
    private String defaultAuxValues;
    private static CompositeCacheManager instance;
    private static final String SYSTEM_PROPERTY_KEY_PREFIX = "jcs";
    private static final boolean DEFAULT_USE_SYSTEM_PROPERTIES = true;
    private static final boolean DEFAULT_FORCE_RECONFIGURATION = false;
    private final LinkedHashSet<IShutdownObserver> shutdownObservers = new LinkedHashSet();
    private ScheduledExecutorService scheduledExecutor;
    private IElementEventQueue elementEventQueue;
    private ShutdownHook shutdownHook;
    private boolean isInitialized = false;
    private boolean isConfigured = false;
    private boolean isJMXRegistered = false;
    private String jmxName = "org.apache.commons.jcs:type=JCSAdminBean";

    public static synchronized CompositeCacheManager getInstance() throws CacheException {
        return CompositeCacheManager.getInstance("/cache.ccf");
    }

    public static synchronized CompositeCacheManager getInstance(String string) throws CacheException {
        if (instance == null) {
            if (log.isInfoEnabled()) {
                log.info("Instance is null, creating with config [" + string + "]");
            }
            instance = CompositeCacheManager.createInstance();
        }
        if (!instance.isInitialized()) {
            instance.initialize();
        }
        if (!instance.isConfigured()) {
            instance.configure(string);
        }
        instance.incrementClients();
        return instance;
    }

    public static synchronized CompositeCacheManager getUnconfiguredInstance() {
        if (instance == null) {
            if (log.isInfoEnabled()) {
                log.info("Instance is null, returning unconfigured instance");
            }
            instance = CompositeCacheManager.createInstance();
        }
        if (!instance.isInitialized()) {
            instance.initialize();
        }
        instance.incrementClients();
        return instance;
    }

    protected static CompositeCacheManager createInstance() {
        return new CompositeCacheManager();
    }

    protected CompositeCacheManager() {
    }

    protected void initialize() {
        if (!this.isInitialized) {
            this.shutdownHook = new ShutdownHook();
            try {
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
            catch (AccessControlException accessControlException) {
                log.error("Could not register shutdown hook.", accessControlException);
            }
            this.scheduledExecutor = Executors.newScheduledThreadPool(4, new DaemonThreadFactory("JCS-Scheduler-", 1));
            if (!this.isJMXRegistered && this.jmxName != null) {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                JCSAdminBean jCSAdminBean = new JCSAdminBean(this);
                try {
                    ObjectName objectName = new ObjectName(this.jmxName);
                    mBeanServer.registerMBean(jCSAdminBean, objectName);
                    this.isJMXRegistered = true;
                }
                catch (Exception exception) {
                    log.warn("Could not register JMX bean.", exception);
                }
            }
            this.elementEventQueue = new ElementEventQueue();
            this.isInitialized = true;
        }
    }

    public IElementEventQueue getElementEventQueue() {
        return this.elementEventQueue;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutor;
    }

    public void configure() throws CacheException {
        this.configure("/cache.ccf");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(String string) throws CacheException {
        log.info("Creating cache manager from config file: " + string);
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) throw new CacheException("Failed to read configuration file [" + string + "]");
        try {
            properties.load(inputStream);
            if (log.isDebugEnabled()) {
                log.debug("File [" + string + "] contained " + properties.size() + " properties");
            }
        }
        catch (IOException iOException) {
            throw new CacheException("Failed to load properties for name [" + string + "]", iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.configure(properties);
    }

    public void configure(Properties properties) {
        this.configure(properties, true);
    }

    public void configure(Properties properties, boolean bl) {
        this.configure(properties, bl, false);
    }

    public synchronized void configure(Properties properties, boolean bl, boolean bl2) {
        if (properties == null) {
            log.error("No properties found.  Please configure the cache correctly.");
            return;
        }
        if (this.isConfigured) {
            if (!bl2) {
                if (log.isDebugEnabled()) {
                    log.debug("Configure called after the manager has been configured.  Force reconfiguration is false.  Doing nothing");
                }
                return;
            }
            if (log.isInfoEnabled()) {
                log.info("Configure called after the manager has been configured.  Force reconfiguration is true.  Reconfiguring as best we can.");
            }
        }
        if (bl) {
            CompositeCacheManager.overrideWithSystemProperties(properties);
        }
        this.doConfigure(properties);
    }

    private static void overrideWithSystemProperties(Properties properties) {
        Properties properties2 = System.getProperties();
        Set<Object> set = properties2.keySet();
        for (String string : set) {
            if (!string.startsWith(SYSTEM_PROPERTY_KEY_PREFIX)) continue;
            if (log.isInfoEnabled()) {
                log.info("Using system property [[" + string + "] [" + properties2.getProperty(string) + "]]");
            }
            properties.put(string, properties2.getProperty(string));
        }
    }

    private void doConfigure(Properties properties) {
        this.configurationProperties = properties;
        ThreadPoolManager.setProps(properties);
        ThreadPoolManager threadPoolManager = ThreadPoolManager.getInstance();
        if (log.isDebugEnabled()) {
            log.debug("ThreadPoolManager = " + threadPoolManager);
        }
        CompositeCacheConfigurator compositeCacheConfigurator = new CompositeCacheConfigurator(this);
        compositeCacheConfigurator.doConfigure(properties);
        this.isConfigured = true;
    }

    public ICompositeCacheAttributes getDefaultCacheAttributes() {
        return this.defaultCacheAttr.copy();
    }

    public void setDefaultCacheAttributes(ICompositeCacheAttributes iCompositeCacheAttributes) {
        this.defaultCacheAttr = iCompositeCacheAttributes;
    }

    public void setDefaultElementAttributes(IElementAttributes iElementAttributes) {
        this.defaultElementAttr = iElementAttributes;
    }

    public IElementAttributes getDefaultElementAttributes() {
        return this.defaultElementAttr.copy();
    }

    @Override
    public <K, V> CompositeCache<K, V> getCache(String string) {
        return this.getCache(string, this.defaultCacheAttr.copy());
    }

    public <K, V> CompositeCache<K, V> getCache(String string, ICompositeCacheAttributes iCompositeCacheAttributes) {
        iCompositeCacheAttributes.setCacheName(string);
        return this.getCache(iCompositeCacheAttributes, this.defaultElementAttr);
    }

    public <K, V> CompositeCache<K, V> getCache(String string, ICompositeCacheAttributes iCompositeCacheAttributes, IElementAttributes iElementAttributes) {
        iCompositeCacheAttributes.setCacheName(string);
        return this.getCache(iCompositeCacheAttributes, iElementAttributes);
    }

    public <K, V> CompositeCache<K, V> getCache(ICompositeCacheAttributes iCompositeCacheAttributes) {
        return this.getCache(iCompositeCacheAttributes, this.defaultElementAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> CompositeCache<K, V> getCache(ICompositeCacheAttributes iCompositeCacheAttributes, IElementAttributes iElementAttributes) {
        CompositeCache compositeCache;
        if (log.isDebugEnabled()) {
            log.debug("attr = " + iElementAttributes);
        }
        Map<String, ICache<?, ?>> map = this.caches;
        synchronized (map) {
            compositeCache = (CompositeCache)this.caches.get(iCompositeCacheAttributes.getCacheName());
            if (compositeCache == null) {
                iCompositeCacheAttributes.setCacheName(iCompositeCacheAttributes.getCacheName());
                CompositeCacheConfigurator compositeCacheConfigurator = new CompositeCacheConfigurator(this);
                compositeCache = compositeCacheConfigurator.parseRegion(this.getConfigurationProperties(), iCompositeCacheAttributes.getCacheName(), this.defaultAuxValues, iCompositeCacheAttributes);
                this.caches.put(iCompositeCacheAttributes.getCacheName(), compositeCache);
            }
        }
        return compositeCache;
    }

    public void freeCache(String string) {
        this.freeCache(string, false);
    }

    public void freeCache(String string, boolean bl) {
        CompositeCache compositeCache = (CompositeCache)this.caches.remove(string);
        if (compositeCache != null) {
            compositeCache.dispose(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Class<CompositeCacheManager> clazz = CompositeCacheManager.class;
        synchronized (CompositeCacheManager.class) {
            this.elementEventQueue.dispose();
            this.scheduledExecutor.shutdownNow();
            Object object = this.shutdownObservers;
            synchronized (object) {
                for (IShutdownObserver iShutdownObserver : this.shutdownObservers) {
                    iShutdownObserver.shutdown();
                }
            }
            if (this.isJMXRegistered) {
                object = ManagementFactory.getPlatformMBeanServer();
                try {
                    ObjectName objectName = new ObjectName(this.jmxName);
                    object.unregisterMBean(objectName);
                }
                catch (Exception exception) {
                    log.warn("Could not unregister JMX bean.", exception);
                }
                this.isJMXRegistered = false;
            }
            for (String string : this.getCacheNames()) {
                this.freeCache(string);
            }
            for (AuxiliaryCacheFactory auxiliaryCacheFactory : this.auxiliaryFactoryRegistry.values()) {
                auxiliaryCacheFactory.dispose();
            }
            this.auxiliaryAttributeRegistry.clear();
            this.auxiliaryFactoryRegistry.clear();
            if (this.shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.shutdownHook = null;
            }
            this.isConfigured = false;
            this.isInitialized = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void incrementClients() {
        ++this.clients;
    }

    public void release() {
        this.release(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(boolean bl) {
        Class<CompositeCacheManager> clazz = CompositeCacheManager.class;
        synchronized (CompositeCacheManager.class) {
            if (--this.clients > 0 && log.isDebugEnabled()) {
                log.debug("Release called, but " + this.clients + " remain");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Last client called release. There are " + this.caches.size() + " caches which will be disposed");
            }
            for (ICache<?, ?> iCache : this.caches.values()) {
                CompositeCache compositeCache = (CompositeCache)iCache;
                if (compositeCache == null) continue;
                compositeCache.dispose(bl);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String[] getCacheNames() {
        return this.caches.keySet().toArray(new String[this.caches.size()]);
    }

    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.CACHE_HUB;
    }

    public ICompositeCacheAttributes getDefaultCattr() {
        return this.defaultCacheAttr;
    }

    public void registryFacPut(AuxiliaryCacheFactory auxiliaryCacheFactory) {
        this.auxiliaryFactoryRegistry.put(auxiliaryCacheFactory.getName(), auxiliaryCacheFactory);
    }

    public AuxiliaryCacheFactory registryFacGet(String string) {
        return this.auxiliaryFactoryRegistry.get(string);
    }

    public void registryAttrPut(AuxiliaryCacheAttributes auxiliaryCacheAttributes) {
        this.auxiliaryAttributeRegistry.put(auxiliaryCacheAttributes.getName(), auxiliaryCacheAttributes);
    }

    public AuxiliaryCacheAttributes registryAttrGet(String string) {
        return this.auxiliaryAttributeRegistry.get(string);
    }

    public void addCache(String string, ICache<?, ?> iCache) {
        this.caches.put(string, iCache);
    }

    public void addAuxiliaryCache(String string, String string2, AuxiliaryCache<?, ?> auxiliaryCache) {
        String string3 = String.format("aux.%s.region.%s", string, string2);
        this.auxiliaryCaches.put(string3, auxiliaryCache);
    }

    @Override
    public <K, V> AuxiliaryCache<K, V> getAuxiliaryCache(String string, String string2) {
        String string3 = String.format("aux.%s.region.%s", string, string2);
        return this.auxiliaryCaches.get(string3);
    }

    public void setDefaultAuxValues(String string) {
        this.defaultAuxValues = string;
    }

    @Override
    public String getStats() {
        ICacheStats[] iCacheStatsArray = this.getStatistics();
        if (iCacheStatsArray == null) {
            return "NONE";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = iCacheStatsArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("\n---------------------------\n");
            stringBuilder.append(iCacheStatsArray[i]);
        }
        return stringBuilder.toString();
    }

    public ICacheStats[] getStatistics() {
        ArrayList<ICacheStats> arrayList = new ArrayList<ICacheStats>();
        for (ICache<?, ?> iCache : this.caches.values()) {
            CompositeCache compositeCache = (CompositeCache)iCache;
            if (compositeCache == null) continue;
            arrayList.add(compositeCache.getStatistics());
        }
        ICacheStats[] iCacheStatsArray = arrayList.toArray(new CacheStats[0]);
        return iCacheStatsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerShutdownObserver(IShutdownObserver iShutdownObserver) {
        LinkedHashSet<IShutdownObserver> linkedHashSet = this.shutdownObservers;
        synchronized (linkedHashSet) {
            this.shutdownObservers.add(iShutdownObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterShutdownObserver(IShutdownObserver iShutdownObserver) {
        LinkedHashSet<IShutdownObserver> linkedHashSet = this.shutdownObservers;
        synchronized (linkedHashSet) {
            this.shutdownObservers.remove(iShutdownObserver);
        }
    }

    void setConfigurationProperties(Properties properties) {
        this.configurationProperties = properties;
    }

    @Override
    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public void setJmxName(String string) {
        if (this.isJMXRegistered) {
            throw new IllegalStateException("Too late, MBean registration is done");
        }
        this.jmxName = string;
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            if (CompositeCacheManager.this.isInitialized()) {
                log.info("Shutdown hook activated.  Shutdown was not called.  Shutting down JCS.");
                CompositeCacheManager.this.shutDown();
            }
        }
    }
}

