/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.StreamEater;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class XDesktopEntry {
    public static final String JAVA_ICON_NAME = "java";
    private JNLPFile file = null;
    private int iconSize = -1;
    private String iconLocation = null;
    private int[] VALID_ICON_SIZES = new int[]{16, 22, 32, 48, 64, 128};
    static final String XDG_DESKTOP_DIR = "XDG_DESKTOP_DIR";
    private static final String MIC = "MAGIC_QUOTIN_ITW_CONSTANT_FOR_DUMMIES";

    public XDesktopEntry(JNLPFile file) {
        this.file = file;
        this.iconSize = this.VALID_ICON_SIZES[2];
    }

    public Reader getContentsAsReader() {
        String cacheDir = JNLPRuntime.getConfiguration().getProperty("deployment.user.cachedir");
        File cacheFile = CacheUtil.getCacheFile(this.file.getSourceLocation(), null);
        String fileContents = "[Desktop Entry]\n";
        fileContents = fileContents + "Version=1.0\n";
        fileContents = fileContents + "Name=" + this.getDesktopIconName() + "\n";
        fileContents = fileContents + "GenericName=Java Web Start Application\n";
        fileContents = fileContents + "Comment=" + XDesktopEntry.sanitize(this.file.getInformation().getDescription()) + "\n";
        fileContents = fileContents + "Type=Application\n";
        fileContents = this.iconLocation != null ? fileContents + "Icon=" + this.iconLocation + "\n" : fileContents + "Icon=java\n";
        if (this.file.getInformation().getVendor() != null) {
            fileContents = fileContents + "Vendor=" + XDesktopEntry.sanitize(this.file.getInformation().getVendor()) + "\n";
        }
        fileContents = fileContents + "Exec=javaws \"" + this.file.getSourceLocation() + "\"\n";
        return new StringReader(fileContents);
    }

    private static String sanitize(String input) {
        if (input == null) {
            return "";
        }
        return input.split("\n")[0];
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public File getShortcutTmpFile() {
        String userTmp = JNLPRuntime.getConfiguration().getProperty("deployment.user.tmp");
        File shortcutFile = new File(userTmp + File.separator + FileUtils.sanitizeFileName(this.file.getTitle()) + ".desktop");
        return shortcutFile;
    }

    public void setIconSize(int size) {
        this.iconSize = size;
    }

    public void createDesktopShortcut() {
        try {
            this.cacheIcon();
            this.installDesktopLauncher();
        }
        catch (Exception e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
    }

    private void installDesktopLauncher() {
        File shortcutFile = this.getShortcutTmpFile();
        try {
            if (!shortcutFile.getParentFile().isDirectory() && !shortcutFile.getParentFile().mkdirs()) {
                throw new IOException(shortcutFile.getParentFile().toString());
            }
            FileUtils.createRestrictedFile(shortcutFile, true);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(shortcutFile), Charset.forName("UTF-8"));
            Reader reader = this.getContentsAsReader();
            char[] buffer = new char[1024];
            int ret = 0;
            while (-1 != (ret = reader.read(buffer))) {
                writer.write(buffer, 0, ret);
            }
            reader.close();
            writer.close();
            Object[] execString = new String[]{"xdg-desktop-icon", "install", "--novendor", shortcutFile.getCanonicalPath()};
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Execing: " + Arrays.toString(execString));
            Process installer = Runtime.getRuntime().exec((String[])execString);
            new StreamEater(installer.getInputStream()).start();
            new StreamEater(installer.getErrorStream()).start();
            try {
                installer.waitFor();
            }
            catch (InterruptedException e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            }
            if (!shortcutFile.delete()) {
                throw new IOException("Unable to delete temporary file:" + shortcutFile);
            }
        }
        catch (FileNotFoundException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
    }

    private void cacheIcon() {
        URL iconLocation = this.file.getInformation().getIconLocation(IconDesc.SHORTCUT, this.iconSize, this.iconSize);
        if (iconLocation == null) {
            iconLocation = this.file.getInformation().getIconLocation(IconDesc.DEFAULT, this.iconSize, this.iconSize);
        }
        if (iconLocation != null) {
            String location = CacheUtil.getCachedResource(iconLocation, null, UpdatePolicy.SESSION).toString();
            if (!location.startsWith("file:")) {
                throw new RuntimeException("Unable to cache icon");
            }
            this.iconLocation = location.substring("file:".length());
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Cached desktop shortcut icon: " + this.iconLocation);
        }
    }

    public String getDesktopIconName() {
        return XDesktopEntry.sanitize(this.file.getTitle());
    }

    public File getLinuxDesktopIconFile() {
        return new File(XDesktopEntry.findFreedesktopOrgDesktopPathCatch() + "/" + this.getDesktopIconName() + ".desktop");
    }

    private static String findFreedesktopOrgDesktopPathCatch() {
        try {
            return XDesktopEntry.findFreedesktopOrgDesktopPath();
        }
        catch (Exception ex) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
            return System.getProperty("user.home") + "/Desktop/";
        }
    }

    private static String findFreedesktopOrgDesktopPath() throws IOException {
        File userDirs = new File(System.getProperty("user.home") + "/.config/user-dirs.dirs");
        if (!userDirs.exists()) {
            return System.getProperty("user.home") + "/Desktop/";
        }
        return XDesktopEntry.getFreedesktopOrgDesktopPathFrom(userDirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFreedesktopOrgDesktopPathFrom(File userDirs) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(userDirs));
        try {
            String string = XDesktopEntry.getFreedesktopOrgDesktopPathFrom(r);
            return string;
        }
        finally {
            r.close();
        }
    }

    static String getFreedesktopOrgDesktopPathFrom(BufferedReader r) throws IOException {
        String s;
        do {
            if ((s = r.readLine()) != null) continue;
            throw new IOException("End of user-dirs found, but no XDG_DESKTOP_DIR key found");
        } while (!(s = s.trim()).startsWith(XDG_DESKTOP_DIR));
        if (!s.contains("=")) {
            throw new IOException("XDG_DESKTOP_DIR has no value");
        }
        String[] keyAndValue = s.split("=");
        keyAndValue[1] = keyAndValue[1].trim();
        String filteredQuotes = XDesktopEntry.filterQuotes(keyAndValue[1]);
        return XDesktopEntry.evaluateLinuxVariables(filteredQuotes);
    }

    private static String filterQuotes(String string) {
        String s = string.replaceAll("\\\\\"", MIC);
        s = s.replaceAll("\"", "");
        s = s.replaceAll(MIC, "\\\"");
        return s;
    }

    private static String evaluateLinuxVariables(String orig) {
        return XDesktopEntry.evaluateLinuxVariables(orig, System.getenv());
    }

    private static String evaluateLinuxVariables(String orig, Map<String, String> variables) {
        String before;
        Set<Map.Entry<String, String>> env = variables.entrySet();
        ArrayList<Map.Entry<String, String>> envVariables = new ArrayList<Map.Entry<String, String>>(env);
        Collections.sort(envVariables, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o2.getKey().length() - o1.getKey().length();
            }
        });
        do {
            before = orig;
            for (Map.Entry entry : envVariables) {
                orig = orig.replaceAll("\\$" + (String)entry.getKey(), (String)entry.getValue());
            }
        } while (!before.equals(orig));
        return orig;
    }
}

