/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.util.logging.OutputController;

public class UrlUtils {
    private static final String UTF8 = "utf-8";

    public static URL normalizeUrlAndStripParams(URL url, boolean encodeFileUrls) {
        try {
            String[] urlParts = url.toString().split("\\?");
            URL strippedUrl = new URL(urlParts[0]);
            return UrlUtils.normalizeUrl(strippedUrl, encodeFileUrls);
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        catch (URISyntaxException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        return url;
    }

    public static URL normalizeUrlAndStripParams(URL url) {
        return UrlUtils.normalizeUrlAndStripParams(url, false);
    }

    public static boolean isLocalFile(URL url) {
        return !(!url.getProtocol().equals("file") || url.getAuthority() != null && !url.getAuthority().equals("") || url.getHost() != null && !url.getHost().equals(""));
    }

    public static URL decodeUrlQuietly(URL url) {
        try {
            return new URL(URLDecoder.decode(url.toString(), UTF8));
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            return url;
        }
    }

    public static boolean isValidRFC2396Url(URL url) {
        try {
            url.toURI();
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static URL normalizeUrl(URL url, boolean encodeFileUrls) throws MalformedURLException, UnsupportedEncodingException, URISyntaxException {
        boolean shouldEncode;
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        boolean bl = shouldEncode = encodeFileUrls || !"file".equals(protocol);
        if (protocol == null || !shouldEncode || url.getPath() == null || UrlUtils.isValidRFC2396Url(url)) {
            return url;
        }
        URL decodedURL = new URL(URLDecoder.decode(url.toString(), UTF8));
        URI uri = new URI(decodedURL.getProtocol(), null, decodedURL.getHost(), decodedURL.getPort(), decodedURL.getPath(), decodedURL.getQuery(), null);
        URL encodedURL = new URL(uri.toASCIIString());
        return encodedURL;
    }

    public static URL normalizeUrl(URL url) throws MalformedURLException, UnsupportedEncodingException, URISyntaxException {
        return UrlUtils.normalizeUrl(url, false);
    }

    public static URL normalizeUrlQuietly(URL url, boolean encodeFileUrls) {
        try {
            return UrlUtils.normalizeUrl(url, encodeFileUrls);
        }
        catch (MalformedURLException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        catch (UnsupportedEncodingException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        catch (URISyntaxException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        return url;
    }

    public static URL normalizeUrlQuietly(URL url) {
        return UrlUtils.normalizeUrlQuietly(url, false);
    }

    public static File decodeUrlAsFile(URL url) {
        return new File(UrlUtils.decodeUrlQuietly(url).getFile());
    }

    public static URL removeFileName(URL src) {
        int i2;
        URL nsrc = UrlUtils.normalizeUrlAndStripParams(src);
        String s = nsrc.getPath();
        int i1 = s.lastIndexOf("/");
        int i = Math.max(i1, i2 = s.lastIndexOf("\\"));
        if (i < 0) {
            return src;
        }
        s = s.substring(0, i);
        try {
            return UrlUtils.sanitizeLastSlash(new URL(src.getProtocol(), src.getHost(), src.getPort(), s));
        }
        catch (MalformedURLException ex) {
            OutputController.getLogger().log(ex);
            return nsrc;
        }
    }

    public static String setOfUrlsToHtmlList(Iterable<URL> remoteUrls) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        for (URL url : remoteUrls) {
            sb.append("<li>").append(url.toExternalForm()).append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public static URL sanitizeLastSlash(URL in) throws MalformedURLException {
        if (in == null) {
            return null;
        }
        String s = UrlUtils.sanitizeLastSlash(in.toExternalForm());
        return new URL(s);
    }

    public static String sanitizeLastSlash(String in) {
        if (in == null) {
            return null;
        }
        String s = in;
        while (s.endsWith("/") || s.endsWith("\\")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static boolean equalsIgnoreLastSlash(URL u1, URL u2) {
        try {
            if (u1 == null && u2 == null) {
                return true;
            }
            if (u1 == null && u2 != null) {
                return false;
            }
            if (u1 != null && u2 == null) {
                return false;
            }
            return UrlUtils.sanitizeLastSlash(u1).equals(UrlUtils.sanitizeLastSlash(u2));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URL guessCodeBase(JNLPFile file) {
        if (file.getCodeBase() != null) {
            return file.getCodeBase();
        }
        return file.getResources().getMainJAR().getLocation();
    }
}

