/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.CertificateUtils;
import net.sourceforge.jnlp.security.HttpsCertVerifier;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.SecurityUtil;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;
import net.sourceforge.jnlp.security.dialogs.TemporaryPermissionsButton;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditor;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.misc.Launcher;

public class CertWarningPane
extends SecurityDialogPanel {
    private final JNLPFile file;
    private final SecurityDialogs.AccessType accessType;
    private final Certificate cert;
    private JCheckBox alwaysTrust;
    private final CertVerifier certVerifier;
    private JNLPClassLoader.SecurityDelegate securityDelegate;
    private JPopupMenu policyMenu;
    private JPanel topPanel;
    private JPanel infoPanel;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JLabel topLabel;
    private JLabel nameLabel;
    private JLabel publisherLabel;
    private JLabel fromLabel;
    private JLabel bottomLabel;
    private JButton run;
    private JButton sandbox;
    private JButton advancedOptions;
    private JButton cancel;
    private JButton moreInfo;
    private boolean alwaysTrustSelected;
    private String bottomLabelWarningText;
    private PolicyEditor.PolicyEditorWindow policyEditor = null;

    public CertWarningPane(SecurityDialog x, CertVerifier certVerifier, JNLPClassLoader.SecurityDelegate securityDelegate) {
        super(x, certVerifier);
        this.certVerifier = certVerifier;
        this.securityDelegate = securityDelegate;
        this.accessType = this.parent.getAccessType();
        this.file = this.parent.getFile();
        this.cert = this.parent.getCertVerifier().getPublisher(null);
        this.addComponents();
    }

    private void addComponents() {
        this.setTextAndLabels();
        this.addButtons();
    }

    private void setTextAndLabels() {
        String name = "";
        String publisher = "";
        String from = "";
        try {
            name = this.certVerifier instanceof HttpsCertVerifier && this.cert instanceof X509Certificate ? SecurityUtil.getCN(((X509Certificate)this.cert).getSubjectX500Principal().getName()) : (this.file instanceof PluginBridge ? this.file.getTitle() : this.file.getInformation().getTitle());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.cert instanceof X509Certificate) {
                publisher = SecurityUtil.getCN(((X509Certificate)this.cert).getSubjectX500Principal().getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            from = this.file instanceof PluginBridge ? this.file.getCodeBase().getHost() : this.file.getInformation().getHomepage().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String topLabelText = "";
        this.bottomLabelWarningText = this.parent.getCertVerifier().getRootInCacerts() ? Translator.R("STrustedSource") : Translator.R("SUntrustedSource");
        String iconLocation = "net/sourceforge/jnlp/resources/";
        this.alwaysTrustSelected = false;
        if (this.certVerifier instanceof HttpsCertVerifier) {
            topLabelText = Translator.R("SHttpsUnverified") + " " + Translator.R("Continue");
            iconLocation = iconLocation + "warning.png";
        } else {
            switch (this.accessType) {
                case VERIFIED: {
                    topLabelText = Translator.R("SSigVerified");
                    iconLocation = iconLocation + "question.png";
                    this.alwaysTrustSelected = true;
                    break;
                }
                case UNVERIFIED: {
                    topLabelText = Translator.R("SSigUnverified");
                    iconLocation = iconLocation + "warning.png";
                    this.bottomLabelWarningText = this.bottomLabelWarningText + " " + Translator.R("SWarnFullPermissionsIgnorePolicy");
                    break;
                }
                case SIGNING_ERROR: {
                    topLabelText = Translator.R("SSignatureError");
                    iconLocation = iconLocation + "warning.png";
                    this.bottomLabelWarningText = this.bottomLabelWarningText + " " + Translator.R("SWarnFullPermissionsIgnorePolicy");
                }
            }
        }
        ImageIcon icon = this.getImageIcon(iconLocation);
        this.topLabel = new JLabel(this.htmlWrap(topLabelText), icon, 2);
        this.topLabel.setFont(new Font(this.topLabel.getFont().toString(), 1, 12));
        this.topPanel = new JPanel(new BorderLayout());
        this.topPanel.setBackground(Color.WHITE);
        this.topPanel.add((Component)this.topLabel, "Center");
        this.topPanel.setPreferredSize(new Dimension(400, 75));
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.nameLabel = new JLabel(Translator.R("Name") + ":   " + name);
        this.nameLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.publisherLabel = new JLabel(Translator.R("Publisher") + ": " + publisher);
        this.publisherLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fromLabel = new JLabel(Translator.R("From") + ":   " + from);
        this.fromLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private ImageIcon getImageIcon(String imageLocation) {
        return new ImageIcon(new Launcher().getClassLoader().getResource(imageLocation));
    }

    private void addButtons() {
        this.alwaysTrust = new JCheckBox(Translator.R("SAlwaysTrustPublisher"));
        this.alwaysTrust.setEnabled(true);
        this.alwaysTrust.setSelected(this.alwaysTrustSelected);
        this.infoPanel = new JPanel(new GridLayout(4, 1));
        this.infoPanel.add(this.nameLabel);
        this.infoPanel.add(this.publisherLabel);
        boolean isHttpsCertTrustDialog = this.certVerifier instanceof HttpsCertVerifier;
        if (!isHttpsCertTrustDialog) {
            this.infoPanel.add(this.fromLabel);
        }
        this.infoPanel.add(this.alwaysTrust);
        this.infoPanel.setBorder(BorderFactory.createEmptyBorder(25, 25, 25, 25));
        this.buttonPanel = new JPanel(new FlowLayout(2));
        this.run = new JButton();
        if (isHttpsCertTrustDialog) {
            this.run.setText(Translator.R("ButYes"));
        } else {
            this.run.setText(Translator.R("ButRun"));
        }
        this.sandbox = new JButton(Translator.R("ButSandbox"));
        this.advancedOptions = new TemporaryPermissionsButton(this.file, this.securityDelegate, this.sandbox);
        this.cancel = new JButton();
        if (isHttpsCertTrustDialog) {
            this.cancel.setText(Translator.R("ButNo"));
        } else {
            this.cancel.setText(Translator.R("ButCancel"));
        }
        if (isHttpsCertTrustDialog) {
            this.run.setToolTipText(Translator.R("CertWarnHTTPSAcceptTip"));
        } else {
            this.run.setToolTipText(Translator.R("CertWarnRunTip"));
        }
        this.sandbox.setToolTipText(Translator.R("CertWarnSandboxTip"));
        this.advancedOptions.setToolTipText(Translator.R("CertWarnPolicyTip"));
        if (isHttpsCertTrustDialog) {
            this.cancel.setToolTipText(Translator.R("CertWarnHTTPSRejectTip"));
        } else {
            this.cancel.setToolTipText(Translator.R("CertWarnCancelTip"));
        }
        this.alwaysTrust.addActionListener(new ButtonDisableListener(this.sandbox));
        int buttonWidth = Math.max(this.run.getMinimumSize().width, this.sandbox.getMinimumSize().width);
        buttonWidth = Math.max(buttonWidth, this.cancel.getMinimumSize().width);
        int buttonHeight = this.run.getMinimumSize().height;
        Dimension d = new Dimension(buttonWidth, buttonHeight);
        this.run.setPreferredSize(d);
        this.sandbox.setPreferredSize(d);
        this.advancedOptions.setPreferredSize(new Dimension(this.advancedOptions.getMinimumSize().width, buttonHeight));
        this.cancel.setPreferredSize(d);
        this.sandbox.setEnabled(!this.alwaysTrust.isSelected());
        this.run.addActionListener(this.createSetValueListener(this.parent, 0));
        this.run.addActionListener(new CheckBoxListener());
        this.sandbox.addActionListener(this.createSetValueListener(this.parent, 1));
        this.cancel.addActionListener(this.createSetValueListener(this.parent, 2));
        this.initialFocusComponent = this.cancel;
        this.buttonPanel.add(this.run);
        if (!isHttpsCertTrustDialog) {
            this.buttonPanel.add(this.sandbox);
            this.buttonPanel.add(this.advancedOptions);
        }
        this.buttonPanel.add(this.cancel);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.topPanel);
        this.add(this.infoPanel);
        this.add(this.buttonPanel);
        this.bottomLabel = new JLabel(this.htmlWrap(this.bottomLabelWarningText));
        this.moreInfo = new JButton(Translator.R("ButMoreInformation"));
        this.moreInfo.addActionListener(new MoreInfoButtonListener());
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
        this.bottomPanel.add(this.bottomLabel);
        this.bottomPanel.add(this.moreInfo);
        this.bottomPanel.setPreferredSize(new Dimension(600, 100));
        this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(this.bottomPanel);
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (CertWarningPane.this.alwaysTrust != null && CertWarningPane.this.alwaysTrust.isSelected()) {
                try {
                    KeyStore ks = KeyStores.getKeyStore(KeyStores.Level.USER, KeyStores.Type.CERTS);
                    X509Certificate c = (X509Certificate)CertWarningPane.this.parent.getCertVerifier().getPublisher(null);
                    CertificateUtils.addToKeyStore(c, ks);
                    File keyStoreFile = new File(KeyStores.getKeyStoreLocation(KeyStores.Level.USER, KeyStores.Type.CERTS));
                    if (!keyStoreFile.isFile()) {
                        FileUtils.createRestrictedFile(keyStoreFile, true);
                    }
                    FileOutputStream os = new FileOutputStream(keyStoreFile);
                    try {
                        ks.store(os, KeyStores.getPassword());
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                    OutputController.getLogger().log("certificate is now permanently trusted");
                }
                catch (Exception ex) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
                }
            }
        }
    }

    private class ButtonDisableListener
    implements ActionListener {
        private JButton button;

        public ButtonDisableListener(JButton button) {
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.button.setEnabled(!CertWarningPane.this.alwaysTrust.isSelected());
        }
    }

    private class MoreInfoButtonListener
    implements ActionListener {
        private MoreInfoButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SecurityDialog.showMoreInfoDialog(CertWarningPane.this.parent.getCertVerifier(), CertWarningPane.this.parent);
        }
    }
}

