/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.NetPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.Semaphore;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialogMessage;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteAppletAction;
import net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel.AppTrustWarningPanel;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class SecurityDialogs {
    public static boolean showAccessWarningDialog(AccessType accessType, JNLPFile file) {
        return SecurityDialogs.showAccessWarningDialog(accessType, file, null);
    }

    public static boolean showAccessWarningDialog(AccessType accessType, JNLPFile file, Object[] extras) {
        if (!SecurityDialogs.shouldPromptUser()) {
            return false;
        }
        SecurityDialogMessage message = new SecurityDialogMessage();
        message.dialogType = DialogType.ACCESS_WARNING;
        message.accessType = accessType;
        message.file = file;
        message.extras = extras;
        Object selectedValue = SecurityDialogs.getUserResponse(message);
        return SecurityDialogs.getIntegerResponseAsBoolean(selectedValue);
    }

    public static AppTrustWarningPanel.AppSigningWarningAction showUnsignedWarningDialog(JNLPFile file) {
        if (!SecurityDialogs.shouldPromptUser()) {
            return new AppTrustWarningPanel.AppSigningWarningAction(ExecuteAppletAction.NO, false);
        }
        SecurityDialogMessage message = new SecurityDialogMessage();
        message.dialogType = DialogType.UNSIGNED_WARNING;
        message.accessType = AccessType.UNSIGNED;
        message.file = file;
        return (AppTrustWarningPanel.AppSigningWarningAction)SecurityDialogs.getUserResponse(message);
    }

    public static AppletAction showCertWarningDialog(AccessType accessType, JNLPFile file, CertVerifier certVerifier, JNLPClassLoader.SecurityDelegate securityDelegate) {
        if (!SecurityDialogs.shouldPromptUser()) {
            return AppletAction.CANCEL;
        }
        SecurityDialogMessage message = new SecurityDialogMessage();
        message.dialogType = DialogType.CERT_WARNING;
        message.accessType = accessType;
        message.file = file;
        message.certVerifier = certVerifier;
        message.extras = new Object[]{securityDelegate};
        Object selectedValue = SecurityDialogs.getUserResponse(message);
        return SecurityDialogs.getIntegerResponseAsAppletAction(selectedValue);
    }

    public static AppTrustWarningPanel.AppSigningWarningAction showPartiallySignedWarningDialog(JNLPFile file, CertVerifier certVerifier, JNLPClassLoader.SecurityDelegate securityDelegate) {
        if (!SecurityDialogs.shouldPromptUser()) {
            return new AppTrustWarningPanel.AppSigningWarningAction(ExecuteAppletAction.NO, false);
        }
        SecurityDialogMessage message = new SecurityDialogMessage();
        message.dialogType = DialogType.PARTIALLYSIGNED_WARNING;
        message.accessType = AccessType.PARTIALLYSIGNED;
        message.file = file;
        message.certVerifier = certVerifier;
        message.extras = new Object[]{securityDelegate};
        return (AppTrustWarningPanel.AppSigningWarningAction)SecurityDialogs.getUserResponse(message);
    }

    public static Object[] showAuthenicationPrompt(String host, int port, String prompt, String type) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            NetPermission requestPermission = new NetPermission("requestPasswordAuthentication");
            sm.checkPermission(requestPermission);
        }
        SecurityDialogMessage message = new SecurityDialogMessage();
        message.dialogType = DialogType.AUTHENTICATION;
        message.extras = new Object[]{host, port, prompt, type};
        Object response = SecurityDialogs.getUserResponse(message);
        return (Object[])response;
    }

    public static boolean showMissingALACAttributePanel(String title, URL codeBase, Set<URL> remoteUrls) {
        if (!SecurityDialogs.shouldPromptUser()) {
            return false;
        }
        SecurityDialogMessage message = new SecurityDialogMessage();
        message.dialogType = DialogType.MISSING_ALACA;
        String urlToShow = "unknown url";
        if (codeBase != null) {
            urlToShow = codeBase.toString();
        } else {
            OutputController.getLogger().log("Warning, null codebase wants to show in ALACA!");
        }
        message.extras = new Object[]{title, urlToShow, UrlUtils.setOfUrlsToHtmlList(remoteUrls)};
        Object selectedValue = SecurityDialogs.getUserResponse(message);
        return SecurityDialogs.getIntegerResponseAsBoolean(selectedValue);
    }

    public static boolean showMatchingALACAttributePanel(String title, URL codeBase, Set<URL> remoteUrls) {
        if (!SecurityDialogs.shouldPromptUser()) {
            return false;
        }
        SecurityDialogMessage message = new SecurityDialogMessage();
        message.dialogType = DialogType.MATCHING_ALACA;
        message.extras = new Object[]{title, codeBase.toString(), UrlUtils.setOfUrlsToHtmlList(remoteUrls)};
        Object selectedValue = SecurityDialogs.getUserResponse(message);
        return SecurityDialogs.getIntegerResponseAsBoolean(selectedValue);
    }

    public static int showAppletWarning() {
        if (!SecurityDialogs.shouldPromptUser()) {
            return 2;
        }
        SecurityDialogMessage message = new SecurityDialogMessage();
        message.dialogType = DialogType.APPLET_WARNING;
        Object selectedValue = SecurityDialogs.getUserResponse(message);
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue;
        }
        return 2;
    }

    public static boolean showMissingPermissionsAttributeDialogue(String title, URL codeBase) {
        if (!SecurityDialogs.shouldPromptUser()) {
            return false;
        }
        SecurityDialogMessage message = new SecurityDialogMessage();
        message.dialogType = DialogType.UNSIGNED_EAS_NO_PERMISSIONS_WARNING;
        message.extras = new Object[]{title, codeBase.toExternalForm()};
        Object selectedValue = SecurityDialogs.getUserResponse(message);
        return SecurityDialogs.getIntegerResponseAsBoolean(selectedValue);
    }

    private static Object getUserResponse(final SecurityDialogMessage message) {
        if (SwingUtilities.isEventDispatchThread()) {
            final JDialog fakeDialog = new JDialog();
            fakeDialog.setSize(0, 0);
            fakeDialog.setResizable(false);
            fakeDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            fakeDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    message.toDispose = fakeDialog;
                    message.lock = null;
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            JNLPRuntime.getSecurityDialogHandler().postMessage(message);
                            return null;
                        }
                    });
                }
            });
            fakeDialog.setVisible(true);
        } else {
            message.toDispose = null;
            message.lock = new Semaphore(0);
            JNLPRuntime.getSecurityDialogHandler().postMessage(message);
            boolean done = false;
            while (!done) {
                try {
                    message.lock.acquire();
                    done = true;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return message.userResponse;
    }

    public static boolean getIntegerResponseAsBoolean(Object ref) {
        boolean isInteger = ref instanceof Integer;
        if (isInteger) {
            Integer i = (Integer)ref;
            return i == 0;
        }
        return false;
    }

    public static AppletAction getIntegerResponseAsAppletAction(Object ref) {
        if (ref instanceof Integer) {
            return AppletAction.fromInteger((Integer)ref);
        }
        return AppletAction.CANCEL;
    }

    private static boolean shouldPromptUser() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.valueOf(JNLPRuntime.getConfiguration().getProperty("deployment.security.askgrantdialog.show"));
            }
        });
    }

    public static enum AppletAction {
        RUN,
        SANDBOX,
        CANCEL;


        public static AppletAction fromInteger(int i) {
            switch (i) {
                case 0: {
                    return RUN;
                }
                case 1: {
                    return SANDBOX;
                }
                case 2: {
                    return CANCEL;
                }
            }
            return CANCEL;
        }
    }

    public static enum AccessType {
        READ_FILE,
        WRITE_FILE,
        CREATE_DESTKOP_SHORTCUT,
        CLIPBOARD_READ,
        CLIPBOARD_WRITE,
        PRINTER,
        NETWORK,
        VERIFIED,
        UNVERIFIED,
        PARTIALLYSIGNED,
        UNSIGNED,
        SIGNING_ERROR;

    }

    public static enum DialogType {
        CERT_WARNING,
        MORE_INFO,
        CERT_INFO,
        SINGLE_CERT_INFO,
        ACCESS_WARNING,
        PARTIALLYSIGNED_WARNING,
        UNSIGNED_WARNING,
        APPLET_WARNING,
        AUTHENTICATION,
        UNSIGNED_EAS_NO_PERMISSIONS_WARNING,
        MISSING_ALACA,
        MATCHING_ALACA;

    }
}

