/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.AssociationDesc;
import net.sourceforge.jnlp.ComponentDesc;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.InstallerDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JREDesc;
import net.sourceforge.jnlp.LaunchDesc;
import net.sourceforge.jnlp.MenuDesc;
import net.sourceforge.jnlp.MissingInformationException;
import net.sourceforge.jnlp.MissingTitleException;
import net.sourceforge.jnlp.MissingVendorException;
import net.sourceforge.jnlp.Node;
import net.sourceforge.jnlp.PackageDesc;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.RelatedContentDesc;
import net.sourceforge.jnlp.RequiredElementException;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.ShortcutDesc;
import net.sourceforge.jnlp.UpdateDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

class Parser {
    private static String CODEBASE = "codebase";
    private JNLPFile file;
    private Node root;
    private Version spec;
    private URL base;
    private URL codebase;
    private URL fileLocation;
    private boolean strict;
    private boolean allowExtensions;

    public Parser(JNLPFile file, URL base, Node root, ParserSettings settings) throws ParseException {
        this(file, base, root, settings, null);
    }

    public Parser(JNLPFile file, URL base, Node root, ParserSettings settings, URL codebase) throws ParseException {
        this.file = file;
        this.root = root;
        this.strict = settings.isStrict();
        this.allowExtensions = settings.isExtensionAllowed();
        if (root == null || !root.getNodeName().equals("jnlp")) {
            throw new ParseException(Translator.R("PInvalidRoot"));
        }
        this.spec = this.getVersion(root, "spec", "1.0+");
        try {
            this.codebase = this.addSlash(this.getURL(root, CODEBASE, base));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.codebase == null) {
            this.codebase = codebase;
        }
        this.base = this.codebase != null ? this.codebase : base;
        this.fileLocation = this.getURL(root, "href", this.base);
        root.normalize();
    }

    public Version getFileVersion() {
        return this.getVersion(this.root, "version", null);
    }

    public URL getFileLocation() {
        return this.fileLocation;
    }

    public URL getCodeBase() {
        return this.codebase;
    }

    public Version getSpecVersion() {
        return this.spec;
    }

    public UpdateDesc getUpdate(Node parent) throws ParseException {
        UpdateDesc updateDesc = null;
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals("update")) continue;
            if (this.strict && updateDesc != null) {
                throw new ParseException(Translator.R("PTwoUpdates"));
            }
            Node node = child;
            String checkValue = this.getAttribute(node, "check", "timeout");
            UpdateDesc.Check check = checkValue.equals("always") ? UpdateDesc.Check.ALWAYS : (checkValue.equals("timeout") ? UpdateDesc.Check.TIMEOUT : (checkValue.equals("background") ? UpdateDesc.Check.BACKGROUND : UpdateDesc.Check.TIMEOUT));
            String policyString = this.getAttribute(node, "policy", "always");
            UpdateDesc.Policy policy = policyString.equals("always") ? UpdateDesc.Policy.ALWAYS : (policyString.equals("prompt-update") ? UpdateDesc.Policy.PROMPT_UPDATE : (policyString.equals("prompt-run") ? UpdateDesc.Policy.PROMPT_RUN : UpdateDesc.Policy.ALWAYS));
            updateDesc = new UpdateDesc(check, policy);
        }
        if (updateDesc == null) {
            updateDesc = new UpdateDesc(UpdateDesc.Check.TIMEOUT, UpdateDesc.Policy.ALWAYS);
        }
        return updateDesc;
    }

    public List<ResourcesDesc> getResources(Node parent, boolean j2se) throws ParseException {
        ArrayList<ResourcesDesc> result = new ArrayList<ResourcesDesc>();
        Node[] resources = Parser.getChildNodes(parent, "resources");
        if (resources.length == 0 && !j2se) {
            throw new ParseException(Translator.R("PNoResources"));
        }
        for (int i = 0; i < resources.length; ++i) {
            result.add(this.getResourcesDesc(resources[i], j2se));
        }
        return result;
    }

    public ResourcesDesc getResourcesDesc(Node node, boolean j2se) throws ParseException {
        boolean mainFlag = false;
        ResourcesDesc resources = new ResourcesDesc(this.file, this.getLocales(node), this.splitString(this.getAttribute(node, "os", null)), this.splitString(this.getAttribute(node, "arch", null)));
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("nativelib".equals(name) && !this.isTrustedEnvironment()) {
                throw new ParseException(Translator.R("PUntrustedNative"));
            }
            if ("j2se".equals(name) || "java".equals(name)) {
                if (Parser.getChildNode(this.root, "component-desc") != null && this.strict) {
                    throw new ParseException(Translator.R("PExtensionHasJ2SE"));
                }
                if (!j2se) {
                    resources.addResource(this.getJRE(child));
                } else {
                    throw new ParseException(Translator.R("PInnerJ2SE"));
                }
            }
            if ("jar".equals(name) || "nativelib".equals(name)) {
                JARDesc jar = this.getJAR(child);
                if (jar.isMain()) {
                    if (mainFlag && this.strict) {
                        throw new ParseException(Translator.R("PTwoMains"));
                    }
                    mainFlag = true;
                }
                resources.addResource(jar);
            }
            if ("extension".equals(name)) {
                resources.addResource(this.getExtension(child));
            }
            if ("property".equals(name)) {
                resources.addResource(this.getProperty(child));
            }
            if (!"package".equals(name)) continue;
            resources.addResource(this.getPackage(child));
        }
        return resources;
    }

    public JREDesc getJRE(Node node) throws ParseException {
        Version version = this.getVersion(node, "version", null);
        URL location = this.getURL(node, "href", this.base);
        String vmArgs = this.getAttribute(node, "java-vm-args", null);
        try {
            this.checkVMArgs(vmArgs);
        }
        catch (IllegalArgumentException argumentException) {
            vmArgs = null;
        }
        String initialHeap = this.getAttribute(node, "initial-heap-size", null);
        String maxHeap = this.getAttribute(node, "max-heap-size", null);
        List<ResourcesDesc> resources = this.getResources(node, true);
        this.getRequiredAttribute(node, "version", null);
        return new JREDesc(version, location, vmArgs, initialHeap, maxHeap, resources);
    }

    public JARDesc getJAR(Node node) throws ParseException {
        boolean nativeJar = "nativelib".equals(node.getNodeName());
        URL location = this.getRequiredURL(node, "href", this.base);
        Version version = this.getVersion(node, "version", null);
        String part = this.getAttribute(node, "part", null);
        boolean main = "true".equals(this.getAttribute(node, "main", "false"));
        boolean lazy = "lazy".equals(this.getAttribute(node, "download", "eager"));
        if (nativeJar && main && this.strict) {
            throw new ParseException(Translator.R("PNativeHasMain"));
        }
        return new JARDesc(location, version, part, lazy, main, nativeJar, true);
    }

    public ExtensionDesc getExtension(Node node) throws ParseException {
        String name = this.getAttribute(node, "name", null);
        Version version = this.getVersion(node, "version", null);
        URL location = this.getRequiredURL(node, "href", this.base);
        ExtensionDesc ext = new ExtensionDesc(name, version, location);
        Node[] dload = Parser.getChildNodes(node, "ext-download");
        for (int i = 0; i < dload.length; ++i) {
            boolean lazy = "lazy".equals(this.getAttribute(dload[i], "download", "eager"));
            ext.addPart(this.getRequiredAttribute(dload[i], "ext-part", null), this.getAttribute(dload[i], "part", null), lazy);
        }
        return ext;
    }

    public PropertyDesc getProperty(Node node) throws ParseException {
        String name = this.getRequiredAttribute(node, "name", null);
        String value = this.getRequiredAttribute(node, "value", "");
        return new PropertyDesc(name, value);
    }

    public PackageDesc getPackage(Node node) throws ParseException {
        String name = this.getRequiredAttribute(node, "name", null);
        String part = this.getRequiredAttribute(node, "part", "");
        boolean recursive = this.getAttribute(node, "recursive", "false").equals("true");
        return new PackageDesc(name, part, recursive);
    }

    void checkForInformation() throws RequiredElementException {
        OutputController.getLogger().log("Homepage: " + this.file.getInformation().getHomepage());
        OutputController.getLogger().log("Description: " + this.file.getInformation().getDescription());
        String title = this.file.getTitle();
        String vendor = this.file.getVendor();
        if (title == null || title.trim().isEmpty()) {
            throw new MissingTitleException();
        }
        OutputController.getLogger().log("Acceptable title tag found, contains: " + title);
        if (vendor == null || vendor.trim().isEmpty()) {
            throw new MissingVendorException();
        }
        OutputController.getLogger().log("Acceptable vendor tag found, contains: " + vendor);
    }

    public List<InformationDesc> getInfo(Node parent) throws ParseException {
        ArrayList<InformationDesc> result = new ArrayList<InformationDesc>();
        Node[] info = Parser.getChildNodes(parent, "information");
        if (info.length == 0) {
            throw new MissingInformationException();
        }
        for (Node infoNode : info) {
            result.add(this.getInformationDesc(infoNode));
        }
        return result;
    }

    public InformationDesc getInformationDesc(Node node) throws ParseException {
        ArrayList<String> descriptionsUsed = new ArrayList<String>();
        Locale[] locales = this.getLocales(node);
        InformationDesc info = new InformationDesc(locales);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("title".equals(name)) {
                this.addInfo(info, child, null, this.getSpanText(child, false));
            }
            if ("vendor".equals(name)) {
                this.addInfo(info, child, null, this.getSpanText(child, false));
            }
            if ("description".equals(name)) {
                String kind = this.getAttribute(child, "kind", "default");
                if (descriptionsUsed.contains(kind) && this.strict) {
                    throw new ParseException(Translator.R("PTwoDescriptions", kind));
                }
                descriptionsUsed.add(kind);
                this.addInfo(info, child, kind, this.getSpanText(child, false));
            }
            if ("homepage".equals(name)) {
                this.addInfo(info, child, null, this.getRequiredURL(child, "href", this.base));
            }
            if ("icon".equals(name)) {
                this.addInfo(info, child, this.getAttribute(child, "kind", "default"), this.getIcon(child));
            }
            if ("offline-allowed".equals(name)) {
                this.addInfo(info, child, null, Boolean.TRUE);
            }
            if ("sharing-allowed".equals(name)) {
                if (this.strict && !this.allowExtensions) {
                    throw new ParseException(Translator.R("PSharing"));
                }
                this.addInfo(info, child, null, Boolean.TRUE);
            }
            if ("association".equals(name)) {
                this.addInfo(info, child, null, this.getAssociation(child));
            }
            if ("shortcut".equals(name)) {
                this.addInfo(info, child, null, this.getShortcut(child));
            }
            if (!"related-content".equals(name)) continue;
            this.addInfo(info, child, null, this.getRelatedContent(child));
        }
        return info;
    }

    protected void addInfo(InformationDesc info, Node node, String mod, Object value) {
        String modStr;
        String string = modStr = mod == null ? "" : "-" + mod;
        if (node == null) {
            return;
        }
        info.addItem(node.getNodeName() + modStr, value);
    }

    public IconDesc getIcon(Node node) throws ParseException {
        int width = Integer.parseInt(this.getAttribute(node, "width", "-1"));
        int height = Integer.parseInt(this.getAttribute(node, "height", "-1"));
        int size = Integer.parseInt(this.getAttribute(node, "size", "-1"));
        int depth = Integer.parseInt(this.getAttribute(node, "depth", "-1"));
        URL location = this.getRequiredURL(node, "href", this.base);
        String kind = this.getAttribute(node, "kind", "default");
        return new IconDesc(location, kind, width, height, depth, size);
    }

    public SecurityDesc getSecurity(Node parent) throws ParseException {
        Node[] nodes = Parser.getChildNodes(parent, "security");
        if (nodes.length > 1 && this.strict) {
            throw new ParseException(Translator.R("PTwoSecurity"));
        }
        Object type = SecurityDesc.SANDBOX_PERMISSIONS;
        SecurityDesc.RequestedPermissionLevel requestedPermissionLevel = SecurityDesc.RequestedPermissionLevel.NONE;
        if (nodes.length == 0) {
            type = SecurityDesc.SANDBOX_PERMISSIONS;
            requestedPermissionLevel = SecurityDesc.RequestedPermissionLevel.NONE;
        } else if (null != Parser.getChildNode(nodes[0], "all-permissions")) {
            type = SecurityDesc.ALL_PERMISSIONS;
            requestedPermissionLevel = SecurityDesc.RequestedPermissionLevel.ALL;
        } else if (null != Parser.getChildNode(nodes[0], "j2ee-application-client-permissions")) {
            type = SecurityDesc.J2EE_PERMISSIONS;
            requestedPermissionLevel = SecurityDesc.RequestedPermissionLevel.J2EE;
        } else if (this.strict) {
            throw new ParseException(Translator.R("PEmptySecurity"));
        }
        if (this.base != null) {
            return new SecurityDesc(this.file, requestedPermissionLevel, type, this.base.getHost());
        }
        return new SecurityDesc(this.file, requestedPermissionLevel, type, null);
    }

    protected boolean isTrustedEnvironment() {
        Node security = Parser.getChildNode(this.root, "security");
        return security != null && (Parser.getChildNode(security, "all-permissions") != null || Parser.getChildNode(security, "j2ee-application-client-permissions") != null);
    }

    public LaunchDesc getLauncher(Node parent) throws ParseException {
        if (1 < Parser.getChildNodes(parent, "applet-desc").length + Parser.getChildNodes(parent, "application-desc").length + Parser.getChildNodes(parent, "installer-desc").length) {
            throw new ParseException(Translator.R("PTwoDescriptors"));
        }
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("applet-desc".equals(name)) {
                return this.getApplet(child);
            }
            if ("application-desc".equals(name)) {
                return this.getApplication(child);
            }
            if (!"installer-desc".equals(name)) continue;
            return this.getInstaller(child);
        }
        return null;
    }

    public AppletDesc getApplet(Node node) throws ParseException {
        String name = this.getRequiredAttribute(node, "name", Translator.R("PUnknownApplet"));
        String main = this.getRequiredAttribute(node, "main-class", null);
        URL docbase = this.getURL(node, "documentbase", this.base);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        int width = 0;
        int height = 0;
        try {
            width = Integer.parseInt(this.getRequiredAttribute(node, "width", "100"));
            height = Integer.parseInt(this.getRequiredAttribute(node, "height", "100"));
        }
        catch (NumberFormatException nfe) {
            if (width <= 0) {
                throw new ParseException(Translator.R("PBadWidth"));
            }
            throw new ParseException(Translator.R("PBadWidth"));
        }
        Node[] params = Parser.getChildNodes(node, "param");
        for (int i = 0; i < params.length; ++i) {
            paramMap.put(this.getRequiredAttribute(params[i], "name", null), this.getRequiredAttribute(params[i], "value", ""));
        }
        return new AppletDesc(name, main, docbase, width, height, paramMap);
    }

    public ApplicationDesc getApplication(Node node) throws ParseException {
        String main = this.getAttribute(node, "main-class", null);
        ArrayList<String> argsList = new ArrayList<String>();
        Node[] args = Parser.getChildNodes(node, "argument");
        for (int i = 0; i < args.length; ++i) {
            argsList.add(this.getSpanText(args[i]));
        }
        String[] argStrings = argsList.toArray(new String[argsList.size()]);
        return new ApplicationDesc(main, argStrings);
    }

    public ComponentDesc getComponent(Node parent) throws ParseException {
        if (1 < Parser.getChildNodes(parent, "component-desc").length) {
            throw new ParseException(Translator.R("PTwoDescriptors"));
        }
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if (!"component-desc".equals(name)) continue;
            return new ComponentDesc();
        }
        return null;
    }

    public InstallerDesc getInstaller(Node node) {
        String main = this.getAttribute(node, "main-class", null);
        return new InstallerDesc(main);
    }

    public AssociationDesc getAssociation(Node node) throws ParseException {
        String[] extensions = this.getRequiredAttribute(node, "extensions", null).split(" ");
        String mimeType = this.getRequiredAttribute(node, "mime-type", null);
        return new AssociationDesc(mimeType, extensions);
    }

    public ShortcutDesc getShortcut(Node node) throws ParseException {
        String online = this.getAttribute(node, "online", "true");
        boolean shortcutIsOnline = Boolean.valueOf(online);
        boolean showOnDesktop = false;
        MenuDesc menu = null;
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("desktop".equals(name)) {
                if (showOnDesktop && this.strict) {
                    throw new ParseException(Translator.R("PTwoDesktops"));
                }
                showOnDesktop = true;
                continue;
            }
            if (!"menu".equals(name)) continue;
            if (menu != null && this.strict) {
                throw new ParseException(Translator.R("PTwoMenus"));
            }
            menu = this.getMenu(child);
        }
        ShortcutDesc shortcut = new ShortcutDesc(shortcutIsOnline, showOnDesktop);
        if (menu != null) {
            shortcut.addMenu(menu);
        }
        return shortcut;
    }

    public MenuDesc getMenu(Node node) {
        String subMenu = this.getAttribute(node, "submenu", null);
        return new MenuDesc(subMenu);
    }

    public RelatedContentDesc getRelatedContent(Node node) throws ParseException {
        this.getRequiredAttribute(node, "href", null);
        URL location = this.getURL(node, "href", this.base);
        String title = null;
        String description = null;
        IconDesc icon = null;
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("title".equals(name)) {
                if (title != null && this.strict) {
                    throw new ParseException(Translator.R("PTwoTitles"));
                }
                title = this.getSpanText(child, false);
                continue;
            }
            if ("description".equals(name)) {
                if (description != null && this.strict) {
                    throw new ParseException(Translator.R("PTwoDescriptions"));
                }
                description = this.getSpanText(child, false);
                continue;
            }
            if (!"icon".equals(name)) continue;
            if (icon != null && this.strict) {
                throw new ParseException(Translator.R("PTwoIcons"));
            }
            icon = this.getIcon(child);
        }
        RelatedContentDesc relatedContent = new RelatedContentDesc(location);
        relatedContent.setDescription(description);
        relatedContent.setIconDesc(icon);
        relatedContent.setTitle(title);
        return relatedContent;
    }

    public String[] splitString(String source) {
        if (source == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(source, " ");
        StringBuilder part = new StringBuilder();
        while (st.hasMoreTokens()) {
            part.setLength(0);
            while (true) {
                part.append(st.nextToken());
                if (!st.hasMoreTokens() || part.charAt(part.length() - 1) != '\\') break;
                part.setCharAt(part.length() - 1, ' ');
            }
            int i = part.length();
            while (i-- > 0) {
                if (part.charAt(i) != '\\') continue;
                part.deleteCharAt(i--);
            }
            result.add(part.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public Locale[] getLocales(Node node) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        String[] localeParts = this.splitString(this.getAttribute(node, "locale", ""));
        for (int i = 0; i < localeParts.length; ++i) {
            Locale l = this.getLocale(localeParts[i]);
            if (l == null) continue;
            locales.add(l);
        }
        return locales.toArray(new Locale[locales.size()]);
    }

    public Locale getLocale(String localeStr) {
        if (localeStr.length() < 2) {
            return null;
        }
        String language = localeStr.substring(0, 2);
        String country = localeStr.length() < 5 ? "" : localeStr.substring(3, 5);
        String variant = localeStr.length() > 7 ? localeStr.substring(6) : "";
        return new Locale(language, country, variant);
    }

    public String getSpanText(Node node) throws ParseException {
        return this.getSpanText(node, true);
    }

    public String getSpanText(Node node, boolean preserveSpacing) throws ParseException {
        if (node == null) {
            return null;
        }
        String val = node.getNodeValue();
        if (preserveSpacing) {
            return val;
        }
        if (val == null) {
            return null;
        }
        return val.replaceAll("\\s+", " ");
    }

    public static Node getChildNode(Node node, String name) {
        Node[] result = Parser.getChildNodes(node, name);
        if (result.length == 0) {
            return null;
        }
        return result[0];
    }

    public static Node[] getChildNodes(Node node, String name) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result.toArray(new Node[result.size()]);
    }

    private URL addSlash(URL source) {
        if (source == null) {
            return null;
        }
        if (!source.toString().endsWith("/")) {
            try {
                source = new URL(source.toString() + "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return source;
    }

    public URL getRequiredURL(Node node, String name, URL base) throws ParseException {
        this.getRequiredAttribute(node, name, "");
        return this.getURL(node, name, base);
    }

    /*
     * Loose catch block
     */
    public URL getURL(Node node, String name, URL base) throws ParseException {
        String href;
        block11: {
            href = null;
            if (CODEBASE.equals(name)) {
                href = this.getCleanAttribute(node, name);
                if (href != null && href.trim().isEmpty()) {
                    href = ".";
                }
            } else {
                href = this.getAttribute(node, name, null);
            }
            if (href == null) {
                return null;
            }
            if (base != null) break block11;
            return new URL(href);
            {
                catch (MalformedURLException ex) {
                    if (base == null) {
                        throw new ParseException(Translator.R("PBadNonrelativeUrl", node.getNodeName(), href));
                    }
                    throw new ParseException(Translator.R("PBadRelativeUrl", node.getNodeName(), href, base));
                }
            }
        }
        try {
            return new URL(href);
        }
        catch (MalformedURLException malformedURLException) {
            URL result = new URL(base, href);
            if (!result.toString().startsWith(base.toString()) && !base.toString().startsWith(result.toString()) && this.strict) {
                throw new ParseException(Translator.R("PUrlNotInCodebase", node.getNodeName(), href, base));
            }
            return result;
        }
    }

    public Version getVersion(Node node, String name, String defaultValue) {
        String version = this.getAttribute(node, name, defaultValue);
        if (version == null) {
            return null;
        }
        return new Version(version);
    }

    private void checkVMArgs(String vmArgs) throws IllegalArgumentException {
        if (vmArgs == null) {
            return;
        }
        List<String> validArguments = Arrays.asList(this.getValidVMArguments());
        List<String> validStartingArguments = Arrays.asList(this.getValidStartingVMArguments());
        String[] arguments = vmArgs.split(" ");
        boolean argumentIsValid = false;
        for (String argument : arguments) {
            argumentIsValid = false;
            if (validArguments.contains(argument)) {
                argumentIsValid = true;
            } else {
                for (String validStartingArgument : validStartingArguments) {
                    if (!argument.startsWith(validStartingArgument)) continue;
                    argumentIsValid = true;
                    break;
                }
            }
            if (argumentIsValid) continue;
            throw new IllegalArgumentException(argument);
        }
    }

    private String[] getValidVMArguments() {
        return new String[]{"-d32", "-client", "-server", "-verbose", "-version", "-showversion", "-help", "-X", "-ea", "-enableassertions", "-da", "-disableassertions", "-esa", "-enablesystemassertions", "-dsa", "-disablesystemassertions", "-Xmixed", "-Xint", "-Xnoclassgc", "-Xincgc", "-Xbatch", "-Xprof", "-Xdebug", "-Xfuture", "-Xrs", "-XX:+ForceTimeHighResolution", "-XX:-ForceTimeHighResolution"};
    }

    private String[] getValidStartingVMArguments() {
        return new String[]{"-ea", "-enableassertions", "-da", "-disableassertions", "-verbose", "-Xms", "-Xmx", "-Xss", "-XX:NewRatio", "-XX:NewSize", "-XX:MaxNewSize", "-XX:PermSize", "-XX:MaxPermSize", "-XX:MaxHeapFreeRatio", "-XX:MinHeapFreeRatio", "-XX:UseSerialGC", "-XX:ThreadStackSize", "-XX:MaxInlineSize", "-XX:ReservedCodeCacheSize", "-XX:MaxDirectMemorySize"};
    }

    public String getRequiredAttribute(Node node, String name, String defaultValue) throws ParseException {
        String result = this.getAttribute(node, name, null);
        if (!(result != null && result.length() != 0 || !this.strict && defaultValue != null)) {
            throw new ParseException(Translator.R("PNeedsAttribute", node.getNodeName(), name));
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public String getAttribute(Node node, String name, String defaultValue) {
        String result = this.getCleanAttribute(node, name);
        if (result == null || result.length() == 0) {
            return defaultValue;
        }
        return result;
    }

    private String getCleanAttribute(Node node, String name) {
        String result = node.getAttribute(name);
        return result;
    }

    public static Node getRootNode(InputStream input, ParserSettings settings) throws ParseException {
        String className = null;
        className = settings.isMalformedXmlAllowed() ? "net.sourceforge.jnlp.MalformedXMLParser" : "net.sourceforge.jnlp.XMLParser";
        try {
            Class<?> klass = null;
            try {
                klass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                klass = Class.forName("net.sourceforge.jnlp.XMLParser");
            }
            Object instance = klass.newInstance();
            Method m = klass.getMethod("getRootNode", InputStream.class);
            return (Node)m.invoke(instance, input);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ParseException) {
                throw (ParseException)e.getCause();
            }
            throw new ParseException(Translator.R("PBadXML"), e);
        }
        catch (Exception e) {
            throw new ParseException(Translator.R("PBadXML"), e);
        }
    }
}

