/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import sun.applet.PluginDebug;

public class MethodOverloadResolver {
    static final int NUMERIC_SAME_COST = 1;
    static final int NULL_TO_OBJECT_COST = 2;
    static final int CLASS_SAME_COST = 3;
    static final int NUMERIC_CAST_COST = 4;
    static final int NUMERIC_BOOLEAN_COST = 5;
    static final int STRING_NUMERIC_CAST_COST = 5;
    static final int CLASS_SUPERCLASS_COST = 6;
    static final int CLASS_STRING_COST = 7;
    static final int ARRAY_CAST_COST = 8;

    public static ResolvedMethod getBestMatchMethod(Class<?> c, String methodName, Object[] args) {
        AccessibleObject[] matchingMethods = MethodOverloadResolver.getMatchingMethods(c, methodName, args.length);
        if (PluginDebug.DEBUG) {
            PluginDebug.debug("getMatchingMethod called with: " + Arrays.toString(args));
        }
        return MethodOverloadResolver.getBestOverloadMatch(c, args, matchingMethods);
    }

    public static ResolvedMethod getBestMatchConstructor(Class<?> c, Object[] args) {
        AccessibleObject[] matchingConstructors = MethodOverloadResolver.getMatchingConstructors(c, args.length);
        if (PluginDebug.DEBUG) {
            PluginDebug.debug("getMatchingConstructor called with: " + Arrays.toString(args));
        }
        return MethodOverloadResolver.getBestOverloadMatch(c, args, matchingConstructors);
    }

    static ResolvedMethod getBestOverloadMatch(Class<?> c, Object[] args, AccessibleObject[] candidates) {
        int lowestCost = Integer.MAX_VALUE;
        AccessibleObject cheapestMethod = null;
        Object[] cheapestArgs = null;
        boolean ambiguous = false;
        block0: for (AccessibleObject candidate : candidates) {
            int methodCost = 0;
            Class<?>[] paramTypes = MethodOverloadResolver.getParameterTypesFor(candidate);
            Object[] castedArgs = new Object[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                Object castedObj;
                Class<?> paramTypeClass = paramTypes[i];
                Object suppliedParam = args[i];
                Class<?> suppliedParamClass = suppliedParam != null ? suppliedParam.getClass() : null;
                WeightedCast weightedCast = MethodOverloadResolver.getCostAndCastedObject(suppliedParam, paramTypeClass);
                if (weightedCast == null) continue block0;
                methodCost += weightedCast.getCost();
                castedArgs[i] = castedObj = paramTypeClass.isPrimitive() ? weightedCast.getCastedObject() : paramTypeClass.cast(weightedCast.getCastedObject());
                if (!PluginDebug.DEBUG) continue;
                Class<?> castedObjClass = castedObj == null ? null : castedObj.getClass();
                boolean castedObjIsPrim = castedObj == null ? false : castedObj.getClass().isPrimitive();
                PluginDebug.debug("Param " + i + " of method " + candidate + " has cost " + weightedCast.getCost() + " original param type " + suppliedParamClass + " casted to " + castedObjClass + " isPrimitive=" + castedObjIsPrim + " value " + castedObj);
            }
            if (methodCost > lowestCost) continue;
            if (methodCost < lowestCost || MethodOverloadResolver.argumentsAreSubclassesOf(castedArgs, cheapestArgs)) {
                lowestCost = methodCost;
                cheapestArgs = castedArgs;
                cheapestMethod = candidate;
                ambiguous = false;
                continue;
            }
            ambiguous = true;
        }
        if (ambiguous) {
            PluginDebug.debug("*** Warning: Ambiguous overload of ", c.getClass(), "#", cheapestMethod, "!");
        }
        if (cheapestMethod == null) {
            return null;
        }
        return new ResolvedMethod(lowestCost, cheapestMethod, cheapestArgs);
    }

    public static WeightedCast getCostAndCastedObject(Object suppliedParam, Class<?> paramTypeClass) {
        boolean wrapsPrimitive;
        boolean suppliedParamIsArray;
        Class<?> suppliedParamClass = suppliedParam != null ? suppliedParam.getClass() : null;
        boolean bl = suppliedParamIsArray = suppliedParamClass != null && suppliedParamClass.isArray();
        if (suppliedParamIsArray) {
            if (paramTypeClass.isArray()) {
                return MethodOverloadResolver.getArrayToArrayCastWeightedCost(suppliedParam, paramTypeClass);
            }
            if (paramTypeClass != String.class && paramTypeClass != Object.class) {
                return null;
            }
            if (paramTypeClass.equals(String.class)) {
                return new WeightedCast(8, MethodOverloadResolver.arrayToJavascriptStyleString(suppliedParam));
            }
        }
        if (suppliedParamClass == null) {
            if (!paramTypeClass.isPrimitive()) {
                return new WeightedCast(2, null);
            }
            return null;
        }
        if (paramTypeClass.isPrimitive() && paramTypeClass == MethodOverloadResolver.getPrimitiveType(suppliedParam.getClass())) {
            return new WeightedCast(1, suppliedParam);
        }
        if (suppliedParamClass == paramTypeClass) {
            return new WeightedCast(3, suppliedParam);
        }
        boolean bl2 = wrapsPrimitive = MethodOverloadResolver.getPrimitiveType(suppliedParam.getClass()) != null;
        if (wrapsPrimitive && paramTypeClass.isPrimitive()) {
            Object castedObj;
            double val = suppliedParam.equals(Boolean.TRUE) ? 1.0 : (suppliedParam.equals(Boolean.FALSE) ? 0.0 : (suppliedParam instanceof Character ? (double)((Character)suppliedParam).charValue() : ((Number)suppliedParam).doubleValue()));
            int castCost = 4;
            if (paramTypeClass.equals(Boolean.TYPE)) {
                castedObj = val != 0.0 && !Double.isNaN(val);
                if (suppliedParam.getClass() != Boolean.class) {
                    castCost = 5;
                }
            } else {
                castedObj = MethodOverloadResolver.toBoxedPrimitiveType(val, paramTypeClass);
            }
            return new WeightedCast(castCost, castedObj);
        }
        if (MethodOverloadResolver.isNumericString(suppliedParam) && paramTypeClass.isPrimitive()) {
            Object castedObj = paramTypeClass.equals(Character.TYPE) ? Character.valueOf((char)Short.decode((String)suppliedParam).shortValue()) : MethodOverloadResolver.stringAsPrimitiveType((String)suppliedParam, paramTypeClass);
            return new WeightedCast(5, castedObj);
        }
        if (suppliedParam instanceof String && (paramTypeClass == Boolean.class || paramTypeClass == Boolean.TYPE)) {
            return new WeightedCast(5, !suppliedParam.equals(""));
        }
        if (paramTypeClass.isAssignableFrom(suppliedParamClass)) {
            return new WeightedCast(6, paramTypeClass.cast(suppliedParam));
        }
        if (paramTypeClass.equals(String.class)) {
            return new WeightedCast(7, suppliedParam.toString());
        }
        return null;
    }

    private static WeightedCast getArrayToArrayCastWeightedCost(Object suppliedArray, Class<?> paramTypeClass) {
        int arrLength = Array.getLength(suppliedArray);
        Class<?> arrType = paramTypeClass.getComponentType();
        Object newArray = Array.newInstance(arrType, arrLength);
        for (int i = 0; i < arrLength; ++i) {
            WeightedCast costAndCastedObject;
            Object original = Array.get(suppliedArray, i);
            if (original == null && arrType.isPrimitive()) {
                original = 0;
            }
            if ((costAndCastedObject = MethodOverloadResolver.getCostAndCastedObject(original, paramTypeClass.getComponentType())) == null) {
                return null;
            }
            Array.set(newArray, i, costAndCastedObject.getCastedObject());
        }
        return new WeightedCast(8, newArray);
    }

    private static Method[] getMatchingMethods(Class<?> c, String name, int paramCount) {
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (Method m : c.getMethods()) {
            if (!m.getName().equals(name) || m.getParameterTypes().length != paramCount) continue;
            matchingMethods.add(m);
        }
        return matchingMethods.toArray(new Method[0]);
    }

    private static Constructor<?>[] getMatchingConstructors(Class<?> c, int paramCount) {
        ArrayList matchingConstructors = new ArrayList();
        for (Constructor<?> cs : c.getConstructors()) {
            if (cs.getParameterTypes().length != paramCount) continue;
            matchingConstructors.add(cs);
        }
        return matchingConstructors.toArray(new Constructor[0]);
    }

    private static Class<?> getPrimitiveType(Class<?> c) {
        if (c.isPrimitive()) {
            return c;
        }
        if (c == Byte.class) {
            return Byte.TYPE;
        }
        if (c == Character.class) {
            return Character.TYPE;
        }
        if (c == Short.class) {
            return Short.TYPE;
        }
        if (c == Integer.class) {
            return Integer.TYPE;
        }
        if (c == Long.class) {
            return Long.TYPE;
        }
        if (c == Float.class) {
            return Float.TYPE;
        }
        if (c == Double.class) {
            return Double.TYPE;
        }
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        return null;
    }

    private static boolean isNumericString(Object o) {
        if (!(o instanceof String)) {
            return false;
        }
        try {
            Long.parseLong((String)o);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Float.parseFloat((String)o);
                return true;
            }
            catch (NumberFormatException numberFormatException2) {
                return false;
            }
        }
    }

    private static Object toBoxedPrimitiveType(double val, Class<?> c) {
        Class<?> prim = MethodOverloadResolver.getPrimitiveType(c);
        if (prim == Integer.TYPE) {
            return (int)val;
        }
        if (prim == Long.TYPE) {
            return (long)val;
        }
        if (prim == Short.TYPE) {
            return (short)val;
        }
        if (prim == Float.TYPE) {
            return Float.valueOf((float)val);
        }
        if (prim == Double.TYPE) {
            return val;
        }
        if (prim == Byte.TYPE) {
            return (byte)val;
        }
        if (prim == Character.TYPE) {
            return Character.valueOf((char)val);
        }
        return val;
    }

    private static Object stringAsPrimitiveType(String s, Class<?> c) throws NumberFormatException {
        double val = Double.parseDouble(s);
        return MethodOverloadResolver.toBoxedPrimitiveType(val, c);
    }

    private static boolean argumentsAreSubclassesOf(Object[] args, Object[] testArgs) {
        for (int i = 0; i < args.length; ++i) {
            if (testArgs[i].getClass().isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }

    static Class<?>[] getParameterTypesFor(AccessibleObject method) {
        if (method instanceof Method) {
            return ((Method)method).getParameterTypes();
        }
        return ((Constructor)method).getParameterTypes();
    }

    private static String arrayToJavascriptStyleString(Object array) {
        int arrLength = Array.getLength(array);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arrLength; ++i) {
            Object element = Array.get(array, i);
            if (element != null) {
                if (element.getClass().isArray()) {
                    sb.append(MethodOverloadResolver.arrayToJavascriptStyleString(element));
                } else {
                    sb.append(element);
                }
            }
            sb.append(',');
        }
        if (arrLength > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    static class WeightedCast {
        private int cost;
        private Object castedObject;

        public WeightedCast(int cost, Object castedObject) {
            this.cost = cost;
            this.castedObject = castedObject;
        }

        public Object getCastedObject() {
            return this.castedObject;
        }

        public int getCost() {
            return this.cost;
        }
    }

    static class ResolvedMethod {
        private AccessibleObject method;
        private Object[] castedParameters;
        private int cost;

        public ResolvedMethod(int cost, AccessibleObject method, Object[] castedParameters) {
            this.cost = cost;
            this.method = method;
            this.castedParameters = castedParameters;
        }

        AccessibleObject getAccessibleObject() {
            return this.method;
        }

        public Method getMethod() {
            return (Method)this.method;
        }

        public Constructor<?> getConstructor() {
            return (Constructor)this.method;
        }

        public Object[] getCastedParameters() {
            return this.castedParameters;
        }

        public int getCost() {
            return this.cost;
        }
    }
}

