#!/bin/sh
export PATH='/usr/obj/hs-dbus-0.10.10/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: dbus
version: 0.10.10
id: dbus-0.10.10-83cdbfe2263338f5d8a1674f1592077e

license: GPL-3
copyright:
maintainer: John Millikin <john@john-millikin.com>
stability: experimental
homepage: https://john-millikin.com/software/haskell-dbus/
package-url:
synopsis: A client library for the D-Bus IPC system.
description: D-Bus is a simple, message-based protocol for inter-process
             communication, which allows applications to interact with other parts of
             the machine and the user'\''s session using remote procedure calls.
             .
             D-Bus is a essential part of the modern Linux desktop, where it replaces
             earlier protocols such as CORBA and DCOP.
             .
             This library is an implementation of the D-Bus protocol in Haskell. It
             can be used to add D-Bus support to Haskell applications, without the
             awkward interfaces common to foreign bindings.
             .
             Example: connect to the session bus, and get a list of active names.
             .
             @
             &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
             .
             import Data.List (sort)
             import DBus
             import DBus.Client
             .
             main = do
             &#x20;   client <- connectSession
             &#x20;   //
             &#x20;   \-- Request a list of connected clients from the bus
             &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
             &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
             &#x20;       &#x7d;
             &#x20;   //
             &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
             &#x20;   \-- a list of names (here represented as [String])
             &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
             &#x20;   //
             &#x20;   \-- Print each name on a line, sorted so reserved names are below
             &#x20;   \-- temporary names.
             &#x20;   mapM_ putStrLn (sort names)
             @
             .
             >$ ghc --make list-names.hs
             >$ ./list-names
             >:1.0
             >:1.1
             >:1.10
             >:1.106
             >:1.109
             >:1.110
             >ca.desrt.dconf
             >org.freedesktop.DBus
             >org.freedesktop.Notifications
             >org.freedesktop.secrets
             >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <john@john-millikin.com>
pkgpath: x11/hs-dbus
exposed: True
exposed-modules: DBus DBus.Client DBus.Introspection DBus.Socket
                 DBus.Transport
hidden-modules: DBus.Address DBus.Message DBus.Types DBus.Wire
trusted: False
import-dirs: /usr/local/lib/ghc/dbus-0.10.10
library-dirs: /usr/local/lib/ghc/dbus-0.10.10
hs-libraries: HSdbus-0.10.10
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         cereal-0.4.1.0-9d42a4c31bc1d35f6a410f5e79e67215
         containers-0.5.5.1-d4bd887fb97aa3a46cbadc13709b7653
         libxml-sax-0.7.5-590dd24d99e22068cb2f44fcb349f590
         network-2.4.2.3-878f8bfcc369ed62265df39b168036b0
         parsec-3.1.5-7f6674da593b27c3fdd904274a0dcd1e
         random-1.0.1.1-18033e0e7d0ae09dc4f8adbdce56b966
         text-1.1.0.0-72236c81391c0a9a303f37559690d8fe
         transformers-0.3.0.0-6458c21515cab7c1cf21e53141557a1c
         unix-2.7.0.1-49291e6beb52ca8844af5af8283d8383
         vector-0.10.9.1-1010d9fb05d5cbdd0bbbccafb8c8b174
         xml-types-0.3.6-fc8bb242aedf216e5a0c41a863029711
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-dbus-0.10.10/html/dbus.haddock
haddock-html: /usr/local/share/doc/hs-dbus-0.10.10/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
