#!/bin/sh
export PATH='/usr/obj/hs-aeson-0.7.0.6/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: aeson
version: 0.7.0.6
id: aeson-0.7.0.6-0698e906fb65f23b5c5009884c99d843

license: BSD3
copyright: (c) 2011-2014 Bryan O'\''Sullivan
           (c) 2011 MailRank, Inc.
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability: experimental
homepage: https://github.com/bos/aeson
package-url:
synopsis: Fast JSON parsing and encoding
description: A JSON parsing and encoding library optimized for ease of use
             and high performance.
             .
             To get started, see the documentation for the @Data.Aeson@ module
             below.
             .
             Parsing performance on an early 2011 MacBook Pro (2.2GHz Core i7),
             running 64-bit GHC 7.6.3, for mostly-English tweets from Twitter'\''s
             JSON search API:
             .
             * 0.8 KB: 34124 msg\/sec (27.8 MB\/sec)
             .
             * 6.4 KB: 6833 msg\/sec (43.0 MB\/sec)
             .
             * 11.8 KB: 3410 msg\/sec (39.2 MB\/sec)
             .
             * 31.2 KB: 1157 msg\/sec (35.3 MB\/sec)
             .
             * 61.5 KB: 542 msg\/sec (32.5 MB\/sec)
             .
             Handling heavily-escaped text is a little more work.  Here is
             parsing performance with Japanese tweets, where much of the text
             is entirely Unicode-escaped.
             .
             * 14.6 KB: 2101 msg\/sec (30.0 MB\/sec)
             .
             * 44.1 KB: 667 msg\/sec (28.7 MB\/sec)
             .
             * 82.9 KB: 360 msg\/sec (29.2 MB\/sec)
             .
             Encoding performance on the same machine and data:
             .
             * English, 0.8 KB: 109697 msg\/sec (89.3 MB\/sec)
             .
             * English, 6.4 KB: 18517 msg\/sec (116.4 MB\/sec)
             .
             * Engish, 61.5 KB: 1963 msg\/sec (118.0 MB\/sec)
             .
             * Japanese, 14.6 KB: 12140 msg\/sec (173.5 MB\/sec)
             .
             * Japanese, 44.1 KB: 3980 msg\/sec (171.3 MB\/sec)
             .
             (A note on naming: in Greek mythology, Aeson was the father of Jason.)
category: Text, Web, JSON
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-aeson
exposed: True
exposed-modules: Data.Aeson Data.Aeson.Encode Data.Aeson.Generic
                 Data.Aeson.Parser Data.Aeson.Types Data.Aeson.TH
hidden-modules: Data.Aeson.Functions Data.Aeson.Parser.Internal
                Data.Aeson.Types.Class Data.Aeson.Types.Instances
                Data.Aeson.Types.Internal Data.Aeson.Encode.ByteString
                Data.Aeson.Types.Generic
trusted: False
import-dirs: /usr/local/lib/ghc/aeson-0.7.0.6
library-dirs: /usr/local/lib/ghc/aeson-0.7.0.6
hs-libraries: HSaeson-0.7.0.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: attoparsec-0.11.3.4-38aec4777d52d2286c472e3abb229554
         base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         containers-0.5.5.1-d4bd887fb97aa3a46cbadc13709b7653
         deepseq-1.3.0.2-63a1ab91b7017a28bb5d04cb1b5d2d02
         dlist-0.5-3fd68a12144ab00dd0fa3e18bf014ce8
         ghc-prim-0.3.1.0-a24f9c14c632d75b683d0f93283aea37
         hashable-1.2.2.0-6aae2a5ae00dba4cc06a8e388409e9ed
         mtl-2.1.3.1-96f1a7910a7553352339ed05fb61c269
         old-locale-1.0.0.6-50b0125c49f76af85dc7aa22975cdc34
         scientific-0.3.3.5-eb2b1e9cf145c4f7aa3b7a8ae1edc34a
         syb-0.4.1-acd16ebc619c31f5db97bcd1e4196777
         template-haskell-2.9.0.0-c1b02d350b1eb99924a791f87d655dbd
         text-1.1.0.0-72236c81391c0a9a303f37559690d8fe
         time-1.4.2-311aa8e77a6af87dc3d662d572df62ec
         unordered-containers-0.2.4.0-2fd558fbd599b4e4c335e82ebd45f621
         vector-0.10.9.1-1010d9fb05d5cbdd0bbbccafb8c8b174
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-aeson-0.7.0.6/html/aeson.haddock
haddock-html: /usr/local/share/doc/hs-aeson-0.7.0.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
