/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import com.ibm.icu.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.Locale;

public class PropertiesValueBreakIterator
extends BreakIterator {
    private BreakIterator fParent;
    private CharacterIterator fText;

    public PropertiesValueBreakIterator(Locale locale) {
        this.fParent = BreakIterator.getWordInstance((Locale)locale);
    }

    public int current() {
        return this.correct(this.fParent.current());
    }

    public int first() {
        return this.fParent.first();
    }

    public int last() {
        return this.fParent.last();
    }

    public int next() {
        int next = this.fParent.next();
        while (!this.stopAt(next)) {
            next = this.fParent.next();
        }
        return this.correct(next);
    }

    public int previous() {
        int previous = this.fParent.previous();
        while (!this.stopAt(previous)) {
            previous = this.fParent.previous();
        }
        return this.correct(previous);
    }

    public int following(int offset) {
        int following = this.fParent.following(offset);
        while (!this.stopAt(following)) {
            following = this.fParent.following(offset);
        }
        return this.correct(following);
    }

    public int next(int n) {
        int next = this.fParent.next(n);
        while (!this.stopAt(next)) {
            next = this.fParent.next(n);
        }
        return this.correct(next);
    }

    public CharacterIterator getText() {
        return this.fParent.getText();
    }

    public void setText(CharacterIterator newText) {
        this.fText = newText;
        this.fParent.setText(newText);
    }

    private boolean stopAt(int index) {
        if (index == -1) {
            return true;
        }
        return index <= this.getBeginIndex() || index >= this.getEndIndex() - 1 || Character.isWhitespace(this.charAt(index - 1)) || Character.isWhitespace(this.charAt(index)) || this.charAt(index - 1) != '&' && this.charAt(index) != '&';
    }

    private int correct(int index) {
        if (index == -1) {
            return index;
        }
        if (index > this.getBeginIndex() && index < this.getEndIndex() - 1 && !Character.isWhitespace(this.charAt(index - 1)) && this.charAt(index - 1) == '\\') {
            return index - 1;
        }
        return index;
    }

    private char charAt(int index) {
        int oldIndex = this.fText.getIndex();
        char ch = this.fText.setIndex(index);
        this.fText.setIndex(oldIndex);
        return ch;
    }

    private int getEndIndex() {
        return this.fText.getEndIndex();
    }

    private int getBeginIndex() {
        return this.fText.getBeginIndex();
    }
}

