/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.VisibilityAssistant;
import org.eclipse.ui.internal.navigator.extensions.ExtensionPriorityComparator;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.internal.navigator.extensions.OverridePolicy;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NavigatorContentDescriptorManager {
    private static final NavigatorContentDescriptorManager INSTANCE = new NavigatorContentDescriptorManager();
    private final Map firstClassDescriptorsMap = new HashMap();
    private final Map allDescriptors = new HashMap();
    private final Map cachedTriggerPointEvaluations = new WeakHashMap();
    private final Map cachedPossibleChildrenEvaluations = new WeakHashMap();
    private ImageRegistry imageRegistry;
    private final Set overridingDescriptors = new HashSet();
    private final Set saveablesProviderDescriptors = new HashSet();
    private final Set firstClassDescriptorsSet = new HashSet();

    public static NavigatorContentDescriptorManager getInstance() {
        return INSTANCE;
    }

    private NavigatorContentDescriptorManager() {
        new NavigatorContentDescriptorRegistry().readRegistry();
    }

    public NavigatorContentDescriptor[] getAllContentDescriptors() {
        NavigatorContentDescriptor[] finalDescriptors = new NavigatorContentDescriptor[this.allDescriptors.size()];
        finalDescriptors = this.allDescriptors.values().toArray(finalDescriptors);
        Arrays.sort(finalDescriptors, ExtensionPriorityComparator.INSTANCE);
        return finalDescriptors;
    }

    public NavigatorContentDescriptor[] getContentDescriptorsWithSaveables() {
        NavigatorContentDescriptor[] finalDescriptors = new NavigatorContentDescriptor[this.saveablesProviderDescriptors.size()];
        this.saveablesProviderDescriptors.toArray(finalDescriptors);
        Arrays.sort(finalDescriptors, ExtensionPriorityComparator.INSTANCE);
        return finalDescriptors;
    }

    public Set findDescriptorsForTriggerPoint(Object anElement, VisibilityAssistant aVisibilityAssistant) {
        EvaluationCache cache = this.getEvaluationCache(this.cachedTriggerPointEvaluations, aVisibilityAssistant);
        if (cache.getDescriptors(anElement) != null) {
            return cache.getDescriptors(anElement);
        }
        TreeSet<NavigatorContentDescriptor> descriptors = new TreeSet<NavigatorContentDescriptor>(ExtensionPriorityComparator.INSTANCE);
        for (NavigatorContentDescriptor descriptor : this.firstClassDescriptorsMap.values()) {
            if (!aVisibilityAssistant.isActive(descriptor) || !aVisibilityAssistant.isVisible(descriptor) || !descriptor.isTriggerPoint(anElement)) continue;
            descriptors.add(descriptor);
        }
        cache.setDescriptors(anElement, descriptors);
        return descriptors;
    }

    private EvaluationCache getEvaluationCache(Map anEvaluationMap, VisibilityAssistant aVisibilityAssistant) {
        EvaluationCache c = (EvaluationCache)anEvaluationMap.get(aVisibilityAssistant);
        if (c == null) {
            c = new EvaluationCache(aVisibilityAssistant);
            anEvaluationMap.put(aVisibilityAssistant, c);
        }
        return c;
    }

    public Set findDescriptorsForPossibleChild(Object anElement, VisibilityAssistant aVisibilityAssistant) {
        return this.findDescriptorsForPossibleChild(anElement, aVisibilityAssistant, true);
    }

    public Set findDescriptorsForPossibleChild(Object anElement, VisibilityAssistant aVisibilityAssistant, boolean toComputeOverrides) {
        EvaluationCache cache = this.getEvaluationCache(this.cachedPossibleChildrenEvaluations, aVisibilityAssistant);
        if (cache.getDescriptors(anElement, toComputeOverrides) != null) {
            return cache.getDescriptors(anElement, toComputeOverrides);
        }
        TreeSet<NavigatorContentDescriptor> descriptors = new TreeSet<NavigatorContentDescriptor>(ExtensionPriorityComparator.INSTANCE);
        if (toComputeOverrides) {
            this.addDescriptorsForPossibleChild(anElement, this.firstClassDescriptorsSet, aVisibilityAssistant, descriptors);
        } else {
            for (NavigatorContentDescriptor descriptor : this.allDescriptors.values()) {
                boolean isApplicable;
                boolean bl = isApplicable = aVisibilityAssistant.isActive(descriptor) && aVisibilityAssistant.isVisible(descriptor) && descriptor.isPossibleChild(anElement);
                if (!isApplicable) continue;
                descriptors.add(descriptor);
            }
        }
        cache.setDescriptors(anElement, descriptors, toComputeOverrides);
        return descriptors;
    }

    private boolean addDescriptorsForPossibleChild(Object anElement, Set theChildDescriptors, VisibilityAssistant aVisibilityAssistant, Set theFoundDescriptors) {
        int initialSize = theFoundDescriptors.size();
        for (NavigatorContentDescriptor descriptor : theChildDescriptors) {
            boolean isApplicable;
            boolean bl = isApplicable = aVisibilityAssistant.isActive(descriptor) && aVisibilityAssistant.isVisible(descriptor) && descriptor.isPossibleChild(anElement);
            if (descriptor.hasOverridingExtensions()) {
                boolean isOverridden = this.addDescriptorsForPossibleChild(anElement, descriptor.getOverriddingExtensions(), aVisibilityAssistant, theFoundDescriptors);
                if (isOverridden || !isApplicable) continue;
                theFoundDescriptors.add(descriptor);
                continue;
            }
            if (!isApplicable) continue;
            theFoundDescriptors.add(descriptor);
        }
        return initialSize < theFoundDescriptors.size();
    }

    public NavigatorContentDescriptor getContentDescriptor(String id) {
        return (NavigatorContentDescriptor)this.allDescriptors.get(id);
    }

    public String getText(String descriptorId) {
        NavigatorContentDescriptor descriptor = this.getContentDescriptor(descriptorId);
        if (descriptor != null) {
            return descriptor.getName();
        }
        return descriptorId;
    }

    public Image getImage(String descriptorId) {
        return this.retrieveAndStoreImage(descriptorId);
    }

    protected Image retrieveAndStoreImage(String descriptorId) {
        ImageDescriptor imageDescriptor;
        String icon;
        NavigatorContentDescriptor contentDescriptor = this.getContentDescriptor(descriptorId);
        Image image = null;
        if (contentDescriptor != null && (icon = contentDescriptor.getIcon()) != null && ((image = this.getImageRegistry().get(icon)) == null || image.isDisposed()) && (imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)contentDescriptor.getContribution().getPluginId(), (String)icon)) != null && (image = imageDescriptor.createImage()) != null) {
            this.getImageRegistry().put(icon, image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNavigatorContentDescriptor(NavigatorContentDescriptor desc) {
        if (desc == null) {
            return;
        }
        Map map = this.firstClassDescriptorsMap;
        synchronized (map) {
            if (this.firstClassDescriptorsMap.containsKey(desc.getId())) {
                NavigatorPlugin.logError(0, "An extension already exists with id \"" + desc.getId() + "\".", null);
            } else {
                if (desc.getSuppressedExtensionId() == null) {
                    this.firstClassDescriptorsMap.put(desc.getId(), desc);
                    this.firstClassDescriptorsSet.add(desc);
                } else {
                    this.overridingDescriptors.add(desc);
                }
                this.allDescriptors.put(desc.getId(), desc);
                if (desc.hasSaveablesProvider()) {
                    this.saveablesProviderDescriptors.add(desc);
                }
            }
        }
    }

    private void computeOverrides() {
        if (this.overridingDescriptors.size() > 0) {
            for (NavigatorContentDescriptor descriptor : this.overridingDescriptors) {
                NavigatorContentDescriptor overriddenDescriptor = (NavigatorContentDescriptor)this.allDescriptors.get(descriptor.getSuppressedExtensionId());
                if (overriddenDescriptor != null) {
                    overriddenDescriptor.getOverriddingExtensions().add(descriptor);
                    descriptor.setOverriddenDescriptor(overriddenDescriptor);
                    if (descriptor.getOverridePolicy() != OverridePolicy.InvokeAlwaysRegardlessOfSuppressedExt) continue;
                    this.firstClassDescriptorsMap.put(descriptor.getId(), descriptor);
                    this.firstClassDescriptorsSet.add(descriptor);
                    continue;
                }
                NavigatorPlugin.logError(0, "Invalid suppressedExtensionId (\"" + descriptor.getSuppressedExtensionId() + "\" specified from " + descriptor.getContribution().getPluginId() + ". No extension with matching id found.", null);
            }
        }
    }

    private ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry();
        }
        return this.imageRegistry;
    }

    private class EvaluationCache
    implements VisibilityAssistant.VisibilityListener {
        private final Map evaluations = new WeakHashMap();
        private final Map evaluationsWithOverrides = new WeakHashMap();

        EvaluationCache(VisibilityAssistant anAssistant) {
            anAssistant.addListener(this);
        }

        protected final Set getDescriptors(Object anElement) {
            return this.getDescriptors(anElement, true);
        }

        protected final void setDescriptors(Object anElement, Set theDescriptors) {
            this.setDescriptors(anElement, theDescriptors, true);
        }

        protected final Set getDescriptors(Object anElement, boolean toComputeOverrides) {
            if (toComputeOverrides) {
                return (Set)this.evaluations.get(anElement);
            }
            return (Set)this.evaluationsWithOverrides.get(anElement);
        }

        protected final void setDescriptors(Object anElement, Set theDescriptors, boolean toComputeOverrides) {
            if (toComputeOverrides) {
                this.evaluations.put(anElement, theDescriptors);
            } else {
                this.evaluationsWithOverrides.put(anElement, theDescriptors);
            }
        }

        public void onVisibilityOrActivationChange() {
            this.evaluations.clear();
            this.evaluationsWithOverrides.clear();
        }
    }

    private class NavigatorContentDescriptorRegistry
    extends NavigatorContentRegistryReader {
        private NavigatorContentDescriptorRegistry() {
        }

        public void readRegistry() {
            super.readRegistry();
            NavigatorContentDescriptorManager.this.computeOverrides();
        }

        protected boolean readElement(IConfigurationElement anElement) {
            if ("navigatorContent".equals(anElement.getName())) {
                try {
                    NavigatorContentDescriptorManager.this.addNavigatorContentDescriptor(new NavigatorContentDescriptor(anElement));
                }
                catch (WorkbenchException e) {
                    NavigatorPlugin.log(e.getStatus());
                }
            }
            return super.readElement(anElement);
        }
    }
}

