/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.TeamPlugin;

public class DefaultFileModificationValidator
implements IFileModificationValidator {
    private IFileModificationValidator uiValidator;

    private IStatus getDefaultStatus(IFile file) {
        return file.isReadOnly() ? new Status(4, "org.eclipse.team.core", 279, NLS.bind((String)Messages.FileModificationValidator_fileIsReadOnly, (Object[])new String[]{file.getFullPath().toString()}), null) : Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus validateEdit(IFile[] files, Object context) {
        IFile[] readOnlyFiles = this.getReadOnly(files);
        if (readOnlyFiles.length == 0) {
            return Status.OK_STATUS;
        }
        DefaultFileModificationValidator defaultFileModificationValidator = this;
        synchronized (defaultFileModificationValidator) {
            if (this.uiValidator == null) {
                this.uiValidator = this.loadUIValidator();
            }
        }
        if (this.uiValidator != null) {
            return this.uiValidator.validateEdit(files, context);
        }
        return this.getStatus(files);
    }

    protected IStatus getStatus(IFile[] files) {
        if (files.length == 1) {
            return this.getDefaultStatus(files[0]);
        }
        Status[] stati = new Status[files.length];
        boolean allOK = true;
        int i = 0;
        while (i < files.length) {
            stati[i] = this.getDefaultStatus(files[i]);
            if (!stati[i].isOK()) {
                allOK = false;
            }
            ++i;
        }
        return new MultiStatus("org.eclipse.team.core", 0, (IStatus[])stati, allOK ? Messages.ok : Messages.FileModificationValidator_someReadOnly, null);
    }

    private IFile[] getReadOnly(IFile[] files) {
        ArrayList<IFile> result = new ArrayList<IFile>(files.length);
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            if (file.isReadOnly()) {
                result.add(file);
            }
            ++i;
        }
        return result.toArray(new IFile[result.size()]);
    }

    public IStatus validateSave(IFile file) {
        return this.getDefaultStatus(file);
    }

    private IFileModificationValidator loadUIValidator() {
        IConfigurationElement[] configElements;
        IExtension[] extensions;
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.core", "defaultFileModificationValidator");
        if (extension != null && (extensions = extension.getExtensions()).length > 0 && (configElements = extensions[0].getConfigurationElements()).length > 0) {
            try {
                Object o = configElements[0].createExecutableExtension("class");
                if (o instanceof IFileModificationValidator) {
                    return (IFileModificationValidator)o;
                }
            }
            catch (CoreException e) {
                TeamPlugin.log(e);
            }
        }
        return null;
    }
}

