/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.classpath;

import org.eclipse.jdt.internal.debug.ui.classpath.AbstractClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathGroup;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathMessages;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;

public class ClasspathModel
extends AbstractClasspathEntry {
    public static final int BOOTSTRAP = 0;
    public static final int USER = 1;
    private ClasspathGroup bootstrapEntries;
    private ClasspathGroup userEntries;

    public Object addEntry(Object entry) {
        if (entry instanceof ClasspathGroup) {
            if (!this.childEntries.contains(entry)) {
                this.childEntries.add(entry);
                return entry;
            }
            return null;
        }
        ClasspathEntry newEntry = this.createEntry((IRuntimeClasspathEntry)entry, null);
        for (Object element : this.childEntries) {
            if (!(element instanceof ClasspathGroup ? ((ClasspathGroup)element).contains(newEntry) : element.equals(newEntry))) continue;
            return null;
        }
        this.childEntries.add(newEntry);
        return newEntry;
    }

    public Object addEntry(int entryType, IRuntimeClasspathEntry entry) {
        IClasspathEntry entryParent = null;
        switch (entryType) {
            case 0: {
                entryParent = this.getBootstrapEntry();
                break;
            }
            case 1: {
                entryParent = this.getUserEntry();
                break;
            }
        }
        ClasspathEntry newEntry = this.createEntry(entry, entryParent);
        for (Object element : this.childEntries) {
            if (!(element instanceof ClasspathGroup ? ((ClasspathGroup)element).contains(newEntry) : element.equals(newEntry))) continue;
            return null;
        }
        if (entryParent != null) {
            ((ClasspathGroup)entryParent).addEntry(newEntry, null);
        } else {
            this.childEntries.add(newEntry);
        }
        return newEntry;
    }

    public IClasspathEntry[] getEntries(int entryType) {
        switch (entryType) {
            case 0: {
                if (this.bootstrapEntries == null) break;
                return this.bootstrapEntries.getEntries();
            }
            case 1: {
                if (this.userEntries == null) break;
                return this.userEntries.getEntries();
            }
        }
        return new IClasspathEntry[0];
    }

    public IRuntimeClasspathEntry[] getAllEntries() {
        IClasspathEntry[] boot = this.getEntries(0);
        IClasspathEntry[] user = this.getEntries(1);
        IRuntimeClasspathEntry[] all = new IRuntimeClasspathEntry[boot.length + user.length];
        if (boot.length > 0) {
            System.arraycopy(boot, 0, all, 0, boot.length);
        }
        if (user.length > 0) {
            System.arraycopy(user, 0, all, boot.length, user.length);
        }
        return all;
    }

    public void remove(Object entry) {
        this.childEntries.remove(entry);
    }

    public ClasspathEntry createEntry(IRuntimeClasspathEntry entry, IClasspathEntry entryParent) {
        if (entry instanceof ClasspathEntry) {
            entry = ((ClasspathEntry)entry).getDelegate();
        }
        if (entryParent == null) {
            entryParent = this;
        }
        return new ClasspathEntry(entry, entryParent);
    }

    public void removeAll() {
        if (this.bootstrapEntries != null) {
            this.bootstrapEntries.removeAll();
        }
        if (this.userEntries != null) {
            this.userEntries.removeAll();
        }
    }

    public void removeAll(Object[] entries) {
        int i = 0;
        while (i < entries.length) {
            Object object = entries[i];
            if (object instanceof ClasspathEntry) {
                IClasspathEntry entryParent = ((ClasspathEntry)object).getParent();
                if (entryParent instanceof ClasspathGroup) {
                    ((ClasspathGroup)entryParent).removeEntry((ClasspathEntry)object);
                } else {
                    this.remove(object);
                }
            } else {
                this.remove(object);
            }
            ++i;
        }
    }

    public void setBootstrapEntries(IRuntimeClasspathEntry[] entries) {
        if (this.bootstrapEntries == null) {
            this.getBootstrapEntry();
        }
        this.bootstrapEntries.removeAll();
        int i = 0;
        while (i < entries.length) {
            this.bootstrapEntries.addEntry(new ClasspathEntry(entries[i], this.bootstrapEntries), null);
            ++i;
        }
    }

    private ClasspathGroup createGroupEntry(IRuntimeClasspathEntry[] entries, ClasspathGroup entryParent, String name, boolean canBeRemoved, boolean addEntry) {
        ClasspathGroup group = new ClasspathGroup(name, entryParent, canBeRemoved);
        int i = 0;
        while (i < entries.length) {
            group.addEntry(new ClasspathEntry(entries[i], group), null);
            ++i;
        }
        if (addEntry) {
            this.addEntry(group);
        }
        return group;
    }

    public void setUserEntries(IRuntimeClasspathEntry[] entries) {
        if (this.userEntries == null) {
            this.getUserEntry();
        }
        this.userEntries.removeAll();
        int i = 0;
        while (i < entries.length) {
            this.userEntries.addEntry(new ClasspathEntry(entries[i], this.userEntries), null);
            ++i;
        }
    }

    public IClasspathEntry getBootstrapEntry() {
        if (this.bootstrapEntries == null) {
            String name = ClasspathMessages.ClasspathModel_0;
            this.bootstrapEntries = this.createGroupEntry(new IRuntimeClasspathEntry[0], null, name, false, true);
        }
        return this.bootstrapEntries;
    }

    public IClasspathEntry getUserEntry() {
        if (this.userEntries == null) {
            String name = ClasspathMessages.ClasspathModel_1;
            this.userEntries = this.createGroupEntry(new IRuntimeClasspathEntry[0], null, name, false, true);
        }
        return this.userEntries;
    }

    public ClasspathModel() {
        this.getBootstrapEntry();
        this.getUserEntry();
    }

    public boolean isEditable() {
        return false;
    }
}

